/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRetentionConfigurationRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutRetentionConfigurationRequest> {
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriodInDays").getter(PutRetentionConfigurationRequest.getter(PutRetentionConfigurationRequest::retentionPeriodInDays)).setter(PutRetentionConfigurationRequest.setter(Builder::retentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_IN_DAYS_FIELD));
    private final Integer retentionPeriodInDays;

    private PutRetentionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    public Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionConfigurationRequest)) {
            return false;
        }
        PutRetentionConfigurationRequest other = (PutRetentionConfigurationRequest)((Object)obj);
        return Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    public String toString() {
        return ToString.builder((String)"PutRetentionConfigurationRequest").add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRetentionConfigurationRequest, T> g) {
        return obj -> g.apply((PutRetentionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionConfigurationRequest model) {
            super(model);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionConfigurationRequest build() {
            return new PutRetentionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRetentionConfigurationRequest> {
        public Builder retentionPeriodInDays(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

