/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRetentionConfigurationsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeRetentionConfigurationsResponse.Builder, DescribeRetentionConfigurationsResponse> {
    private static final SdkField<List<RetentionConfiguration>> RETENTION_CONFIGURATIONS_FIELD = SdkField
            .<List<RetentionConfiguration>> builder(MarshallingType.LIST)
            .memberName("RetentionConfigurations")
            .getter(getter(DescribeRetentionConfigurationsResponse::retentionConfigurations))
            .setter(setter(Builder::retentionConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetentionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetentionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRetentionConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RETENTION_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<RetentionConfiguration> retentionConfigurations;

    private final String nextToken;

    private DescribeRetentionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurations = builder.retentionConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RetentionConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRetentionConfigurations() {
        return retentionConfigurations != null && !(retentionConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a retention configuration object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRetentionConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a retention configuration object.
     */
    public List<RetentionConfiguration> retentionConfigurations() {
        return retentionConfigurations;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRetentionConfigurations() ? retentionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetentionConfigurationsResponse)) {
            return false;
        }
        DescribeRetentionConfigurationsResponse other = (DescribeRetentionConfigurationsResponse) obj;
        return hasRetentionConfigurations() == other.hasRetentionConfigurations()
                && Objects.equals(retentionConfigurations(), other.retentionConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRetentionConfigurationsResponse")
                .add("RetentionConfigurations", hasRetentionConfigurations() ? retentionConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionConfigurations":
            return Optional.ofNullable(clazz.cast(retentionConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetentionConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeRetentionConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRetentionConfigurationsResponse> {
        /**
         * <p>
         * Returns a retention configuration object.
         * </p>
         * 
         * @param retentionConfigurations
         *        Returns a retention configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurations(Collection<RetentionConfiguration> retentionConfigurations);

        /**
         * <p>
         * Returns a retention configuration object.
         * </p>
         * 
         * @param retentionConfigurations
         *        Returns a retention configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionConfigurations(RetentionConfiguration... retentionConfigurations);

        /**
         * <p>
         * Returns a retention configuration object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RetentionConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<RetentionConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RetentionConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #retentionConfigurations(List<RetentionConfiguration>)}.
         * 
         * @param retentionConfigurations
         *        a consumer that will call methods on {@link List<RetentionConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionConfigurations(List<RetentionConfiguration>)
         */
        Builder retentionConfigurations(Consumer<RetentionConfiguration.Builder>... retentionConfigurations);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<RetentionConfiguration> retentionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetentionConfigurationsResponse model) {
            super(model);
            retentionConfigurations(model.retentionConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<RetentionConfiguration.Builder> getRetentionConfigurations() {
            if (retentionConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return retentionConfigurations != null ? retentionConfigurations.stream().map(RetentionConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder retentionConfigurations(Collection<RetentionConfiguration> retentionConfigurations) {
            this.retentionConfigurations = RetentionConfigurationListCopier.copy(retentionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurations(RetentionConfiguration... retentionConfigurations) {
            retentionConfigurations(Arrays.asList(retentionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurations(Consumer<RetentionConfiguration.Builder>... retentionConfigurations) {
            retentionConfigurations(Stream.of(retentionConfigurations)
                    .map(c -> RetentionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRetentionConfigurations(Collection<RetentionConfiguration.BuilderImpl> retentionConfigurations) {
            this.retentionConfigurations = RetentionConfigurationListCopier.copyFromBuilder(retentionConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRetentionConfigurationsResponse build() {
            return new DescribeRetentionConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
