/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConformancePackComplianceResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConformancePackComplianceResponse.Builder, DescribeConformancePackComplianceResponse> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(DescribeConformancePackComplianceResponse::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<List<ConformancePackRuleCompliance>> CONFORMANCE_PACK_RULE_COMPLIANCE_LIST_FIELD = SdkField
            .<List<ConformancePackRuleCompliance>> builder(MarshallingType.LIST)
            .memberName("ConformancePackRuleComplianceList")
            .getter(getter(DescribeConformancePackComplianceResponse::conformancePackRuleComplianceList))
            .setter(setter(Builder::conformancePackRuleComplianceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackRuleComplianceList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackRuleCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackRuleCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConformancePackComplianceResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            CONFORMANCE_PACK_RULE_COMPLIANCE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final String conformancePackName;

    private final List<ConformancePackRuleCompliance> conformancePackRuleComplianceList;

    private final String nextToken;

    private DescribeConformancePackComplianceResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackRuleComplianceList = builder.conformancePackRuleComplianceList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Name of the conformance pack.
     * </p>
     * 
     * @return Name of the conformance pack.
     */
    public String conformancePackName() {
        return conformancePackName;
    }

    /**
     * Returns true if the ConformancePackRuleComplianceList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasConformancePackRuleComplianceList() {
        return conformancePackRuleComplianceList != null && !(conformancePackRuleComplianceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>ConformancePackRuleCompliance</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackRuleComplianceList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of <code>ConformancePackRuleCompliance</code> objects.
     */
    public List<ConformancePackRuleCompliance> conformancePackRuleComplianceList() {
        return conformancePackRuleComplianceList;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackRuleComplianceList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConformancePackComplianceResponse)) {
            return false;
        }
        DescribeConformancePackComplianceResponse other = (DescribeConformancePackComplianceResponse) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(conformancePackRuleComplianceList(), other.conformancePackRuleComplianceList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConformancePackComplianceResponse").add("ConformancePackName", conformancePackName())
                .add("ConformancePackRuleComplianceList", conformancePackRuleComplianceList()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ConformancePackRuleComplianceList":
            return Optional.ofNullable(clazz.cast(conformancePackRuleComplianceList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConformancePackComplianceResponse, T> g) {
        return obj -> g.apply((DescribeConformancePackComplianceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConformancePackComplianceResponse> {
        /**
         * <p>
         * Name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * Returns a list of <code>ConformancePackRuleCompliance</code> objects.
         * </p>
         * 
         * @param conformancePackRuleComplianceList
         *        Returns a list of <code>ConformancePackRuleCompliance</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackRuleComplianceList(Collection<ConformancePackRuleCompliance> conformancePackRuleComplianceList);

        /**
         * <p>
         * Returns a list of <code>ConformancePackRuleCompliance</code> objects.
         * </p>
         * 
         * @param conformancePackRuleComplianceList
         *        Returns a list of <code>ConformancePackRuleCompliance</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackRuleComplianceList(ConformancePackRuleCompliance... conformancePackRuleComplianceList);

        /**
         * <p>
         * Returns a list of <code>ConformancePackRuleCompliance</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackRuleCompliance>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackRuleCompliance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackRuleCompliance>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackRuleComplianceList(List<ConformancePackRuleCompliance>)}.
         * 
         * @param conformancePackRuleComplianceList
         *        a consumer that will call methods on {@link List<ConformancePackRuleCompliance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackRuleComplianceList(List<ConformancePackRuleCompliance>)
         */
        Builder conformancePackRuleComplianceList(
                Consumer<ConformancePackRuleCompliance.Builder>... conformancePackRuleComplianceList);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String conformancePackName;

        private List<ConformancePackRuleCompliance> conformancePackRuleComplianceList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConformancePackComplianceResponse model) {
            super(model);
            conformancePackName(model.conformancePackName);
            conformancePackRuleComplianceList(model.conformancePackRuleComplianceList);
            nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final Collection<ConformancePackRuleCompliance.Builder> getConformancePackRuleComplianceList() {
            return conformancePackRuleComplianceList != null ? conformancePackRuleComplianceList.stream()
                    .map(ConformancePackRuleCompliance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackRuleComplianceList(
                Collection<ConformancePackRuleCompliance> conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList = ConformancePackRuleComplianceListCopier
                    .copy(conformancePackRuleComplianceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleComplianceList(ConformancePackRuleCompliance... conformancePackRuleComplianceList) {
            conformancePackRuleComplianceList(Arrays.asList(conformancePackRuleComplianceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleComplianceList(
                Consumer<ConformancePackRuleCompliance.Builder>... conformancePackRuleComplianceList) {
            conformancePackRuleComplianceList(Stream.of(conformancePackRuleComplianceList)
                    .map(c -> ConformancePackRuleCompliance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackRuleComplianceList(
                Collection<ConformancePackRuleCompliance.BuilderImpl> conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList = ConformancePackRuleComplianceListCopier
                    .copyFromBuilder(conformancePackRuleComplianceList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConformancePackComplianceResponse build() {
            return new DescribeConformancePackComplianceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
