/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.MemberAccountRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberAccountStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberAccountStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(MemberAccountStatus.getter(MemberAccountStatus::accountId)).setter(MemberAccountStatus.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(MemberAccountStatus.getter(MemberAccountStatus::configRuleName)).setter(MemberAccountStatus.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberAccountRuleStatus").getter(MemberAccountStatus.getter(MemberAccountStatus::memberAccountRuleStatusAsString)).setter(MemberAccountStatus.setter(Builder::memberAccountRuleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountRuleStatus").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(MemberAccountStatus.getter(MemberAccountStatus::errorCode)).setter(MemberAccountStatus.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(MemberAccountStatus.getter(MemberAccountStatus::errorMessage)).setter(MemberAccountStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(MemberAccountStatus.getter(MemberAccountStatus::lastUpdateTime)).setter(MemberAccountStatus.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONFIG_RULE_NAME_FIELD, MEMBER_ACCOUNT_RULE_STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String configRuleName;
    private final String memberAccountRuleStatus;
    private final String errorCode;
    private final String errorMessage;
    private final Instant lastUpdateTime;

    private MemberAccountStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.configRuleName = builder.configRuleName;
        this.memberAccountRuleStatus = builder.memberAccountRuleStatus;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final MemberAccountRuleStatus memberAccountRuleStatus() {
        return MemberAccountRuleStatus.fromValue(this.memberAccountRuleStatus);
    }

    public final String memberAccountRuleStatusAsString() {
        return this.memberAccountRuleStatus;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountRuleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccountStatus)) {
            return false;
        }
        MemberAccountStatus other = (MemberAccountStatus)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.memberAccountRuleStatusAsString(), other.memberAccountRuleStatusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"MemberAccountStatus").add("AccountId", (Object)this.accountId()).add("ConfigRuleName", (Object)this.configRuleName()).add("MemberAccountRuleStatus", (Object)this.memberAccountRuleStatusAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "MemberAccountRuleStatus": {
                return Optional.ofNullable(clazz.cast(this.memberAccountRuleStatusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberAccountStatus, T> g) {
        return obj -> g.apply((MemberAccountStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String configRuleName;
        private String memberAccountRuleStatus;
        private String errorCode;
        private String errorMessage;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccountStatus model) {
            this.accountId(model.accountId);
            this.configRuleName(model.configRuleName);
            this.memberAccountRuleStatus(model.memberAccountRuleStatus);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getMemberAccountRuleStatus() {
            return this.memberAccountRuleStatus;
        }

        @Override
        public final Builder memberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
            return this;
        }

        @Override
        public final Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus) {
            this.memberAccountRuleStatus(memberAccountRuleStatus == null ? null : memberAccountRuleStatus.toString());
            return this;
        }

        public final void setMemberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public MemberAccountStatus build() {
            return new MemberAccountStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberAccountStatus> {
        public Builder accountId(String var1);

        public Builder configRuleName(String var1);

        public Builder memberAccountRuleStatus(String var1);

        public Builder memberAccountRuleStatus(MemberAccountRuleStatus var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

