/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters a conformance pack by AWS Config rule names, compliance types, AWS resource types, and resource IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackEvaluationFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackEvaluationFilters.Builder, ConformancePackEvaluationFilters> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigRuleNames")
            .getter(getter(ConformancePackEvaluationFilters::configRuleNames))
            .setter(setter(Builder::configRuleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ConformancePackEvaluationFilters::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ConformancePackEvaluationFilters::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIds")
            .getter(getter(ConformancePackEvaluationFilters::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD,
            COMPLIANCE_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> configRuleNames;

    private final String complianceType;

    private final String resourceType;

    private final List<String> resourceIds;

    private ConformancePackEvaluationFilters(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
    }

    /**
     * Returns true if the ConfigRuleNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConfigRuleNames() {
        return configRuleNames != null && !(configRuleNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by AWS Config rule names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigRuleNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results by AWS Config rule names.
     */
    public final List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
     * @see ConformancePackComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>).
     * </p>
     * 
     * @return Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>).
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * Returns true if the ResourceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by resource IDs.
     * </p>
     * <note>
     * <p>
     * This is valid only when you provide resource type. If there is no resource type, you will see an error.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results by resource IDs.</p> <note>
     *         <p>
     *         This is valid only when you provide resource type. If there is no resource type, you will see an error.
     *         </p>
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigRuleNames() ? configRuleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackEvaluationFilters)) {
            return false;
        }
        ConformancePackEvaluationFilters other = (ConformancePackEvaluationFilters) obj;
        return hasConfigRuleNames() == other.hasConfigRuleNames() && Objects.equals(configRuleNames(), other.configRuleNames())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(resourceType(), other.resourceType()) && hasResourceIds() == other.hasResourceIds()
                && Objects.equals(resourceIds(), other.resourceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConformancePackEvaluationFilters")
                .add("ConfigRuleNames", hasConfigRuleNames() ? configRuleNames() : null)
                .add("ComplianceType", complianceTypeAsString()).add("ResourceType", resourceType())
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleNames":
            return Optional.ofNullable(clazz.cast(configRuleNames()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackEvaluationFilters, T> g) {
        return obj -> g.apply((ConformancePackEvaluationFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackEvaluationFilters> {
        /**
         * <p>
         * Filters the results by AWS Config rule names.
         * </p>
         * 
         * @param configRuleNames
         *        Filters the results by AWS Config rule names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * Filters the results by AWS Config rule names.
         * </p>
         * 
         * @param configRuleNames
         *        Filters the results by AWS Config rule names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * </p>
         * 
         * @param complianceType
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);

        /**
         * <p>
         * Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>).
         * </p>
         * 
         * @param resourceType
         *        Filters the results by the resource type (for example, <code>"AWS::EC2::Instance"</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Filters the results by resource IDs.
         * </p>
         * <note>
         * <p>
         * This is valid only when you provide resource type. If there is no resource type, you will see an error.
         * </p>
         * </note>
         * 
         * @param resourceIds
         *        Filters the results by resource IDs.</p> <note>
         *        <p>
         *        This is valid only when you provide resource type. If there is no resource type, you will see an
         *        error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * Filters the results by resource IDs.
         * </p>
         * <note>
         * <p>
         * This is valid only when you provide resource type. If there is no resource type, you will see an error.
         * </p>
         * </note>
         * 
         * @param resourceIds
         *        Filters the results by resource IDs.</p> <note>
         *        <p>
         *        This is valid only when you provide resource type. If there is no resource type, you will see an
         *        error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();

        private String complianceType;

        private String resourceType;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackEvaluationFilters model) {
            configRuleNames(model.configRuleNames);
            complianceType(model.complianceType);
            resourceType(model.resourceType);
            resourceIds(model.resourceIds);
        }

        public final Collection<String> getConfigRuleNames() {
            if (configRuleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ConformancePackComplianceResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ConformancePackComplianceResourceIdsCopier.copy(resourceIds);
        }

        @Override
        public ConformancePackEvaluationFilters build() {
            return new ConformancePackEvaluationFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
