/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetResourceConfigHistory</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceConfigHistoryResponse extends ConfigResponse implements
        ToCopyableBuilder<GetResourceConfigHistoryResponse.Builder, GetResourceConfigHistoryResponse> {
    private static final SdkField<List<ConfigurationItem>> CONFIGURATION_ITEMS_FIELD = SdkField
            .<List<ConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("configurationItems")
            .getter(getter(GetResourceConfigHistoryResponse::configurationItems))
            .setter(setter(Builder::configurationItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetResourceConfigHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ITEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConfigurationItem> configurationItems;

    private final String nextToken;

    private GetResourceConfigHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.configurationItems = builder.configurationItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConfigurationItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConfigurationItems() {
        return configurationItems != null && !(configurationItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the configuration history of one or more resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the configuration history of one or more resources.
     */
    public List<ConfigurationItem> configurationItems() {
        return configurationItems;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryResponse)) {
            return false;
        }
        GetResourceConfigHistoryResponse other = (GetResourceConfigHistoryResponse) obj;
        return Objects.equals(configurationItems(), other.configurationItems()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResourceConfigHistoryResponse").add("ConfigurationItems", configurationItems())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationItems":
            return Optional.ofNullable(clazz.cast(configurationItems()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceConfigHistoryResponse, T> g) {
        return obj -> g.apply((GetResourceConfigHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
        /**
         * <p>
         * A list that contains the configuration history of one or more resources.
         * </p>
         * 
         * @param configurationItems
         *        A list that contains the configuration history of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItems(Collection<ConfigurationItem> configurationItems);

        /**
         * <p>
         * A list that contains the configuration history of one or more resources.
         * </p>
         * 
         * @param configurationItems
         *        A list that contains the configuration history of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItems(ConfigurationItem... configurationItems);

        /**
         * <p>
         * A list that contains the configuration history of one or more resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationItem>.Builder} avoiding the
         * need to create one manually via {@link List<ConfigurationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationItems(List<ConfigurationItem>)}.
         * 
         * @param configurationItems
         *        a consumer that will call methods on {@link List<ConfigurationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationItems(List<ConfigurationItem>)
         */
        Builder configurationItems(Consumer<ConfigurationItem.Builder>... configurationItems);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationItem> configurationItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryResponse model) {
            super(model);
            configurationItems(model.configurationItems);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigurationItem.Builder> getConfigurationItems() {
            return configurationItems != null ? configurationItems.stream().map(ConfigurationItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(ConfigurationItem... configurationItems) {
            configurationItems(Arrays.asList(configurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(Consumer<ConfigurationItem.Builder>... configurationItems) {
            configurationItems(Stream.of(configurationItems).map(c -> ConfigurationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationItems(Collection<ConfigurationItem.BuilderImpl> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copyFromBuilder(configurationItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceConfigHistoryResponse build() {
            return new GetResourceConfigHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
