/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an AWS resource and indicates whether it complies with the AWS Config rule that it was evaluated against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalEvaluation.Builder, ExternalEvaluation> {
    private static final SdkField<String> COMPLIANCE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceResourceType").getter(getter(ExternalEvaluation::complianceResourceType))
            .setter(setter(Builder::complianceResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceType").build())
            .build();

    private static final SdkField<String> COMPLIANCE_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceResourceId").getter(getter(ExternalEvaluation::complianceResourceId))
            .setter(setter(Builder::complianceResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceResourceId").build())
            .build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ExternalEvaluation::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Annotation").getter(getter(ExternalEvaluation::annotation)).setter(setter(Builder::annotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()).build();

    private static final SdkField<Instant> ORDERING_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OrderingTimestamp").getter(getter(ExternalEvaluation::orderingTimestamp))
            .setter(setter(Builder::orderingTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANCE_RESOURCE_TYPE_FIELD, COMPLIANCE_RESOURCE_ID_FIELD, COMPLIANCE_TYPE_FIELD, ANNOTATION_FIELD,
            ORDERING_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceResourceType;

    private final String complianceResourceId;

    private final String complianceType;

    private final String annotation;

    private final Instant orderingTimestamp;

    private ExternalEvaluation(BuilderImpl builder) {
        this.complianceResourceType = builder.complianceResourceType;
        this.complianceResourceId = builder.complianceResourceId;
        this.complianceType = builder.complianceType;
        this.annotation = builder.annotation;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    /**
     * <p>
     * The evaluated compliance resource type. AWS Config accepts <code>AWS::::Account</code> resource type.
     * </p>
     * 
     * @return The evaluated compliance resource type. AWS Config accepts <code>AWS::::Account</code> resource type.
     */
    public final String complianceResourceType() {
        return complianceResourceType;
    }

    /**
     * <p>
     * The evaluated compliance resource ID. AWS Config accepts only AWS account ID.
     * </p>
     * 
     * @return The evaluated compliance resource ID. AWS Config accepts only AWS account ID.
     */
    public final String complianceResourceId() {
        return complianceResourceId;
    }

    /**
     * <p>
     * The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
     * <code>NOT_APPLICABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
     *         <code>NOT_APPLICABLE</code>.
     * @see ComplianceType
     */
    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
     * <code>NOT_APPLICABLE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
     *         <code>NOT_APPLICABLE</code>.
     * @see ComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * Supplementary information about the reason of compliance. For example, this task was completed on a specific
     * date.
     * </p>
     * 
     * @return Supplementary information about the reason of compliance. For example, this task was completed on a
     *         specific date.
     */
    public final String annotation() {
        return annotation;
    }

    /**
     * <p>
     * The time when the compliance was recorded.
     * </p>
     * 
     * @return The time when the compliance was recorded.
     */
    public final Instant orderingTimestamp() {
        return orderingTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(complianceResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(orderingTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalEvaluation)) {
            return false;
        }
        ExternalEvaluation other = (ExternalEvaluation) obj;
        return Objects.equals(complianceResourceType(), other.complianceResourceType())
                && Objects.equals(complianceResourceId(), other.complianceResourceId())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(annotation(), other.annotation())
                && Objects.equals(orderingTimestamp(), other.orderingTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalEvaluation").add("ComplianceResourceType", complianceResourceType())
                .add("ComplianceResourceId", complianceResourceId()).add("ComplianceType", complianceTypeAsString())
                .add("Annotation", annotation()).add("OrderingTimestamp", orderingTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceResourceType":
            return Optional.ofNullable(clazz.cast(complianceResourceType()));
        case "ComplianceResourceId":
            return Optional.ofNullable(clazz.cast(complianceResourceId()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "Annotation":
            return Optional.ofNullable(clazz.cast(annotation()));
        case "OrderingTimestamp":
            return Optional.ofNullable(clazz.cast(orderingTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalEvaluation, T> g) {
        return obj -> g.apply((ExternalEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalEvaluation> {
        /**
         * <p>
         * The evaluated compliance resource type. AWS Config accepts <code>AWS::::Account</code> resource type.
         * </p>
         * 
         * @param complianceResourceType
         *        The evaluated compliance resource type. AWS Config accepts <code>AWS::::Account</code> resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceType(String complianceResourceType);

        /**
         * <p>
         * The evaluated compliance resource ID. AWS Config accepts only AWS account ID.
         * </p>
         * 
         * @param complianceResourceId
         *        The evaluated compliance resource ID. AWS Config accepts only AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceId(String complianceResourceId);

        /**
         * <p>
         * The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
         * <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceType
         *        The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
         *        <code>NOT_APPLICABLE</code>.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
         * <code>NOT_APPLICABLE</code>.
         * </p>
         * 
         * @param complianceType
         *        The compliance of the AWS resource. The valid values are <code>COMPLIANT, NON_COMPLIANT, </code> and
         *        <code>NOT_APPLICABLE</code>.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * Supplementary information about the reason of compliance. For example, this task was completed on a specific
         * date.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about the reason of compliance. For example, this task was completed on a
         *        specific date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * The time when the compliance was recorded.
         * </p>
         * 
         * @param orderingTimestamp
         *        The time when the compliance was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingTimestamp(Instant orderingTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String complianceResourceType;

        private String complianceResourceId;

        private String complianceType;

        private String annotation;

        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalEvaluation model) {
            complianceResourceType(model.complianceResourceType);
            complianceResourceId(model.complianceResourceId);
            complianceType(model.complianceType);
            annotation(model.annotation);
            orderingTimestamp(model.orderingTimestamp);
        }

        public final String getComplianceResourceType() {
            return complianceResourceType;
        }

        @Override
        public final Builder complianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
            return this;
        }

        public final void setComplianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
        }

        public final String getComplianceResourceId() {
            return complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final Instant getOrderingTimestamp() {
            return orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        @Override
        public ExternalEvaluation build() {
            return new ExternalEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
