/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.config.model.ExecutionControls;
import software.amazon.awssdk.services.config.model.RemediationParameterValue;
import software.amazon.awssdk.services.config.model.RemediationParametersCopier;
import software.amazon.awssdk.services.config.model.RemediationTargetType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemediationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemediationConfiguration> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(RemediationConfiguration.getter(RemediationConfiguration::configRuleName)).setter(RemediationConfiguration.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(RemediationConfiguration.getter(RemediationConfiguration::targetTypeAsString)).setter(RemediationConfiguration.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(RemediationConfiguration.getter(RemediationConfiguration::targetId)).setter(RemediationConfiguration.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVersion").getter(RemediationConfiguration.getter(RemediationConfiguration::targetVersion)).setter(RemediationConfiguration.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Map<String, RemediationParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(RemediationConfiguration.getter(RemediationConfiguration::parameters)).setter(RemediationConfiguration.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(RemediationConfiguration.getter(RemediationConfiguration::resourceType)).setter(RemediationConfiguration.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Automatic").getter(RemediationConfiguration.getter(RemediationConfiguration::automatic)).setter(RemediationConfiguration.setter(Builder::automatic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automatic").build()}).build();
    private static final SdkField<ExecutionControls> EXECUTION_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionControls").getter(RemediationConfiguration.getter(RemediationConfiguration::executionControls)).setter(RemediationConfiguration.setter(Builder::executionControls)).constructor(ExecutionControls::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionControls").build()}).build();
    private static final SdkField<Integer> MAXIMUM_AUTOMATIC_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumAutomaticAttempts").getter(RemediationConfiguration.getter(RemediationConfiguration::maximumAutomaticAttempts)).setter(RemediationConfiguration.setter(Builder::maximumAutomaticAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumAutomaticAttempts").build()}).build();
    private static final SdkField<Long> RETRY_ATTEMPT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RetryAttemptSeconds").getter(RemediationConfiguration.getter(RemediationConfiguration::retryAttemptSeconds)).setter(RemediationConfiguration.setter(Builder::retryAttemptSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttemptSeconds").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RemediationConfiguration.getter(RemediationConfiguration::arn)).setter(RemediationConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByService").getter(RemediationConfiguration.getter(RemediationConfiguration::createdByService)).setter(RemediationConfiguration.setter(Builder::createdByService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, TARGET_TYPE_FIELD, TARGET_ID_FIELD, TARGET_VERSION_FIELD, PARAMETERS_FIELD, RESOURCE_TYPE_FIELD, AUTOMATIC_FIELD, EXECUTION_CONTROLS_FIELD, MAXIMUM_AUTOMATIC_ATTEMPTS_FIELD, RETRY_ATTEMPT_SECONDS_FIELD, ARN_FIELD, CREATED_BY_SERVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String targetType;
    private final String targetId;
    private final String targetVersion;
    private final Map<String, RemediationParameterValue> parameters;
    private final String resourceType;
    private final Boolean automatic;
    private final ExecutionControls executionControls;
    private final Integer maximumAutomaticAttempts;
    private final Long retryAttemptSeconds;
    private final String arn;
    private final String createdByService;

    private RemediationConfiguration(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.targetVersion = builder.targetVersion;
        this.parameters = builder.parameters;
        this.resourceType = builder.resourceType;
        this.automatic = builder.automatic;
        this.executionControls = builder.executionControls;
        this.maximumAutomaticAttempts = builder.maximumAutomaticAttempts;
        this.retryAttemptSeconds = builder.retryAttemptSeconds;
        this.arn = builder.arn;
        this.createdByService = builder.createdByService;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final RemediationTargetType targetType() {
        return RemediationTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, RemediationParameterValue> parameters() {
        return this.parameters;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Boolean automatic() {
        return this.automatic;
    }

    public final ExecutionControls executionControls() {
        return this.executionControls;
    }

    public final Integer maximumAutomaticAttempts() {
        return this.maximumAutomaticAttempts;
    }

    public final Long retryAttemptSeconds() {
        return this.retryAttemptSeconds;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdByService() {
        return this.createdByService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatic());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionControls());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumAutomaticAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAttemptSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByService());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetVersion(), other.targetVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.automatic(), other.automatic()) && Objects.equals(this.executionControls(), other.executionControls()) && Objects.equals(this.maximumAutomaticAttempts(), other.maximumAutomaticAttempts()) && Objects.equals(this.retryAttemptSeconds(), other.retryAttemptSeconds()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdByService(), other.createdByService());
    }

    public final String toString() {
        return ToString.builder((String)"RemediationConfiguration").add("ConfigRuleName", (Object)this.configRuleName()).add("TargetType", (Object)this.targetTypeAsString()).add("TargetId", (Object)this.targetId()).add("TargetVersion", (Object)this.targetVersion()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ResourceType", (Object)this.resourceType()).add("Automatic", (Object)this.automatic()).add("ExecutionControls", (Object)this.executionControls()).add("MaximumAutomaticAttempts", (Object)this.maximumAutomaticAttempts()).add("RetryAttemptSeconds", (Object)this.retryAttemptSeconds()).add("Arn", (Object)this.arn()).add("CreatedByService", (Object)this.createdByService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Automatic": {
                return Optional.ofNullable(clazz.cast(this.automatic()));
            }
            case "ExecutionControls": {
                return Optional.ofNullable(clazz.cast(this.executionControls()));
            }
            case "MaximumAutomaticAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumAutomaticAttempts()));
            }
            case "RetryAttemptSeconds": {
                return Optional.ofNullable(clazz.cast(this.retryAttemptSeconds()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedByService": {
                return Optional.ofNullable(clazz.cast(this.createdByService()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationConfiguration, T> g) {
        return obj -> g.apply((RemediationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String targetType;
        private String targetId;
        private String targetVersion;
        private Map<String, RemediationParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String resourceType;
        private Boolean automatic;
        private ExecutionControls executionControls;
        private Integer maximumAutomaticAttempts;
        private Long retryAttemptSeconds;
        private String arn;
        private String createdByService;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationConfiguration model) {
            this.configRuleName(model.configRuleName);
            this.targetType(model.targetType);
            this.targetId(model.targetId);
            this.targetVersion(model.targetVersion);
            this.parameters(model.parameters);
            this.resourceType(model.resourceType);
            this.automatic(model.automatic);
            this.executionControls(model.executionControls);
            this.maximumAutomaticAttempts(model.maximumAutomaticAttempts);
            this.retryAttemptSeconds(model.retryAttemptSeconds);
            this.arn(model.arn);
            this.createdByService(model.createdByService);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RemediationTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Map<String, RemediationParameterValue.Builder> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters != null ? CollectionUtils.mapValues(this.parameters, RemediationParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, RemediationParameterValue> parameters) {
            this.parameters = RemediationParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, RemediationParameterValue.BuilderImpl> parameters) {
            this.parameters = RemediationParametersCopier.copyFromBuilder(parameters);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Boolean getAutomatic() {
            return this.automatic;
        }

        @Override
        public final Builder automatic(Boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        public final void setAutomatic(Boolean automatic) {
            this.automatic = automatic;
        }

        public final ExecutionControls.Builder getExecutionControls() {
            return this.executionControls != null ? this.executionControls.toBuilder() : null;
        }

        @Override
        public final Builder executionControls(ExecutionControls executionControls) {
            this.executionControls = executionControls;
            return this;
        }

        public final void setExecutionControls(ExecutionControls.BuilderImpl executionControls) {
            this.executionControls = executionControls != null ? executionControls.build() : null;
        }

        public final Integer getMaximumAutomaticAttempts() {
            return this.maximumAutomaticAttempts;
        }

        @Override
        public final Builder maximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
            this.maximumAutomaticAttempts = maximumAutomaticAttempts;
            return this;
        }

        public final void setMaximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
            this.maximumAutomaticAttempts = maximumAutomaticAttempts;
        }

        public final Long getRetryAttemptSeconds() {
            return this.retryAttemptSeconds;
        }

        @Override
        public final Builder retryAttemptSeconds(Long retryAttemptSeconds) {
            this.retryAttemptSeconds = retryAttemptSeconds;
            return this;
        }

        public final void setRetryAttemptSeconds(Long retryAttemptSeconds) {
            this.retryAttemptSeconds = retryAttemptSeconds;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreatedByService() {
            return this.createdByService;
        }

        @Override
        public final Builder createdByService(String createdByService) {
            this.createdByService = createdByService;
            return this;
        }

        public final void setCreatedByService(String createdByService) {
            this.createdByService = createdByService;
        }

        public RemediationConfiguration build() {
            return new RemediationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemediationConfiguration> {
        public Builder configRuleName(String var1);

        public Builder targetType(String var1);

        public Builder targetType(RemediationTargetType var1);

        public Builder targetId(String var1);

        public Builder targetVersion(String var1);

        public Builder parameters(Map<String, RemediationParameterValue> var1);

        public Builder resourceType(String var1);

        public Builder automatic(Boolean var1);

        public Builder executionControls(ExecutionControls var1);

        default public Builder executionControls(Consumer<ExecutionControls.Builder> executionControls) {
            return this.executionControls((ExecutionControls)((ExecutionControls.Builder)ExecutionControls.builder().applyMutation(executionControls)).build());
        }

        public Builder maximumAutomaticAttempts(Integer var1);

        public Builder retryAttemptSeconds(Long var1);

        public Builder arn(String var1);

        public Builder createdByService(String var1);
    }
}

