/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Organization config rule creation or deletion status in each member account. This includes the name of the rule, the
 * status, error code and error message when the rule creation or deletion failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberAccountStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberAccountStatus.Builder, MemberAccountStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MemberAccountStatus::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(MemberAccountStatus::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccountRuleStatus").getter(getter(MemberAccountStatus::memberAccountRuleStatusAsString))
            .setter(setter(Builder::memberAccountRuleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountRuleStatus").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(MemberAccountStatus::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(MemberAccountStatus::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(MemberAccountStatus::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CONFIG_RULE_NAME_FIELD, MEMBER_ACCOUNT_RULE_STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String configRuleName;

    private final String memberAccountRuleStatus;

    private final String errorCode;

    private final String errorMessage;

    private final Instant lastUpdateTime;

    private MemberAccountStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.configRuleName = builder.configRuleName;
        this.memberAccountRuleStatus = builder.memberAccountRuleStatus;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The 12-digit account ID of a member account.
     * </p>
     * 
     * @return The 12-digit account ID of a member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of config rule deployed in the member account.
     * </p>
     * 
     * @return The name of config rule deployed in the member account.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Indicates deployment status for config rule in the member account. When master account calls
     * <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member
     * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule
     * status is updated in the member account. Config rule status is deleted when the master account deletes
     * <code>OrganizationConfigRule</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountRuleStatus} will return {@link MemberAccountRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #memberAccountRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for config rule in the member account. When master account calls
     *         <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the
     *         member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
     *         time, config rule status is updated in the member account. Config rule status is deleted when the master
     *         account deletes <code>OrganizationConfigRule</code> and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         AWS Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see MemberAccountRuleStatus
     */
    public final MemberAccountRuleStatus memberAccountRuleStatus() {
        return MemberAccountRuleStatus.fromValue(memberAccountRuleStatus);
    }

    /**
     * <p>
     * Indicates deployment status for config rule in the member account. When master account calls
     * <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member
     * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config rule
     * status is updated in the member account. Config rule status is deleted when the master account deletes
     * <code>OrganizationConfigRule</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountRuleStatus} will return {@link MemberAccountRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #memberAccountRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for config rule in the member account. When master account calls
     *         <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the
     *         member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
     *         time, config rule status is updated in the member account. Config rule status is deleted when the master
     *         account deletes <code>OrganizationConfigRule</code> and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         AWS Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see MemberAccountRuleStatus
     */
    public final String memberAccountRuleStatusAsString() {
        return memberAccountRuleStatus;
    }

    /**
     * <p>
     * An error code that is returned when config rule creation or deletion failed in the member account.
     * </p>
     * 
     * @return An error code that is returned when config rule creation or deletion failed in the member account.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message indicating that config rule account creation or deletion has failed due to an error in the
     * member account.
     * </p>
     * 
     * @return An error message indicating that config rule account creation or deletion has failed due to an error in
     *         the member account.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp of the last status update.
     * </p>
     * 
     * @return The timestamp of the last status update.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountRuleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccountStatus)) {
            return false;
        }
        MemberAccountStatus other = (MemberAccountStatus) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(memberAccountRuleStatusAsString(), other.memberAccountRuleStatusAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberAccountStatus").add("AccountId", accountId()).add("ConfigRuleName", configRuleName())
                .add("MemberAccountRuleStatus", memberAccountRuleStatusAsString()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "MemberAccountRuleStatus":
            return Optional.ofNullable(clazz.cast(memberAccountRuleStatusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberAccountStatus, T> g) {
        return obj -> g.apply((MemberAccountStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberAccountStatus> {
        /**
         * <p>
         * The 12-digit account ID of a member account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of config rule deployed in the member account.
         * </p>
         * 
         * @param configRuleName
         *        The name of config rule deployed in the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Indicates deployment status for config rule in the member account. When master account calls
         * <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member
         * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config
         * rule status is updated in the member account. Config rule status is deleted when the master account deletes
         * <code>OrganizationConfigRule</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memberAccountRuleStatus
         *        Indicates deployment status for config rule in the member account. When master account calls
         *        <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the
         *        member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
         *        time, config rule status is updated in the member account. Config rule status is deleted when the
         *        master account deletes <code>OrganizationConfigRule</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        AWS Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see MemberAccountRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountRuleStatus
         */
        Builder memberAccountRuleStatus(String memberAccountRuleStatus);

        /**
         * <p>
         * Indicates deployment status for config rule in the member account. When master account calls
         * <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the member
         * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, config
         * rule status is updated in the member account. Config rule status is deleted when the master account deletes
         * <code>OrganizationConfigRule</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memberAccountRuleStatus
         *        Indicates deployment status for config rule in the member account. When master account calls
         *        <code>PutOrganizationConfigRule</code> action for the first time, config rule status is created in the
         *        member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
         *        time, config rule status is updated in the member account. Config rule status is deleted when the
         *        master account deletes <code>OrganizationConfigRule</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        AWS Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when config rule has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when config rule is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when config rule creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when config rule is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when config rule has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when config rule has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when config rule is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see MemberAccountRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountRuleStatus
         */
        Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus);

        /**
         * <p>
         * An error code that is returned when config rule creation or deletion failed in the member account.
         * </p>
         * 
         * @param errorCode
         *        An error code that is returned when config rule creation or deletion failed in the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message indicating that config rule account creation or deletion has failed due to an error in the
         * member account.
         * </p>
         * 
         * @param errorMessage
         *        An error message indicating that config rule account creation or deletion has failed due to an error
         *        in the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp of the last status update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The timestamp of the last status update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String configRuleName;

        private String memberAccountRuleStatus;

        private String errorCode;

        private String errorMessage;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccountStatus model) {
            accountId(model.accountId);
            configRuleName(model.configRuleName);
            memberAccountRuleStatus(model.memberAccountRuleStatus);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getMemberAccountRuleStatus() {
            return memberAccountRuleStatus;
        }

        @Override
        public final Builder memberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
            return this;
        }

        @Override
        public final Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus) {
            this.memberAccountRuleStatus(memberAccountRuleStatus == null ? null : memberAccountRuleStatus.toString());
            return this;
        }

        public final void setMemberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public MemberAccountStatus build() {
            return new MemberAccountStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
