/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DeliverConfigSnapshot</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliverConfigSnapshotRequest extends ConfigRequest implements
        ToCopyableBuilder<DeliverConfigSnapshotRequest.Builder, DeliverConfigSnapshotRequest> {
    private static final SdkField<String> DELIVERY_CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryChannelName").getter(getter(DeliverConfigSnapshotRequest::deliveryChannelName))
            .setter(setter(Builder::deliveryChannelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryChannelName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_CHANNEL_NAME_FIELD));

    private final String deliveryChannelName;

    private DeliverConfigSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelName = builder.deliveryChannelName;
    }

    /**
     * <p>
     * The name of the delivery channel through which the snapshot is delivered.
     * </p>
     * 
     * @return The name of the delivery channel through which the snapshot is delivered.
     */
    public final String deliveryChannelName() {
        return deliveryChannelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryChannelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverConfigSnapshotRequest)) {
            return false;
        }
        DeliverConfigSnapshotRequest other = (DeliverConfigSnapshotRequest) obj;
        return Objects.equals(deliveryChannelName(), other.deliveryChannelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliverConfigSnapshotRequest").add("DeliveryChannelName", deliveryChannelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryChannelName":
            return Optional.ofNullable(clazz.cast(deliveryChannelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliverConfigSnapshotRequest, T> g) {
        return obj -> g.apply((DeliverConfigSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeliverConfigSnapshotRequest> {
        /**
         * <p>
         * The name of the delivery channel through which the snapshot is delivered.
         * </p>
         * 
         * @param deliveryChannelName
         *        The name of the delivery channel through which the snapshot is delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelName(String deliveryChannelName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String deliveryChannelName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverConfigSnapshotRequest model) {
            super(model);
            deliveryChannelName(model.deliveryChannelName);
        }

        public final String getDeliveryChannelName() {
            return deliveryChannelName;
        }

        @Override
        public final Builder deliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
            return this;
        }

        public final void setDeliveryChannelName(String deliveryChannelName) {
            this.deliveryChannelName = deliveryChannelName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeliverConfigSnapshotRequest build() {
            return new DeliverConfigSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
