/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable;
import software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable;
import software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigIterable;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackComplianceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRuleStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePackStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceDetailsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConfigRuleDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConformancePackDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListStoredQueriesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutExternalEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartRemediationExecutionRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ConfigClient}.
 *
 * @see ConfigClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConfigClient implements ConfigClient {
    private static final Logger log = Logger.loggerFor(DefaultConfigClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your AWS Config aggregator. The
     * operation also returns a list of resources that are not processed in the current request. If there are no
     * unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return Result of the BatchGetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetAggregateResourceConfigResponse batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) throws ValidationException,
            NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetAggregateResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAggregateResourceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetAggregateResourceConfigRequest, BatchGetAggregateResourceConfigResponse>()
                            .withOperationName("BatchGetAggregateResourceConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(batchGetAggregateResourceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetAggregateResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the current configuration for one or more requested resources. The operation also returns a list of
     * resources that are not processed in the current request. If there are no unprocessed resources, the operation
     * returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return Result of the BatchGetResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetResourceConfigResponse batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest)
            throws ValidationException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetResourceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetResourceConfigRequest, BatchGetResourceConfigResponse>()
                            .withOperationName("BatchGetResourceConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(batchGetResourceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return Result of the DeleteAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAggregationAuthorizationResponse deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAggregationAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAggregationAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAggregationAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAggregationAuthorization");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAggregationAuthorizationRequest, DeleteAggregationAuthorizationResponse>()
                            .withOperationName("DeleteAggregationAuthorization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAggregationAuthorizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAggregationAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified AWS Config rule and all of its evaluation results.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a
     * rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request
     * for the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     *
     * @param deleteConfigRuleRequest
     * @return Result of the DeleteConfigRule operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteConfigRuleResponse deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigRule");

            return clientHandler.execute(new ClientExecutionParams<DeleteConfigRuleRequest, DeleteConfigRuleResponse>()
                    .withOperationName("DeleteConfigRule").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConfigRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return Result of the DeleteConfigurationAggregator operation returned by the service.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfigurationAggregatorResponse deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest)
            throws NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfigurationAggregatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfigurationAggregatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfigurationAggregatorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationAggregator");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationAggregatorRequest, DeleteConfigurationAggregatorResponse>()
                            .withOperationName("DeleteConfigurationAggregator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteConfigurationAggregatorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfigurationAggregatorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, AWS Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the AWS Config console until you create a new configuration
     * recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return Result of the DeleteConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfigurationRecorderResponse deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfigurationRecorderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationRecorder");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationRecorderRequest, DeleteConfigurationRecorderResponse>()
                            .withOperationName("DeleteConfigurationRecorder").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteConfigurationRecorderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfigurationRecorderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the AWS Config rules, remediation actions, and all evaluation
     * results within that conformance pack.
     * </p>
     * <p>
     * AWS Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You
     * cannot update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteConformancePackRequest
     * @return Result of the DeleteConformancePack operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteConformancePackResponse deleteConformancePack(DeleteConformancePackRequest deleteConformancePackRequest)
            throws NoSuchConformancePackException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConformancePackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConformancePackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConformancePack");

            return clientHandler.execute(new ClientExecutionParams<DeleteConformancePackRequest, DeleteConformancePackResponse>()
                    .withOperationName("DeleteConformancePack").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConformancePackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConformancePackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return Result of the DeleteDeliveryChannel operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws LastDeliveryChannelDeleteFailedException
     *         You cannot delete the delivery channel you specified because the configuration recorder is running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDeliveryChannelResponse deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest)
            throws NoSuchDeliveryChannelException, LastDeliveryChannelDeleteFailedException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeliveryChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliveryChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliveryChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeliveryChannelRequest, DeleteDeliveryChannelResponse>()
                    .withOperationName("DeleteDeliveryChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeliveryChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeliveryChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified AWS Config rule. You can specify one AWS Config rule per
     * request. After you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start
     * evaluating your AWS resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return Result of the DeleteEvaluationResults operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEvaluationResultsResponse deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEvaluationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEvaluationResultsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEvaluationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvaluationResults");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEvaluationResultsRequest, DeleteEvaluationResultsResponse>()
                            .withOperationName("DeleteEvaluationResults").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEvaluationResultsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEvaluationResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified organization config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator account can delete an organization config rule. When calling
     * this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a
     * rule while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return Result of the DeleteOrganizationConfigRule operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         You specified one or more organization config rules that do not exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOrganizationConfigRuleResponse deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest)
            throws NoSuchOrganizationConfigRuleException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOrganizationConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOrganizationConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOrganizationConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConfigRuleRequest, DeleteOrganizationConfigRuleResponse>()
                            .withOperationName("DeleteOrganizationConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteOrganizationConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOrganizationConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a master account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return Result of the DeleteOrganizationConformancePack operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         AWS Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOrganizationConformancePackResponse deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest)
            throws NoSuchOrganizationConformancePackException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOrganizationConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOrganizationConformancePackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConformancePack");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConformancePackRequest, DeleteOrganizationConformancePackResponse>()
                            .withOperationName("DeleteOrganizationConformancePack").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteOrganizationConformancePackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOrganizationConformancePackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return Result of the DeletePendingAggregationRequest operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePendingAggregationRequestResponse deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePendingAggregationRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePendingAggregationRequestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePendingAggregationRequestRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePendingAggregationRequest");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePendingAggregationRequestRequest, DeletePendingAggregationRequestResponse>()
                            .withOperationName("DeletePendingAggregationRequest").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deletePendingAggregationRequestRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePendingAggregationRequestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return Result of the DeleteRemediationConfiguration operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an AWS Config rule without a remediation configuration.
     * @throws RemediationInProgressException
     *         Remediation action is in progress. You can either cancel execution in AWS Systems Manager or wait and try
     *         again later.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRemediationConfigurationResponse deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest)
            throws NoSuchRemediationConfigurationException, RemediationInProgressException, InsufficientPermissionsException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRemediationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRemediationConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRemediationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationConfigurationRequest, DeleteRemediationConfigurationResponse>()
                            .withOperationName("DeleteRemediationConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRemediationConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRemediationConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return Result of the DeleteRemediationExceptions operation returned by the service.
     * @throws NoSuchRemediationExceptionException
     *         You tried to delete a remediation exception that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRemediationExceptionsResponse deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) throws NoSuchRemediationExceptionException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRemediationExceptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRemediationExceptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationExceptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationExceptionsRequest, DeleteRemediationExceptionsResponse>()
                            .withOperationName("DeleteRemediationExceptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRemediationExceptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRemediationExceptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your AWS Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return Result of the DeleteResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteResourceConfigResponse deleteResourceConfig(DeleteResourceConfigRequest deleteResourceConfigRequest)
            throws ValidationException, NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceConfig");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourceConfigRequest, DeleteResourceConfigResponse>()
                    .withOperationName("DeleteResourceConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourceConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return Result of the DeleteRetentionConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRetentionConfigurationResponse deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRetentionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRetentionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRetentionConfigurationRequest, DeleteRetentionConfigurationResponse>()
                            .withOperationName("DeleteRetentionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRetentionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRetentionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the stored query for a single AWS account and a single AWS Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return Result of the DeleteStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteStoredQueryResponse deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStoredQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStoredQuery");

            return clientHandler.execute(new ClientExecutionParams<DeleteStoredQueryRequest, DeleteStoredQueryResponse>()
                    .withOperationName("DeleteStoredQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStoredQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStoredQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, AWS Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return Result of the DeliverConfigSnapshot operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeliverConfigSnapshotResponse deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest)
            throws NoSuchDeliveryChannelException, NoAvailableConfigurationRecorderException,
            NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeliverConfigSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeliverConfigSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deliverConfigSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeliverConfigSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResponse>()
                    .withOperationName("DeliverConfigSnapshot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deliverConfigSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeliverConfigSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return Result of the DescribeAggregateComplianceByConfigRules operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAggregateComplianceByConfigRulesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConfigRules");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConfigRulesRequest, DescribeAggregateComplianceByConfigRulesResponse>()
                            .withOperationName("DescribeAggregateComplianceByConfigRules").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAggregateComplianceByConfigRulesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAggregateComplianceByConfigRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant AWS Config rules within each conformance pack.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return Result of the DescribeAggregateComplianceByConformancePacks operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAggregateComplianceByConformancePacksResponse describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAggregateComplianceByConformancePacksResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConformancePacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConformancePacks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConformancePacksRequest, DescribeAggregateComplianceByConformancePacksResponse>()
                            .withOperationName("DescribeAggregateComplianceByConformancePacks")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAggregateComplianceByConformancePacksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAggregateComplianceByConformancePacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return Result of the DescribeAggregationAuthorizations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAggregationAuthorizationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAggregationAuthorizationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregationAuthorizationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregationAuthorizations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregationAuthorizationsRequest, DescribeAggregationAuthorizationsResponse>()
                            .withOperationName("DescribeAggregationAuthorizations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAggregationAuthorizationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAggregationAuthorizationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns
     * the number of AWS resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return Result of the DescribeComplianceByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException,
            NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeComplianceByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeComplianceByConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeComplianceByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResponse>()
                            .withOperationName("DescribeComplianceByConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeComplianceByConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeComplianceByConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Indicates whether the specified AWS resources are compliant. If a resource is noncompliant, this action returns
     * the number of AWS Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the AWS Config rules that evaluate it. It is noncompliant if it
     * does not comply with one or more of these rules.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return Result of the DescribeComplianceByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeComplianceByResourceResponse describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeComplianceByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeComplianceByResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeComplianceByResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResponse>()
                            .withOperationName("DescribeComplianceByResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeComplianceByResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeComplianceByResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns status information for each of your AWS managed Config rules. The status includes information such as the
     * last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error
     * for the last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return Result of the DescribeConfigRuleEvaluationStatus operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigRuleEvaluationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigRuleEvaluationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRuleEvaluationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResponse>()
                            .withOperationName("DescribeConfigRuleEvaluationStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigRuleEvaluationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigRuleEvaluationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about your AWS Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return Result of the DescribeConfigRules operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeConfigRulesResponse describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest)
            throws NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConfigRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRules");

            return clientHandler.execute(new ClientExecutionParams<DescribeConfigRulesRequest, DescribeConfigRulesResponse>()
                    .withOperationName("DescribeConfigRules").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeConfigRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * AWS Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return Result of the DescribeConfigurationAggregatorSourcesStatus operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationAggregatorSourcesStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorSourcesStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregatorSourcesStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorSourcesStatusRequest, DescribeConfigurationAggregatorSourcesStatusResponse>()
                            .withOperationName("DescribeConfigurationAggregatorSourcesStatus")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeConfigurationAggregatorSourcesStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return Result of the DescribeConfigurationAggregators operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationAggregatorsResponse describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationAggregatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigurationAggregatorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregators");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorsRequest, DescribeConfigurationAggregatorsResponse>()
                            .withOperationName("DescribeConfigurationAggregators").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationAggregatorsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationAggregatorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder. If a configuration recorder is not specified,
     * this action returns the status of all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return Result of the DescribeConfigurationRecorderStatus operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationRecorderStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecorderStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorderStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResponse>()
                            .withOperationName("DescribeConfigurationRecorderStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationRecorderStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationRecorderStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return Result of the DescribeConfigurationRecorders operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationRecordersResponse describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationRecordersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigurationRecordersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecordersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorders");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResponse>()
                            .withOperationName("DescribeConfigurationRecorders").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationRecordersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationRecordersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return Result of the DescribeConformancePackCompliance operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchConfigRuleInConformancePackException
     *         AWS Config rule that you passed in the filter does not exist.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConformancePackComplianceResponse describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, NoSuchConfigRuleInConformancePackException,
            NoSuchConformancePackException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConformancePackComplianceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConformancePackComplianceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackComplianceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackCompliance");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackComplianceRequest, DescribeConformancePackComplianceResponse>()
                            .withOperationName("DescribeConformancePackCompliance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConformancePackComplianceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConformancePackComplianceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return Result of the DescribeConformancePackStatus operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConformancePackStatusResponse describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConformancePackStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConformancePackStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackStatusRequest, DescribeConformancePackStatusResponse>()
                            .withOperationName("DescribeConformancePackStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConformancePackStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConformancePackStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return Result of the DescribeConformancePacks operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConformancePacksResponse describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) throws NoSuchConformancePackException,
            InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConformancePacksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConformancePacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConformancePacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePacks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePacksRequest, DescribeConformancePacksResponse>()
                            .withOperationName("DescribeConformancePacks").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConformancePacksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConformancePacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return Result of the DescribeDeliveryChannelStatus operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeliveryChannelStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeliveryChannelStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDeliveryChannelStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannelStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResponse>()
                            .withOperationName("DescribeDeliveryChannelStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDeliveryChannelStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDeliveryChannelStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return Result of the DescribeDeliveryChannels operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDeliveryChannelsResponse describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeliveryChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeliveryChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliveryChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannels");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResponse>()
                            .withOperationName("DescribeDeliveryChannels").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDeliveryChannelsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDeliveryChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides organization config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return Result of the DescribeOrganizationConfigRuleStatuses operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         You specified one or more organization config rules that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrganizationConfigRuleStatusesResponse describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrganizationConfigRuleStatusesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeOrganizationConfigRuleStatusesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRuleStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRuleStatuses");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRuleStatusesRequest, DescribeOrganizationConfigRuleStatusesResponse>()
                            .withOperationName("DescribeOrganizationConfigRuleStatuses").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrganizationConfigRuleStatusesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrganizationConfigRuleStatusesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of organization config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return Result of the DescribeOrganizationConfigRules operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         You specified one or more organization config rules that do not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrganizationConfigRulesResponse describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrganizationConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeOrganizationConfigRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRules");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRulesRequest, DescribeOrganizationConfigRulesResponse>()
                            .withOperationName("DescribeOrganizationConfigRules").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeOrganizationConfigRulesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrganizationConfigRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return Result of the DescribeOrganizationConformancePackStatuses operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         AWS Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrganizationConformancePackStatusesResponse describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrganizationConformancePackStatusesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeOrganizationConformancePackStatusesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePackStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePackStatuses");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConformancePackStatusesRequest, DescribeOrganizationConformancePackStatusesResponse>()
                            .withOperationName("DescribeOrganizationConformancePackStatuses")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrganizationConformancePackStatusesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrganizationConformancePackStatusesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return Result of the DescribeOrganizationConformancePacks operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         AWS Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrganizationConformancePacksResponse describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest)
            throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrganizationConformancePacksResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeOrganizationConformancePacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePacks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConformancePacksRequest, DescribeOrganizationConformancePacksResponse>()
                            .withOperationName("DescribeOrganizationConformancePacks").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrganizationConformancePacksRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrganizationConformancePacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return Result of the DescribePendingAggregationRequests operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePendingAggregationRequestsResponse describePendingAggregationRequests(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePendingAggregationRequestsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePendingAggregationRequestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingAggregationRequestsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingAggregationRequests");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePendingAggregationRequestsRequest, DescribePendingAggregationRequestsResponse>()
                            .withOperationName("DescribePendingAggregationRequests").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePendingAggregationRequestsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePendingAggregationRequestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     * @return Result of the DescribeRemediationConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRemediationConfigurationsResponse describeRemediationConfigurations(
            DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) throws AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRemediationConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRemediationConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationConfigurationsRequest, DescribeRemediationConfigurationsResponse>()
                            .withOperationName("DescribeRemediationConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeRemediationConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRemediationConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note>
     *
     * @param describeRemediationExceptionsRequest
     * @return Result of the DescribeRemediationExceptions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRemediationExceptionsResponse describeRemediationExceptions(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRemediationExceptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationExceptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationExceptionsRequest, DescribeRemediationExceptionsResponse>()
                            .withOperationName("DescribeRemediationExceptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeRemediationExceptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRemediationExceptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client
     *             .describeRemediationExceptionsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRemediationExceptionsIterable describeRemediationExceptionsPaginator(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeRemediationExceptionsIterable(this, applyPaginatorUserAgent(describeRemediationExceptionsRequest));
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return Result of the DescribeRemediationExecutionStatus operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an AWS Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRemediationExecutionStatusResponse describeRemediationExecutionStatus(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRemediationExecutionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRemediationExecutionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationExecutionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationExecutionStatusRequest, DescribeRemediationExecutionStatusResponse>()
                            .withOperationName("DescribeRemediationExecutionStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeRemediationExecutionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRemediationExecutionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client
     *             .describeRemediationExecutionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an AWS Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRemediationExecutionStatusIterable describeRemediationExecutionStatusPaginator(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return new DescribeRemediationExecutionStatusIterable(this,
                applyPaginatorUserAgent(describeRemediationExecutionStatusRequest));
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param describeRetentionConfigurationsRequest
     * @return Result of the DescribeRetentionConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRetentionConfigurationsResponse describeRetentionConfigurations(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRetentionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRetentionConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRetentionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRetentionConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRetentionConfigurationsRequest, DescribeRetentionConfigurationsResponse>()
                            .withOperationName("DescribeRetentionConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeRetentionConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRetentionConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule for a specific resource in a rule. The results
     * indicate which AWS resources were evaluated by the rule, when each resource was last evaluated, and whether each
     * resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return Result of the GetAggregateComplianceDetailsByConfigRule operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRule(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAggregateComplianceDetailsByConfigRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetAggregateComplianceDetailsByConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateComplianceDetailsByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateComplianceDetailsByConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAggregateComplianceDetailsByConfigRuleRequest, GetAggregateComplianceDetailsByConfigRuleResponse>()
                            .withOperationName("GetAggregateComplianceDetailsByConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAggregateComplianceDetailsByConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAggregateComplianceDetailsByConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return Result of the GetAggregateConfigRuleComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAggregateConfigRuleComplianceSummaryResponse getAggregateConfigRuleComplianceSummary(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAggregateConfigRuleComplianceSummaryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetAggregateConfigRuleComplianceSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateConfigRuleComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateConfigRuleComplianceSummary");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAggregateConfigRuleComplianceSummaryRequest, GetAggregateConfigRuleComplianceSummaryResponse>()
                            .withOperationName("GetAggregateConfigRuleComplianceSummary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAggregateConfigRuleComplianceSummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAggregateConfigRuleComplianceSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all AWS Accounts and AWS Regions. You
     * can filter based on AWS Account ID or AWS Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return Result of the GetAggregateConformancePackComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAggregateConformancePackComplianceSummaryResponse getAggregateConformancePackComplianceSummary(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAggregateConformancePackComplianceSummaryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetAggregateConformancePackComplianceSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateConformancePackComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateConformancePackComplianceSummary");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAggregateConformancePackComplianceSummaryRequest, GetAggregateConformancePackComplianceSummaryResponse>()
                            .withOperationName("GetAggregateConformancePackComplianceSummary")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAggregateConformancePackComplianceSummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAggregateConformancePackComplianceSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your AWS Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return Result of the GetAggregateDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAggregateDiscoveredResourceCountsResponse getAggregateDiscoveredResourceCounts(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAggregateDiscoveredResourceCountsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetAggregateDiscoveredResourceCountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateDiscoveredResourceCountsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateDiscoveredResourceCounts");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAggregateDiscoveredResourceCountsRequest, GetAggregateDiscoveredResourceCountsResponse>()
                            .withOperationName("GetAggregateDiscoveredResourceCounts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAggregateDiscoveredResourceCountsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAggregateDiscoveredResourceCountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     * @return Result of the GetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws OversizedConfigurationItemException
     *         The configuration item size is outside the allowable range.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAggregateResourceConfigResponse getAggregateResourceConfig(
            GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) throws ValidationException,
            NoSuchConfigurationAggregatorException, OversizedConfigurationItemException, ResourceNotDiscoveredException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAggregateResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAggregateResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateResourceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAggregateResourceConfigRequest, GetAggregateResourceConfigResponse>()
                            .withOperationName("GetAggregateResourceConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getAggregateResourceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAggregateResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule. The results indicate which AWS resources were
     * evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return Result of the GetComplianceDetailsByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceDetailsByConfigRuleResponse getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComplianceDetailsByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComplianceDetailsByConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceDetailsByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceDetailsByConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResponse>()
                            .withOperationName("GetComplianceDetailsByConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getComplianceDetailsByConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetComplianceDetailsByConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS resource. The results indicate which AWS Config rules were
     * used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return Result of the GetComplianceDetailsByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceDetailsByResourceResponse getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComplianceDetailsByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComplianceDetailsByResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceDetailsByResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceDetailsByResource");

            return clientHandler
                    .execute(new ClientExecutionParams<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResponse>()
                            .withOperationName("GetComplianceDetailsByResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getComplianceDetailsByResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetComplianceDetailsByResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return Result of the GetComplianceSummaryByConfigRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) throws AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComplianceSummaryByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComplianceSummaryByConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceSummaryByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceSummaryByConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResponse>()
                            .withOperationName("GetComplianceSummaryByConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getComplianceSummaryByConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetComplianceSummaryByConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return Result of the GetComplianceSummaryByResourceType operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComplianceSummaryByResourceTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComplianceSummaryByResourceTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceSummaryByResourceTypeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceSummaryByResourceType");

            return clientHandler
                    .execute(new ClientExecutionParams<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResponse>()
                            .withOperationName("GetComplianceSummaryByResourceType").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getComplianceSummaryByResourceTypeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetComplianceSummaryByResourceTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return Result of the GetConformancePackComplianceDetails operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws NoSuchConfigRuleInConformancePackException
     *         AWS Config rule that you passed in the filter does not exist.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConformancePackComplianceDetailsResponse getConformancePackComplianceDetails(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) throws InvalidLimitException,
            InvalidNextTokenException, NoSuchConformancePackException, NoSuchConfigRuleInConformancePackException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConformancePackComplianceDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConformancePackComplianceDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConformancePackComplianceDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConformancePackComplianceDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConformancePackComplianceDetailsRequest, GetConformancePackComplianceDetailsResponse>()
                            .withOperationName("GetConformancePackComplianceDetails").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getConformancePackComplianceDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConformancePackComplianceDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return Result of the GetConformancePackComplianceSummary operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConformancePackComplianceSummaryResponse getConformancePackComplianceSummary(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConformancePackComplianceSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConformancePackComplianceSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConformancePackComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConformancePackComplianceSummary");

            return clientHandler
                    .execute(new ClientExecutionParams<GetConformancePackComplianceSummaryRequest, GetConformancePackComplianceSummaryResponse>()
                            .withOperationName("GetConformancePackComplianceSummary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getConformancePackComplianceSummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetConformancePackComplianceSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that AWS Config
     * is recording in this region for your AWS account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new AWS Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for AWS Config to record and count your resources. Wait a few minutes and then retry
     * the <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return Result of the GetDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDiscoveredResourceCountsResponse getDiscoveredResourceCounts(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDiscoveredResourceCountsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDiscoveredResourceCountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDiscoveredResourceCountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDiscoveredResourceCounts");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDiscoveredResourceCountsRequest, GetDiscoveredResourceCountsResponse>()
                            .withOperationName("GetDiscoveredResourceCounts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDiscoveredResourceCountsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDiscoveredResourceCountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization config rule.
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return Result of the GetOrganizationConfigRuleDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         You specified one or more organization config rules that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOrganizationConfigRuleDetailedStatusResponse getOrganizationConfigRuleDetailedStatus(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOrganizationConfigRuleDetailedStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetOrganizationConfigRuleDetailedStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getOrganizationConfigRuleDetailedStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationConfigRuleDetailedStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationConfigRuleDetailedStatusRequest, GetOrganizationConfigRuleDetailedStatusResponse>()
                            .withOperationName("GetOrganizationConfigRuleDetailedStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOrganizationConfigRuleDetailedStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOrganizationConfigRuleDetailedStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return Result of the GetOrganizationConformancePackDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         AWS Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOrganizationConformancePackDetailedStatusResponse getOrganizationConformancePackDetailedStatus(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOrganizationConformancePackDetailedStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetOrganizationConformancePackDetailedStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getOrganizationConformancePackDetailedStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationConformancePackDetailedStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationConformancePackDetailedStatusRequest, GetOrganizationConformancePackDetailedStatusResponse>()
                            .withOperationName("GetOrganizationConformancePackDetailedStatus")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOrganizationConformancePackDetailedStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOrganizationConformancePackDetailedStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return Result of the GetResourceConfigHistory operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceConfigHistoryResponse getResourceConfigHistory(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceConfigHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceConfigHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceConfigHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceConfigHistory");

            return clientHandler
                    .execute(new ClientExecutionParams<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResponse>()
                            .withOperationName("GetResourceConfigHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getResourceConfigHistoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetResourceConfigHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client
     *             .getResourceConfigHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceConfigHistoryIterable getResourceConfigHistoryPaginator(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        return new GetResourceConfigHistoryIterable(this, applyPaginatorUserAgent(getResourceConfigHistoryRequest));
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     *
     * @param getStoredQueryRequest
     * @return Result of the GetStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStoredQueryResponse getStoredQuery(GetStoredQueryRequest getStoredQueryRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStoredQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStoredQuery");

            return clientHandler.execute(new ClientExecutionParams<GetStoredQueryRequest, GetStoredQueryResponse>()
                    .withOperationName("GetStoredQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStoredQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStoredQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return Result of the ListAggregateDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAggregateDiscoveredResourcesResponse listAggregateDiscoveredResources(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAggregateDiscoveredResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAggregateDiscoveredResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAggregateDiscoveredResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAggregateDiscoveredResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAggregateDiscoveredResourcesRequest, ListAggregateDiscoveredResourcesResponse>()
                            .withOperationName("ListAggregateDiscoveredResources").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAggregateDiscoveredResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAggregateDiscoveredResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that AWS Config has discovered, including those that AWS Config is not currently recording. You can
     * narrow the results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 resource identifiers on each page. You can customize
     * this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get
     * the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDiscoveredResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDiscoveredResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDiscoveredResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDiscoveredResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResponse>()
                            .withOperationName("ListDiscoveredResources").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listDiscoveredResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDiscoveredResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return Result of the ListStoredQueries operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStoredQueriesResponse listStoredQueries(ListStoredQueriesRequest listStoredQueriesRequest)
            throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStoredQueriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStoredQueriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStoredQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStoredQueries");

            return clientHandler.execute(new ClientExecutionParams<ListStoredQueriesRequest, ListStoredQueriesResponse>()
                    .withOperationName("ListStoredQueries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStoredQueriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStoredQueriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client
     *             .listStoredQueriesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStoredQueriesIterable listStoredQueriesPaginator(ListStoredQueriesRequest listStoredQueriesRequest)
            throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return new ListStoredQueriesIterable(this, applyPaginatorUserAgent(listStoredQueriesRequest));
    }

    /**
     * <p>
     * List the tags for AWS Config resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InvalidLimitException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     *
     * @param putAggregationAuthorizationRequest
     * @return Result of the PutAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutAggregationAuthorizationResponse putAggregationAuthorization(
            PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutAggregationAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutAggregationAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAggregationAuthorizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAggregationAuthorization");

            return clientHandler
                    .execute(new ClientExecutionParams<PutAggregationAuthorizationRequest, PutAggregationAuthorizationResponse>()
                            .withOperationName("PutAggregationAuthorization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putAggregationAuthorizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutAggregationAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired
     * configurations.
     * </p>
     * <p>
     * You can use this action for custom AWS Config rules and AWS managed Config rules. A custom AWS Config rule is a
     * rule that you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config
     * provides.
     * </p>
     * <p>
     * If you are adding a new custom AWS Config rule, you must first create the AWS Lambda function that the rule
     * invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to AWS
     * Config, you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN
     * for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * If you are adding an AWS managed Config rule, specify the rule's identifier for the <code>SourceIdentifier</code>
     * key. To reference AWS managed Config rule identifiers, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About AWS
     * Managed Config Rules</a>.
     * </p>
     * <p>
     * For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do
     * not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by AWS
     * Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * The maximum number of rules that AWS Config supports is 150.
     * </p>
     * <p>
     * For information about requesting a rule limit increase, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a>
     * in the <i>AWS General Reference Guide</i>.
     * </p>
     * <p>
     * For more information about developing and using AWS Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource
     * Configurations with AWS Config</a> in the <i>AWS Config Developer Guide</i>.
     * </p>
     *
     * @param putConfigRuleRequest
     * @return Result of the PutConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws MaxNumberOfConfigRulesExceededException
     *         Failed to add the AWS Config rule because the account already contains the maximum number of 150 rules.
     *         Consider deleting any deactivated rules before you add new rules.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutConfigRuleResponse putConfigRule(PutConfigRuleRequest putConfigRuleRequest) throws InvalidParameterValueException,
            MaxNumberOfConfigRulesExceededException, ResourceInUseException, InsufficientPermissionsException,
            NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigRule");

            return clientHandler.execute(new ClientExecutionParams<PutConfigRuleRequest, PutConfigRuleResponse>()
                    .withOperationName("PutConfigRule").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putConfigRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeAggregator</code> to get the previous accounts and then append
     * new ones.
     * </p>
     * <note>
     * <p>
     * AWS Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * AWS Config calls <code>EnableAwsServiceAccess</code> API to enable integration between AWS Config and AWS
     * Organizations. If the caller is a registered delegated administrator, AWS Config calls
     * <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the AWS Config developer guide.
     * </p>
     * </note>
     *
     * @param putConfigurationAggregatorRequest
     * @return Result of the PutConfigurationAggregator operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws LimitExceededException
     *         For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress
     *         or if you call the <a>StartConfigRulesEvaluation</a> API more than once per minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.
     * @throws InvalidRoleException
     *         You have provided a null or empty role ARN.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws NoAvailableOrganizationException
     *         Organization is no longer available.
     * @throws OrganizationAllFeaturesNotEnabledException
     *         AWS Config resource cannot be created because your organization does not have all features enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConfigurationAggregatorResponse putConfigurationAggregator(
            PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) throws InvalidParameterValueException,
            LimitExceededException, InvalidRoleException, OrganizationAccessDeniedException, NoAvailableOrganizationException,
            OrganizationAllFeaturesNotEnabledException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConfigurationAggregatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConfigurationAggregatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigurationAggregatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationAggregator");

            return clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationAggregatorRequest, PutConfigurationAggregatorResponse>()
                            .withOperationName("PutConfigurationAggregator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putConfigurationAggregatorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutConfigurationAggregatorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new configuration recorder to record the selected resource configurations.
     * </p>
     * <p>
     * You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. To change the role, call the action on the existing configuration recorder and specify a role.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * <p>
     * If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is
     * to record all supported resource types.
     * </p>
     * </note>
     *
     * @param putConfigurationRecorderRequest
     *        The input for the <a>PutConfigurationRecorder</a> action.
     * @return Result of the PutConfigurationRecorder operation returned by the service.
     * @throws MaxNumberOfConfigurationRecordersExceededException
     *         You have reached the limit of the number of recorders you can create.
     * @throws InvalidConfigurationRecorderNameException
     *         You have provided a configuration recorder name that is not valid.
     * @throws InvalidRoleException
     *         You have provided a null or empty role ARN.
     * @throws InvalidRecordingGroupException
     *         AWS Config throws an exception if the recording group does not contain a valid list of resource types.
     *         Invalid values might also be incorrectly formatted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConfigurationRecorderResponse putConfigurationRecorder(
            PutConfigurationRecorderRequest putConfigurationRecorderRequest)
            throws MaxNumberOfConfigurationRecordersExceededException, InvalidConfigurationRecorderNameException,
            InvalidRoleException, InvalidRecordingGroupException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConfigurationRecorderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationRecorder");

            return clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationRecorderRequest, PutConfigurationRecorderResponse>()
                            .withOperationName("PutConfigurationRecorder").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putConfigurationRecorderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutConfigurationRecorderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a conformance pack. A conformance pack is a collection of AWS Config rules that can be easily
     * deployed in an account and a region and across AWS Organization.
     * </p>
     * <p>
     * This API creates a service linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The service
     * linked role is created only when the role does not exist in your account.
     * </p>
     * <note>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * </note>
     *
     * @param putConformancePackRequest
     * @return Result of the PutConformancePack operation returned by the service.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws ConformancePackTemplateValidationException
     *         You have specified a template that is not valid or supported.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws MaxNumberOfConformancePacksExceededException
     *         You have reached the limit (6) of the number of conformance packs in an account (6 conformance pack with
     *         25 AWS Config rules per pack).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutConformancePackResponse putConformancePack(PutConformancePackRequest putConformancePackRequest)
            throws InsufficientPermissionsException, ConformancePackTemplateValidationException, ResourceInUseException,
            InvalidParameterValueException, MaxNumberOfConformancePacksExceededException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConformancePackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConformancePackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConformancePack");

            return clientHandler.execute(new ClientExecutionParams<PutConformancePackRequest, PutConformancePackResponse>()
                    .withOperationName("PutConformancePack").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putConformancePackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutConformancePackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS
     * topic.
     * </p>
     * <p>
     * Before you can create a delivery channel, you must create a configuration recorder.
     * </p>
     * <p>
     * You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel.
     * To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3
     * bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action
     * will keep the existing value for the parameter that is not changed.
     * </p>
     * <note>
     * <p>
     * You can have only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param putDeliveryChannelRequest
     *        The input for the <a>PutDeliveryChannel</a> action.
     * @return Result of the PutDeliveryChannel operation returned by the service.
     * @throws MaxNumberOfDeliveryChannelsExceededException
     *         You have reached the limit of the number of delivery channels you can create.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws InvalidDeliveryChannelNameException
     *         The specified delivery channel name is not valid.
     * @throws NoSuchBucketException
     *         The specified Amazon S3 bucket does not exist.
     * @throws InvalidS3KeyPrefixException
     *         The specified Amazon S3 key prefix is not valid.
     * @throws InvalidS3KmsKeyArnException
     *         The specified Amazon KMS Key ARN is not valid.
     * @throws InvalidSnsTopicArnException
     *         The specified Amazon SNS topic does not exist.
     * @throws InsufficientDeliveryPolicyException
     *         Your Amazon S3 bucket policy does not permit AWS Config to write to it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDeliveryChannelResponse putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest)
            throws MaxNumberOfDeliveryChannelsExceededException, NoAvailableConfigurationRecorderException,
            InvalidDeliveryChannelNameException, NoSuchBucketException, InvalidS3KeyPrefixException, InvalidS3KmsKeyArnException,
            InvalidSnsTopicArnException, InsufficientDeliveryPolicyException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDeliveryChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDeliveryChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliveryChannel");

            return clientHandler.execute(new ClientExecutionParams<PutDeliveryChannelRequest, PutDeliveryChannelResponse>()
                    .withOperationName("PutDeliveryChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putDeliveryChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutDeliveryChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Used by an AWS Lambda function to deliver evaluation results to AWS Config. This action is required in every AWS
     * Lambda function that is invoked by an AWS Config rule.
     * </p>
     *
     * @param putEvaluationsRequest
     * @return Result of the PutEvaluations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidResultTokenException
     *         The specified <code>ResultToken</code> is invalid.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEvaluationsResponse putEvaluations(PutEvaluationsRequest putEvaluationsRequest)
            throws InvalidParameterValueException, InvalidResultTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEvaluationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEvaluationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEvaluationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEvaluations");

            return clientHandler.execute(new ClientExecutionParams<PutEvaluationsRequest, PutEvaluationsResponse>()
                    .withOperationName("PutEvaluations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putEvaluationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutEvaluationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name
     * of the AWS Config rule is provided.
     * </p>
     *
     * @param putExternalEvaluationRequest
     * @return Result of the PutExternalEvaluation operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutExternalEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutExternalEvaluationResponse putExternalEvaluation(PutExternalEvaluationRequest putExternalEvaluationRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutExternalEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutExternalEvaluationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putExternalEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutExternalEvaluation");

            return clientHandler.execute(new ClientExecutionParams<PutExternalEvaluationRequest, PutExternalEvaluationResponse>()
                    .withOperationName("PutExternalEvaluation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putExternalEvaluationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutExternalEvaluationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates organization config rule for your entire organization evaluating whether your AWS resources
     * comply with your desired configurations.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can create or update an organization config rule. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a
     * service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated
     * administrator account of your organization. The service linked role is created only when the role does not exist
     * in the caller account. AWS Config verifies the existence of role with <code>GetRole</code> action.
     * </p>
     * <p>
     * To use this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * You can use this action to create both custom AWS Config rules and AWS managed Config rules. If you are adding a
     * new custom AWS Config rule, you must first create AWS Lambda function in the master account or a delegated
     * administrator that the rule invokes to evaluate your resources. When you use the
     * <code>PutOrganizationConfigRule</code> action to add the rule to AWS Config, you must specify the Amazon Resource
     * Name (ARN) that AWS Lambda assigns to the function. If you are adding an AWS managed Config rule, specify the
     * rule's identifier for the <code>RuleIdentifier</code> key.
     * </p>
     * <p>
     * The maximum number of organization config rules that AWS Config supports is 150 and 3 delegated administrator per
     * organization.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * Specify either <code>OrganizationCustomRuleMetadata</code> or <code>OrganizationManagedRuleMetadata</code>.
     * </p>
     * </note>
     *
     * @param putOrganizationConfigRuleRequest
     * @return Result of the PutOrganizationConfigRule operation returned by the service.
     * @throws MaxNumberOfOrganizationConfigRulesExceededException
     *         You have reached the limit of the number of organization config rules you can create.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws NoAvailableOrganizationException
     *         Organization is no longer available.
     * @throws OrganizationAllFeaturesNotEnabledException
     *         AWS Config resource cannot be created because your organization does not have all features enabled.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutOrganizationConfigRuleResponse putOrganizationConfigRule(
            PutOrganizationConfigRuleRequest putOrganizationConfigRuleRequest)
            throws MaxNumberOfOrganizationConfigRulesExceededException, ResourceInUseException, InvalidParameterValueException,
            ValidationException, OrganizationAccessDeniedException, NoAvailableOrganizationException,
            OrganizationAllFeaturesNotEnabledException, InsufficientPermissionsException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutOrganizationConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutOrganizationConfigRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOrganizationConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOrganizationConfigRule");

            return clientHandler
                    .execute(new ClientExecutionParams<PutOrganizationConfigRuleRequest, PutOrganizationConfigRuleResponse>()
                            .withOperationName("PutOrganizationConfigRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putOrganizationConfigRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutOrganizationConfigRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deploys conformance packs across member accounts in an AWS Organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can call this API. When calling this API with a delegated
     * administrator, you must ensure AWS Organizations <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the
     * <code>EnableAWSServiceAccess</code> action and creates a service linked role
     * <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your
     * organization. The service linked role is created only when the role does not exist in the caller account. To use
     * this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the
     * conformance pack is created or updated. You cannot update a conformance pack while it is in this state.
     * </p>
     * <p>
     * You can create 50 conformance packs with 25 AWS Config rules in each pack and 3 delegated administrator per
     * organization.
     * </p>
     * </note>
     *
     * @param putOrganizationConformancePackRequest
     * @return Result of the PutOrganizationConformancePack operation returned by the service.
     * @throws MaxNumberOfOrganizationConformancePacksExceededException
     *         You have reached the limit (6) of the number of organization conformance packs in an account (6
     *         conformance pack with 25 AWS Config rules per pack per account).
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws OrganizationConformancePackTemplateValidationException
     *         You have specified a template that is not valid or supported.
     * @throws OrganizationAllFeaturesNotEnabledException
     *         AWS Config resource cannot be created because your organization does not have all features enabled.
     * @throws NoAvailableOrganizationException
     *         Organization is no longer available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutOrganizationConformancePackResponse putOrganizationConformancePack(
            PutOrganizationConformancePackRequest putOrganizationConformancePackRequest)
            throws MaxNumberOfOrganizationConformancePacksExceededException, ResourceInUseException, ValidationException,
            OrganizationAccessDeniedException, InsufficientPermissionsException,
            OrganizationConformancePackTemplateValidationException, OrganizationAllFeaturesNotEnabledException,
            NoAvailableOrganizationException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutOrganizationConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutOrganizationConformancePackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOrganizationConformancePack");

            return clientHandler
                    .execute(new ClientExecutionParams<PutOrganizationConformancePackRequest, PutOrganizationConformancePackResponse>()
                            .withOperationName("PutOrganizationConformancePack").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putOrganizationConformancePackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutOrganizationConformancePackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates the remediation configuration with a specific AWS Config rule with the selected target or action.
     * The API creates the <code>RemediationConfiguration</code> object for the AWS Config rule. The AWS Config rule
     * must already exist for you to add a remediation configuration. The target (SSM document) must exist and have
     * permissions to use the target.
     * </p>
     * <note>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call this again to ensure the
     * remediations can run.
     * </p>
     * <p>
     * This API does not support adding remediation configurations for service-linked AWS Config Rules such as
     * Organization Config rules, the rules deployed by conformance packs, and rules deployed by AWS Security Hub.
     * </p>
     * </note>
     *
     * @param putRemediationConfigurationsRequest
     * @return Result of the PutRemediationConfigurations operation returned by the service.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRemediationConfigurationsResponse putRemediationConfigurations(
            PutRemediationConfigurationsRequest putRemediationConfigurationsRequest) throws InsufficientPermissionsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRemediationConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRemediationConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRemediationConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRemediationConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRemediationConfigurationsRequest, PutRemediationConfigurationsResponse>()
                            .withOperationName("PutRemediationConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putRemediationConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRemediationConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a
     * new exception or updates an existing exception for a specific resource with a specific AWS Config rule.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param putRemediationExceptionsRequest
     * @return Result of the PutRemediationExceptions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRemediationExceptionsResponse putRemediationExceptions(
            PutRemediationExceptionsRequest putRemediationExceptionsRequest) throws InvalidParameterValueException,
            InsufficientPermissionsException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRemediationExceptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRemediationExceptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRemediationExceptions");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRemediationExceptionsRequest, PutRemediationExceptionsResponse>()
                            .withOperationName("PutRemediationExceptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putRemediationExceptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRemediationExceptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Records the configuration state for the resource provided in the request. The configuration state of a resource
     * is represented in AWS Config as Configuration Items. Once this API records the configuration item, you can
     * retrieve the list of configuration items for the custom resource type using existing AWS Config APIs.
     * </p>
     * <note>
     * <p>
     * The custom resource type must be registered with AWS CloudFormation. This API accepts the configuration item
     * registered with AWS CloudFormation.
     * </p>
     * <p>
     * When you call this API, AWS Config only stores configuration state of the resource provided in the request. This
     * API does not change or remediate the configuration of the resource.
     * </p>
     * <p>
     * Write-only schema properites are not recorded as part of the published configuration item.
     * </p>
     * </note>
     *
     * @param putResourceConfigRequest
     * @return Result of the PutResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws MaxActiveResourcesExceededException
     *         You have reached the limit (100,000) of active custom resource types in your account. Delete unused
     *         resources using <code>DeleteResourceConfig</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutResourceConfigResponse putResourceConfig(PutResourceConfigRequest putResourceConfigRequest)
            throws ValidationException, InsufficientPermissionsException, NoRunningConfigurationRecorderException,
            MaxActiveResourcesExceededException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourceConfig");

            return clientHandler.execute(new ClientExecutionParams<PutResourceConfigRequest, PutResourceConfigResponse>()
                    .withOperationName("PutResourceConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putResourceConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and updates the retention configuration with details about retention period (number of days) that AWS
     * Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and
     * names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named
     * <b>default</b>, calling the API modifies the default object.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param putRetentionConfigurationRequest
     * @return Result of the PutRetentionConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws MaxNumberOfRetentionConfigurationsExceededException
     *         Failed to add the retention configuration because a retention configuration with that name already
     *         exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRetentionConfigurationResponse putRetentionConfiguration(
            PutRetentionConfigurationRequest putRetentionConfigurationRequest) throws InvalidParameterValueException,
            MaxNumberOfRetentionConfigurationsExceededException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRetentionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRetentionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRetentionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRetentionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRetentionConfigurationRequest, PutRetentionConfigurationResponse>()
                            .withOperationName("PutRetentionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putRetentionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRetentionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single AWS
     * account and a single AWS Region. You can create upto 300 queries in a single AWS account and a single AWS Region.
     * </p>
     *
     * @param putStoredQueryRequest
     * @return Result of the PutStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws TooManyTagsException
     *         You have reached the limit of the number of tags you can use. You have more than 50 tags.
     * @throws ResourceConcurrentModificationException
     *         Two users are trying to modify the same query at the same time. Wait for a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutStoredQueryResponse putStoredQuery(PutStoredQueryRequest putStoredQueryRequest) throws ValidationException,
            TooManyTagsException, ResourceConcurrentModificationException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutStoredQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStoredQuery");

            return clientHandler.execute(new ClientExecutionParams<PutStoredQueryRequest, PutStoredQueryResponse>()
                    .withOperationName("PutStoredQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putStoredQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutStoredQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     * @return Result of the SelectAggregateResourceConfig operation returned by the service.
     * @throws InvalidExpressionException
     *         The syntax of the query is incorrect.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SelectAggregateResourceConfigResponse selectAggregateResourceConfig(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) throws InvalidExpressionException,
            NoSuchConfigurationAggregatorException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SelectAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SelectAggregateResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                selectAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SelectAggregateResourceConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<SelectAggregateResourceConfigRequest, SelectAggregateResourceConfigResponse>()
                            .withOperationName("SelectAggregateResourceConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(selectAggregateResourceConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SelectAggregateResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigIterable responses = client.selectAggregateResourceConfigPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigIterable responses = client
     *             .selectAggregateResourceConfigPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigIterable responses = client.selectAggregateResourceConfigPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidExpressionException
     *         The syntax of the query is incorrect.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SelectAggregateResourceConfigIterable selectAggregateResourceConfigPaginator(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) throws InvalidExpressionException,
            NoSuchConfigurationAggregatorException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return new SelectAggregateResourceConfigIterable(this, applyPaginatorUserAgent(selectAggregateResourceConfigRequest));
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and
     * returns resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     *
     * @param selectResourceConfigRequest
     * @return Result of the SelectResourceConfig operation returned by the service.
     * @throws InvalidExpressionException
     *         The syntax of the query is incorrect.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.SelectResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SelectResourceConfigResponse selectResourceConfig(SelectResourceConfigRequest selectResourceConfigRequest)
            throws InvalidExpressionException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SelectResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SelectResourceConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, selectResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SelectResourceConfig");

            return clientHandler.execute(new ClientExecutionParams<SelectResourceConfigRequest, SelectResourceConfigResponse>()
                    .withOperationName("SelectResourceConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(selectResourceConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SelectResourceConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified AWS Config rules against the last known configuration state of the
     * resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working
     * as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your
     * resources. It re-runs an evaluation against the last known state of your resources.
     * </p>
     * <p>
     * You can specify up to 25 AWS Config rules per request.
     * </p>
     * <p>
     * An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can
     * call the API again. If you chose to have AWS Config stream to an Amazon SNS topic, you will receive a
     * <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.
     * </p>
     * <note>
     * <p>
     * You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When
     * you create a rule, AWS Config evaluates your resources against the rule automatically.
     * </p>
     * </note>
     * <p>
     * The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the
     * following example:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You have a custom rule that evaluates your IAM resources every 24 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You update your Lambda function to add additional conditions to your rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config invokes your Lambda function and evaluates your IAM resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule will still run periodic evaluations every 24 hours.
     * </p>
     * </li>
     * </ol>
     *
     * @param startConfigRulesEvaluationRequest
     * @return Result of the StartConfigRulesEvaluation operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws LimitExceededException
     *         For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress
     *         or if you call the <a>StartConfigRulesEvaluation</a> API more than once per minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.
     * @throws ResourceInUseException
     *         You see this exception in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StartConfigRulesEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartConfigRulesEvaluationResponse startConfigRulesEvaluation(
            StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) throws NoSuchConfigRuleException,
            LimitExceededException, ResourceInUseException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartConfigRulesEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartConfigRulesEvaluationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startConfigRulesEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartConfigRulesEvaluation");

            return clientHandler
                    .execute(new ClientExecutionParams<StartConfigRulesEvaluationRequest, StartConfigRulesEvaluationResponse>()
                            .withOperationName("StartConfigRulesEvaluation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startConfigRulesEvaluationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartConfigRulesEvaluationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     * <p>
     * You must have created at least one delivery channel to successfully start the configuration recorder.
     * </p>
     *
     * @param startConfigurationRecorderRequest
     *        The input for the <a>StartConfigurationRecorder</a> action.
     * @return Result of the StartConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws NoAvailableDeliveryChannelException
     *         There is no delivery channel available to record configurations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StartConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartConfigurationRecorderResponse startConfigurationRecorder(
            StartConfigurationRecorderRequest startConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            NoAvailableDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartConfigurationRecorderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartConfigurationRecorder");

            return clientHandler
                    .execute(new ClientExecutionParams<StartConfigurationRecorderRequest, StartConfigurationRecorderResponse>()
                            .withOperationName("StartConfigurationRecorder").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startConfigurationRecorderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartConfigurationRecorderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs an on-demand remediation for the specified AWS Config rules against the last known remediation
     * configuration. It runs an execution against the current state of your resources. Remediation execution is
     * asynchronous.
     * </p>
     * <p>
     * You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified
     * resource keys must complete before you can call the API again.
     * </p>
     *
     * @param startRemediationExecutionRequest
     * @return Result of the StartRemediationExecution operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws NoSuchRemediationConfigurationException
     *         You specified an AWS Config rule without a remediation configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StartRemediationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartRemediationExecutionResponse startRemediationExecution(
            StartRemediationExecutionRequest startRemediationExecutionRequest) throws InvalidParameterValueException,
            InsufficientPermissionsException, NoSuchRemediationConfigurationException, AwsServiceException, SdkClientException,
            ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRemediationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartRemediationExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRemediationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRemediationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartRemediationExecutionRequest, StartRemediationExecutionResponse>()
                            .withOperationName("StartRemediationExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startRemediationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartRemediationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     *
     * @param stopConfigurationRecorderRequest
     *        The input for the <a>StopConfigurationRecorder</a> action.
     * @return Result of the StopConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StopConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopConfigurationRecorderResponse stopConfigurationRecorder(
            StopConfigurationRecorderRequest stopConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopConfigurationRecorderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopConfigurationRecorder");

            return clientHandler
                    .execute(new ClientExecutionParams<StopConfigurationRecorderRequest, StopConfigurationRecorderResponse>()
                            .withOperationName("StopConfigurationRecorder").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(stopConfigurationRecorderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopConfigurationRecorderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are
     * not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated
     * with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws TooManyTagsException
     *         You have reached the limit of the number of tags you can use. You have more than 50 tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ConfigException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException")
                                .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                                .exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                                .exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                                .exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                                .exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                .exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResultTokenException")
                                .exceptionBuilderSupplier(InvalidResultTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                                .exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                                .exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                                .exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                                .exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                                .exceptionBuilderSupplier(RemediationInProgressException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                                .exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                                .exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                                .exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                                .exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                                .exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLimitException")
                                .exceptionBuilderSupplier(InvalidLimitException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                .exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                                .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExpressionException")
                                .exceptionBuilderSupplier(InvalidExpressionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException")
                                .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                                .exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                                .exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                                .exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                                .exceptionBuilderSupplier(NoSuchConformancePackException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException")
                                .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchBucketException")
                                .exceptionBuilderSupplier(NoSuchBucketException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                                .exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                                .exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTimeRangeException")
                                .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException")
                                .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRoleException")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                                .exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                                .exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException")
                                .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends ConfigRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
