/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the status for an organization conformance pack in an organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConformancePackStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConformancePackStatus.Builder, OrganizationConformancePackStatus> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConformancePackName")
            .getter(getter(OrganizationConformancePackStatus::organizationConformancePackName))
            .setter(setter(Builder::organizationConformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrganizationConformancePackStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(OrganizationConformancePackStatus::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(OrganizationConformancePackStatus::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(OrganizationConformancePackStatus::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD,
                    LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationConformancePackName;

    private final String status;

    private final String errorCode;

    private final String errorMessage;

    private final Instant lastUpdateTime;

    private OrganizationConformancePackStatus(BuilderImpl builder) {
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name that you assign to organization conformance pack.
     * </p>
     * 
     * @return The name that you assign to organization conformance pack.
     */
    public final String organizationConformancePackName() {
        return organizationConformancePackName;
    }

    /**
     * <p>
     * Indicates deployment status of an organization conformance pack. When master account calls
     * PutOrganizationConformancePack for the first time, conformance pack status is created in all the member accounts.
     * When master account calls PutOrganizationConformancePack for the second time, conformance pack status is updated
     * in all the member accounts. Additionally, conformance pack status is updated when one or more member accounts
     * join or leave an organization. Conformance pack status is deleted when the master account deletes
     * OrganizationConformancePack in all the member accounts and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status of an organization conformance pack. When master account calls
     *         PutOrganizationConformancePack for the first time, conformance pack status is created in all the member
     *         accounts. When master account calls PutOrganizationConformancePack for the second time, conformance pack
     *         status is updated in all the member accounts. Additionally, conformance pack status is updated when one
     *         or more member accounts join or leave an organization. Conformance pack status is deleted when the master
     *         account deletes OrganizationConformancePack in all the member accounts and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>.</p>
     *         <p>
     *         AWS Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from
     *         all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     * @see OrganizationResourceStatus
     */
    public final OrganizationResourceStatus status() {
        return OrganizationResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates deployment status of an organization conformance pack. When master account calls
     * PutOrganizationConformancePack for the first time, conformance pack status is created in all the member accounts.
     * When master account calls PutOrganizationConformancePack for the second time, conformance pack status is updated
     * in all the member accounts. Additionally, conformance pack status is updated when one or more member accounts
     * join or leave an organization. Conformance pack status is deleted when the master account deletes
     * OrganizationConformancePack in all the member accounts and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * AWS Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the
     * member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts
     * within that organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status of an organization conformance pack. When master account calls
     *         PutOrganizationConformancePack for the first time, conformance pack status is created in all the member
     *         accounts. When master account calls PutOrganizationConformancePack for the second time, conformance pack
     *         status is updated in all the member accounts. Additionally, conformance pack status is updated when one
     *         or more member accounts join or leave an organization. Conformance pack status is deleted when the master
     *         account deletes OrganizationConformancePack in all the member accounts and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>.</p>
     *         <p>
     *         AWS Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from
     *         all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all
     *         the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member
     *         accounts within that organization.
     *         </p>
     *         </li>
     * @see OrganizationResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error code that is returned when organization conformance pack creation or deletion has failed in a member
     * account.
     * </p>
     * 
     * @return An error code that is returned when organization conformance pack creation or deletion has failed in a
     *         member account.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message indicating that organization conformance pack creation or deletion failed due to an error.
     * </p>
     * 
     * @return An error message indicating that organization conformance pack creation or deletion failed due to an
     *         error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp of the last update.
     * </p>
     * 
     * @return The timestamp of the last update.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePackStatus)) {
            return false;
        }
        OrganizationConformancePackStatus other = (OrganizationConformancePackStatus) obj;
        return Objects.equals(organizationConformancePackName(), other.organizationConformancePackName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationConformancePackStatus")
                .add("OrganizationConformancePackName", organizationConformancePackName()).add("Status", statusAsString())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).add("LastUpdateTime", lastUpdateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackName":
            return Optional.ofNullable(clazz.cast(organizationConformancePackName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePackStatus, T> g) {
        return obj -> g.apply((OrganizationConformancePackStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConformancePackStatus> {
        /**
         * <p>
         * The name that you assign to organization conformance pack.
         * </p>
         * 
         * @param organizationConformancePackName
         *        The name that you assign to organization conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackName(String organizationConformancePackName);

        /**
         * <p>
         * Indicates deployment status of an organization conformance pack. When master account calls
         * PutOrganizationConformancePack for the first time, conformance pack status is created in all the member
         * accounts. When master account calls PutOrganizationConformancePack for the second time, conformance pack
         * status is updated in all the member accounts. Additionally, conformance pack status is updated when one or
         * more member accounts join or leave an organization. Conformance pack status is deleted when the master
         * account deletes OrganizationConformancePack in all the member accounts and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
         * accounts within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
         * accounts within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all
         * the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status of an organization conformance pack. When master account calls
         *        PutOrganizationConformancePack for the first time, conformance pack status is created in all the
         *        member accounts. When master account calls PutOrganizationConformancePack for the second time,
         *        conformance pack status is updated in all the member accounts. Additionally, conformance pack status
         *        is updated when one or more member accounts join or leave an organization. Conformance pack status is
         *        deleted when the master account deletes OrganizationConformancePack in all the member accounts and
         *        disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
         *        <p>
         *        AWS Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in
         *        all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted
         *        from all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in
         *        all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         * @see OrganizationResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates deployment status of an organization conformance pack. When master account calls
         * PutOrganizationConformancePack for the first time, conformance pack status is created in all the member
         * accounts. When master account calls PutOrganizationConformancePack for the second time, conformance pack
         * status is updated in all the member accounts. Additionally, conformance pack status is updated when one or
         * more member accounts join or leave an organization. Conformance pack status is deleted when the master
         * account deletes OrganizationConformancePack in all the member accounts and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * AWS Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
         * accounts within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
         * accounts within that organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted from all
         * the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in all the
         * member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member accounts
         * within that organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status of an organization conformance pack. When master account calls
         *        PutOrganizationConformancePack for the first time, conformance pack status is created in all the
         *        member accounts. When master account calls PutOrganizationConformancePack for the second time,
         *        conformance pack status is updated in all the member accounts. Additionally, conformance pack status
         *        is updated when one or more member accounts join or leave an organization. Conformance pack status is
         *        deleted when the master account deletes OrganizationConformancePack in all the member accounts and
         *        disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
         *        <p>
         *        AWS Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when an organization conformance pack has been successfully created in
         *        all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when an organization conformance pack creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when an organization conformance pack creation failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when an organization conformance pack deletion failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when an organization conformance pack deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when an organization conformance pack has been successfully deleted
         *        from all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when an organization conformance pack has been successfully updated in
         *        all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when an organization conformance pack update is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when an organization conformance pack update failed in one or more member
         *        accounts within that organization.
         *        </p>
         *        </li>
         * @see OrganizationResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceStatus
         */
        Builder status(OrganizationResourceStatus status);

        /**
         * <p>
         * An error code that is returned when organization conformance pack creation or deletion has failed in a member
         * account.
         * </p>
         * 
         * @param errorCode
         *        An error code that is returned when organization conformance pack creation or deletion has failed in a
         *        member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message indicating that organization conformance pack creation or deletion failed due to an error.
         * </p>
         * 
         * @param errorMessage
         *        An error message indicating that organization conformance pack creation or deletion failed due to an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp of the last update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The timestamp of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String organizationConformancePackName;

        private String status;

        private String errorCode;

        private String errorMessage;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePackStatus model) {
            organizationConformancePackName(model.organizationConformancePackName);
            status(model.status);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConformancePackName() {
            return organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public OrganizationConformancePackStatus build() {
            return new OrganizationConformancePackStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
