/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the number of compliant and noncompliant rules within a conformance pack. Also provides the total count of
 * compliant rules, noncompliant rules, and the rules that do not have any applicable resources to evaluate upon
 * resulting in insufficient data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateConformancePackCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateConformancePackCompliance.Builder, AggregateConformancePackCompliance> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(AggregateConformancePackCompliance::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<Integer> COMPLIANT_RULE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantRuleCount").getter(getter(AggregateConformancePackCompliance::compliantRuleCount))
            .setter(setter(Builder::compliantRuleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantRuleCount").build())
            .build();

    private static final SdkField<Integer> NON_COMPLIANT_RULE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantRuleCount").getter(getter(AggregateConformancePackCompliance::nonCompliantRuleCount))
            .setter(setter(Builder::nonCompliantRuleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantRuleCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_RULE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalRuleCount").getter(getter(AggregateConformancePackCompliance::totalRuleCount))
            .setter(setter(Builder::totalRuleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRuleCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD,
            COMPLIANT_RULE_COUNT_FIELD, NON_COMPLIANT_RULE_COUNT_FIELD, TOTAL_RULE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceType;

    private final Integer compliantRuleCount;

    private final Integer nonCompliantRuleCount;

    private final Integer totalRuleCount;

    private AggregateConformancePackCompliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.compliantRuleCount = builder.compliantRuleCount;
        this.nonCompliantRuleCount = builder.nonCompliantRuleCount;
        this.totalRuleCount = builder.totalRuleCount;
    }

    /**
     * <p>
     * The compliance status of the conformance pack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance status of the conformance pack.
     * @see ConformancePackComplianceType
     */
    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The compliance status of the conformance pack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance status of the conformance pack.
     * @see ConformancePackComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The number of compliant AWS Config Rules.
     * </p>
     * 
     * @return The number of compliant AWS Config Rules.
     */
    public final Integer compliantRuleCount() {
        return compliantRuleCount;
    }

    /**
     * <p>
     * The number of noncompliant AWS Config Rules.
     * </p>
     * 
     * @return The number of noncompliant AWS Config Rules.
     */
    public final Integer nonCompliantRuleCount() {
        return nonCompliantRuleCount;
    }

    /**
     * <p>
     * Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources to
     * evaluate upon resulting in insufficient data.
     * </p>
     * 
     * @return Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable
     *         resources to evaluate upon resulting in insufficient data.
     */
    public final Integer totalRuleCount() {
        return totalRuleCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compliantRuleCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantRuleCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalRuleCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackCompliance)) {
            return false;
        }
        AggregateConformancePackCompliance other = (AggregateConformancePackCompliance) obj;
        return Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(compliantRuleCount(), other.compliantRuleCount())
                && Objects.equals(nonCompliantRuleCount(), other.nonCompliantRuleCount())
                && Objects.equals(totalRuleCount(), other.totalRuleCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateConformancePackCompliance").add("ComplianceType", complianceTypeAsString())
                .add("CompliantRuleCount", compliantRuleCount()).add("NonCompliantRuleCount", nonCompliantRuleCount())
                .add("TotalRuleCount", totalRuleCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "CompliantRuleCount":
            return Optional.ofNullable(clazz.cast(compliantRuleCount()));
        case "NonCompliantRuleCount":
            return Optional.ofNullable(clazz.cast(nonCompliantRuleCount()));
        case "TotalRuleCount":
            return Optional.ofNullable(clazz.cast(totalRuleCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackCompliance, T> g) {
        return obj -> g.apply((AggregateConformancePackCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateConformancePackCompliance> {
        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * 
         * @param complianceType
         *        The compliance status of the conformance pack.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * 
         * @param complianceType
         *        The compliance status of the conformance pack.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);

        /**
         * <p>
         * The number of compliant AWS Config Rules.
         * </p>
         * 
         * @param compliantRuleCount
         *        The number of compliant AWS Config Rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantRuleCount(Integer compliantRuleCount);

        /**
         * <p>
         * The number of noncompliant AWS Config Rules.
         * </p>
         * 
         * @param nonCompliantRuleCount
         *        The number of noncompliant AWS Config Rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantRuleCount(Integer nonCompliantRuleCount);

        /**
         * <p>
         * Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable resources
         * to evaluate upon resulting in insufficient data.
         * </p>
         * 
         * @param totalRuleCount
         *        Total number of compliant rules, noncompliant rules, and the rules that do not have any applicable
         *        resources to evaluate upon resulting in insufficient data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRuleCount(Integer totalRuleCount);
    }

    static final class BuilderImpl implements Builder {
        private String complianceType;

        private Integer compliantRuleCount;

        private Integer nonCompliantRuleCount;

        private Integer totalRuleCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackCompliance model) {
            complianceType(model.complianceType);
            compliantRuleCount(model.compliantRuleCount);
            nonCompliantRuleCount(model.nonCompliantRuleCount);
            totalRuleCount(model.totalRuleCount);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Integer getCompliantRuleCount() {
            return compliantRuleCount;
        }

        @Override
        public final Builder compliantRuleCount(Integer compliantRuleCount) {
            this.compliantRuleCount = compliantRuleCount;
            return this;
        }

        public final void setCompliantRuleCount(Integer compliantRuleCount) {
            this.compliantRuleCount = compliantRuleCount;
        }

        public final Integer getNonCompliantRuleCount() {
            return nonCompliantRuleCount;
        }

        @Override
        public final Builder nonCompliantRuleCount(Integer nonCompliantRuleCount) {
            this.nonCompliantRuleCount = nonCompliantRuleCount;
            return this;
        }

        public final void setNonCompliantRuleCount(Integer nonCompliantRuleCount) {
            this.nonCompliantRuleCount = nonCompliantRuleCount;
        }

        public final Integer getTotalRuleCount() {
            return totalRuleCount;
        }

        @Override
        public final Builder totalRuleCount(Integer totalRuleCount) {
            this.totalRuleCount = totalRuleCount;
            return this;
        }

        public final void setTotalRuleCount(Integer totalRuleCount) {
            this.totalRuleCount = totalRuleCount;
        }

        @Override
        public AggregateConformancePackCompliance build() {
            return new AggregateConformancePackCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
