/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of conformance packs that are compliant and noncompliant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateConformancePackComplianceCount implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateConformancePackComplianceCount.Builder, AggregateConformancePackComplianceCount> {
    private static final SdkField<Integer> COMPLIANT_CONFORMANCE_PACK_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompliantConformancePackCount")
            .getter(getter(AggregateConformancePackComplianceCount::compliantConformancePackCount))
            .setter(setter(Builder::compliantConformancePackCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantConformancePackCount")
                    .build()).build();

    private static final SdkField<Integer> NON_COMPLIANT_CONFORMANCE_PACK_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantConformancePackCount")
            .getter(getter(AggregateConformancePackComplianceCount::nonCompliantConformancePackCount))
            .setter(setter(Builder::nonCompliantConformancePackCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantConformancePackCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANT_CONFORMANCE_PACK_COUNT_FIELD, NON_COMPLIANT_CONFORMANCE_PACK_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer compliantConformancePackCount;

    private final Integer nonCompliantConformancePackCount;

    private AggregateConformancePackComplianceCount(BuilderImpl builder) {
        this.compliantConformancePackCount = builder.compliantConformancePackCount;
        this.nonCompliantConformancePackCount = builder.nonCompliantConformancePackCount;
    }

    /**
     * <p>
     * Number of compliant conformance packs.
     * </p>
     * 
     * @return Number of compliant conformance packs.
     */
    public final Integer compliantConformancePackCount() {
        return compliantConformancePackCount;
    }

    /**
     * <p>
     * Number of noncompliant conformance packs.
     * </p>
     * 
     * @return Number of noncompliant conformance packs.
     */
    public final Integer nonCompliantConformancePackCount() {
        return nonCompliantConformancePackCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compliantConformancePackCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantConformancePackCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackComplianceCount)) {
            return false;
        }
        AggregateConformancePackComplianceCount other = (AggregateConformancePackComplianceCount) obj;
        return Objects.equals(compliantConformancePackCount(), other.compliantConformancePackCount())
                && Objects.equals(nonCompliantConformancePackCount(), other.nonCompliantConformancePackCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateConformancePackComplianceCount")
                .add("CompliantConformancePackCount", compliantConformancePackCount())
                .add("NonCompliantConformancePackCount", nonCompliantConformancePackCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompliantConformancePackCount":
            return Optional.ofNullable(clazz.cast(compliantConformancePackCount()));
        case "NonCompliantConformancePackCount":
            return Optional.ofNullable(clazz.cast(nonCompliantConformancePackCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackComplianceCount, T> g) {
        return obj -> g.apply((AggregateConformancePackComplianceCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateConformancePackComplianceCount> {
        /**
         * <p>
         * Number of compliant conformance packs.
         * </p>
         * 
         * @param compliantConformancePackCount
         *        Number of compliant conformance packs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantConformancePackCount(Integer compliantConformancePackCount);

        /**
         * <p>
         * Number of noncompliant conformance packs.
         * </p>
         * 
         * @param nonCompliantConformancePackCount
         *        Number of noncompliant conformance packs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantConformancePackCount(Integer nonCompliantConformancePackCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer compliantConformancePackCount;

        private Integer nonCompliantConformancePackCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackComplianceCount model) {
            compliantConformancePackCount(model.compliantConformancePackCount);
            nonCompliantConformancePackCount(model.nonCompliantConformancePackCount);
        }

        public final Integer getCompliantConformancePackCount() {
            return compliantConformancePackCount;
        }

        @Override
        public final Builder compliantConformancePackCount(Integer compliantConformancePackCount) {
            this.compliantConformancePackCount = compliantConformancePackCount;
            return this;
        }

        public final void setCompliantConformancePackCount(Integer compliantConformancePackCount) {
            this.compliantConformancePackCount = compliantConformancePackCount;
        }

        public final Integer getNonCompliantConformancePackCount() {
            return nonCompliantConformancePackCount;
        }

        @Override
        public final Builder nonCompliantConformancePackCount(Integer nonCompliantConformancePackCount) {
            this.nonCompliantConformancePackCount = nonCompliantConformancePackCount;
            return this;
        }

        public final void setNonCompliantConformancePackCount(Integer nonCompliantConformancePackCount) {
            this.nonCompliantConformancePackCount = nonCompliantConformancePackCount;
        }

        @Override
        public AggregateConformancePackComplianceCount build() {
            return new AggregateConformancePackComplianceCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
