/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher;
import software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher;
import software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher;

/**
 * Service client for accessing Config Service asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Config</fullname>
 * <p>
 * AWS Config provides a way to keep track of the configurations of all the AWS resources associated with your AWS
 * account. You can use AWS Config to get the current and historical configurations of each AWS resource and also to get
 * information about the relationship between the resources. An AWS resource can be an Amazon Compute Cloud (Amazon EC2)
 * instance, an Elastic Block Store (EBS) volume, an elastic network Interface (ENI), or a security group. For a
 * complete list of resources currently supported by AWS Config, see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
 * >Supported AWS Resources</a>.
 * </p>
 * <p>
 * You can access and manage AWS Config through the AWS Management Console, the AWS Command Line Interface (AWS CLI),
 * the AWS Config API, or the AWS SDKs for AWS Config. This reference guide contains documentation for the AWS Config
 * API and the AWS CLI commands that you can use to manage AWS Config. The AWS Config API uses the Signature Version 4
 * protocol for signing requests. For more information about how to sign a request with this protocol, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>. For detailed information about AWS Config features and their associated actions or commands, as well as
 * how to work with AWS Management Console, see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/WhatIsConfig.html">What Is AWS Config</a> in the
 * <i>AWS Config Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ConfigAsyncClient extends SdkClient {
    String SERVICE_NAME = "config";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "config";

    /**
     * Create a {@link ConfigAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConfigAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConfigAsyncClient}.
     */
    static ConfigAsyncClientBuilder builder() {
        return new DefaultConfigAsyncClientBuilder();
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your AWS Config aggregator. The
     * operation also returns a list of resources that are not processed in the current request. If there are no
     * unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your AWS Config aggregator. The
     * operation also returns a list of resources that are not processed in the current request. If there are no
     * unprocessed resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAggregateResourceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetAggregateResourceConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            Consumer<BatchGetAggregateResourceConfigRequest.Builder> batchGetAggregateResourceConfigRequest) {
        return batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest.builder()
                .applyMutation(batchGetAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the current configuration for one or more requested resources. The operation also returns a list of
     * resources that are not processed in the current request. If there are no unprocessed resources, the operation
     * returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current configuration for one or more requested resources. The operation also returns a list of
     * resources that are not processed in the current request. If there are no unprocessed resources, the operation
     * returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            Consumer<BatchGetResourceConfigRequest.Builder> batchGetResourceConfigRequest) {
        return batchGetResourceConfig(BatchGetResourceConfigRequest.builder().applyMutation(batchGetResourceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAggregationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAggregationAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAggregationAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            Consumer<DeleteAggregationAuthorizationRequest.Builder> deleteAggregationAuthorizationRequest) {
        return deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest.builder()
                .applyMutation(deleteAggregationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified AWS Config rule and all of its evaluation results.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a
     * rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request
     * for the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     *
     * @param deleteConfigRuleRequest
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified AWS Config rule and all of its evaluation results.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a
     * rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request
     * for the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(
            Consumer<DeleteConfigRuleRequest.Builder> deleteConfigRuleRequest) {
        return deleteConfigRule(DeleteConfigRuleRequest.builder().applyMutation(deleteConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationAggregatorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationAggregatorRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationAggregatorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            Consumer<DeleteConfigurationAggregatorRequest.Builder> deleteConfigurationAggregatorRequest) {
        return deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest.builder()
                .applyMutation(deleteConfigurationAggregatorRequest).build());
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, AWS Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the AWS Config console until you create a new configuration
     * recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, AWS Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the AWS Config console until you create a new configuration
     * recorder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationRecorderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationRecorderRequest.Builder} to create
     *        a request. The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            Consumer<DeleteConfigurationRecorderRequest.Builder> deleteConfigurationRecorderRequest) {
        return deleteConfigurationRecorder(DeleteConfigurationRecorderRequest.builder()
                .applyMutation(deleteConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the AWS Config rules, remediation actions, and all evaluation
     * results within that conformance pack.
     * </p>
     * <p>
     * AWS Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You
     * cannot update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteConformancePackRequest
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            DeleteConformancePackRequest deleteConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the AWS Config rules, remediation actions, and all evaluation
     * results within that conformance pack.
     * </p>
     * <p>
     * AWS Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You
     * cannot update a conformance pack while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConformancePackRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteConformancePackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConformancePackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            Consumer<DeleteConformancePackRequest.Builder> deleteConformancePackRequest) {
        return deleteConformancePack(DeleteConformancePackRequest.builder().applyMutation(deleteConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeliveryChannelRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeliveryChannelRequest.Builder} to create a
     *        request. The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in
     *        JSON format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            Consumer<DeleteDeliveryChannelRequest.Builder> deleteDeliveryChannelRequest) {
        return deleteDeliveryChannel(DeleteDeliveryChannelRequest.builder().applyMutation(deleteDeliveryChannelRequest).build());
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified AWS Config rule. You can specify one AWS Config rule per
     * request. After you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start
     * evaluating your AWS resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified AWS Config rule. You can specify one AWS Config rule per
     * request. After you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start
     * evaluating your AWS resources against the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationResultsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEvaluationResultsRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEvaluationResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            Consumer<DeleteEvaluationResultsRequest.Builder> deleteEvaluationResultsRequest) {
        return deleteEvaluationResults(DeleteEvaluationResultsRequest.builder().applyMutation(deleteEvaluationResultsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified organization config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator account can delete an organization config rule. When calling
     * this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a
     * rule while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator account can delete an organization config rule. When calling
     * this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a
     * rule while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOrganizationConfigRuleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            Consumer<DeleteOrganizationConfigRuleRequest.Builder> deleteOrganizationConfigRuleRequest) {
        return deleteOrganizationConfigRule(DeleteOrganizationConfigRuleRequest.builder()
                .applyMutation(deleteOrganizationConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a master account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a master account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConformancePackRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOrganizationConformancePackRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            Consumer<DeleteOrganizationConformancePackRequest.Builder> deleteOrganizationConformancePackRequest) {
        return deleteOrganizationConformancePack(DeleteOrganizationConformancePackRequest.builder()
                .applyMutation(deleteOrganizationConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePendingAggregationRequestRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePendingAggregationRequestRequest#builder()}
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     *        A {@link Consumer} that will call methods on {@link DeletePendingAggregationRequestRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            Consumer<DeletePendingAggregationRequestRequest.Builder> deletePendingAggregationRequestRequest) {
        return deletePendingAggregationRequest(DeletePendingAggregationRequestRequest.builder()
                .applyMutation(deletePendingAggregationRequestRequest).build());
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         AWS Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRemediationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         AWS Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            Consumer<DeleteRemediationConfigurationRequest.Builder> deleteRemediationConfigurationRequest) {
        return deleteRemediationConfiguration(DeleteRemediationConfigurationRequest.builder()
                .applyMutation(deleteRemediationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param deleteRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRemediationExceptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            Consumer<DeleteRemediationExceptionsRequest.Builder> deleteRemediationExceptionsRequest) {
        return deleteRemediationExceptions(DeleteRemediationExceptionsRequest.builder()
                .applyMutation(deleteRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your AWS Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            DeleteResourceConfigRequest deleteResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your AWS Config History.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceConfigRequest#builder()}
     * </p>
     *
     * @param deleteResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            Consumer<DeleteResourceConfigRequest.Builder> deleteResourceConfigRequest) {
        return deleteResourceConfig(DeleteResourceConfigRequest.builder().applyMutation(deleteResourceConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRetentionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRetentionConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            Consumer<DeleteRetentionConfigurationRequest.Builder> deleteRetentionConfigurationRequest) {
        return deleteRetentionConfiguration(DeleteRetentionConfigurationRequest.builder()
                .applyMutation(deleteRetentionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the stored query for a single AWS account and a single AWS Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the stored query for a single AWS account and a single AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStoredQueryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteStoredQueryRequest#builder()}
     * </p>
     *
     * @param deleteStoredQueryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStoredQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(
            Consumer<DeleteStoredQueryRequest.Builder> deleteStoredQueryRequest) {
        return deleteStoredQuery(DeleteStoredQueryRequest.builder().applyMutation(deleteStoredQueryRequest).build());
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, AWS Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, AWS Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeliverConfigSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeliverConfigSnapshotRequest#builder()}
     * </p>
     *
     * @param deliverConfigSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeliverConfigSnapshotRequest.Builder} to create a
     *        request. The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            Consumer<DeliverConfigSnapshotRequest.Builder> deliverConfigSnapshotRequest) {
        return deliverConfigSnapshot(DeliverConfigSnapshotRequest.builder().applyMutation(deliverConfigSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            Consumer<DescribeAggregateComplianceByConfigRulesRequest.Builder> describeAggregateComplianceByConfigRulesRequest) {
        return describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest.builder()
                .applyMutation(describeAggregateComplianceByConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant AWS Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant AWS Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            Consumer<DescribeAggregateComplianceByConformancePacksRequest.Builder> describeAggregateComplianceByConformancePacksRequest) {
        return describeAggregateComplianceByConformancePacks(DescribeAggregateComplianceByConformancePacksRequest.builder()
                .applyMutation(describeAggregateComplianceByConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAggregationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAggregationAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            Consumer<DescribeAggregationAuthorizationsRequest.Builder> describeAggregationAuthorizationsRequest) {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder()
                .applyMutation(describeAggregationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations() {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns
     * the number of AWS resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns
     * the number of AWS resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByConfigRuleRequest#builder()}
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeComplianceByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            Consumer<DescribeComplianceByConfigRuleRequest.Builder> describeComplianceByConfigRuleRequest) {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder()
                .applyMutation(describeComplianceByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns
     * the number of AWS resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule() {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified AWS resources are compliant. If a resource is noncompliant, this action returns
     * the number of AWS Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the AWS Config rules that evaluate it. It is noncompliant if it
     * does not comply with one or more of these rules.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified AWS resources are compliant. If a resource is noncompliant, this action returns
     * the number of AWS Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the AWS Config rules that evaluate it. It is noncompliant if it
     * does not comply with one or more of these rules.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByResourceRequest#builder()}
     * </p>
     *
     * @param describeComplianceByResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeComplianceByResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            Consumer<DescribeComplianceByResourceRequest.Builder> describeComplianceByResourceRequest) {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder()
                .applyMutation(describeComplianceByResourceRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified AWS resources are compliant. If a resource is noncompliant, this action returns
     * the number of AWS Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the AWS Config rules that evaluate it. It is noncompliant if it
     * does not comply with one or more of these rules.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource() {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder().build());
    }

    /**
     * <p>
     * Returns status information for each of your AWS managed Config rules. The status includes information such as the
     * last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error
     * for the last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for each of your AWS managed Config rules. The status includes information such as the
     * last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error
     * for the last failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRuleEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigRuleEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigRuleEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            Consumer<DescribeConfigRuleEvaluationStatusRequest.Builder> describeConfigRuleEvaluationStatusRequest) {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder()
                .applyMutation(describeConfigRuleEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Returns status information for each of your AWS managed Config rules. The status includes information such as the
     * last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error
     * for the last failure.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus() {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about your AWS Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            DescribeConfigRulesRequest describeConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about your AWS Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRulesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeConfigRulesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            Consumer<DescribeConfigRulesRequest.Builder> describeConfigRulesRequest) {
        return describeConfigRules(DescribeConfigRulesRequest.builder().applyMutation(describeConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns details about your AWS Config rules.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigRulesResponse> describeConfigRules() {
        return describeConfigRules(DescribeConfigRulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * AWS Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * AWS Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            Consumer<DescribeConfigurationAggregatorSourcesStatusRequest.Builder> describeConfigurationAggregatorSourcesStatusRequest) {
        return describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest.builder()
                .applyMutation(describeConfigurationAggregatorSourcesStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationAggregatorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationAggregatorsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationAggregatorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            Consumer<DescribeConfigurationAggregatorsRequest.Builder> describeConfigurationAggregatorsRequest) {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder()
                .applyMutation(describeConfigurationAggregatorsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators() {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder. If a configuration recorder is not specified,
     * this action returns the status of all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder. If a configuration recorder is not specified,
     * this action returns the status of all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecorderStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecorderStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationRecorderStatusRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            Consumer<DescribeConfigurationRecorderStatusRequest.Builder> describeConfigurationRecorderStatusRequest) {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder()
                .applyMutation(describeConfigurationRecorderStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder. If a configuration recorder is not specified,
     * this action returns the status of all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus() {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecordersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecordersRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecordersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationRecordersRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            Consumer<DescribeConfigurationRecordersRequest.Builder> describeConfigurationRecordersRequest) {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder()
                .applyMutation(describeConfigurationRecordersRequest).build());
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders() {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException AWS Config rule that you passed in the filter does not
     *         exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackComplianceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackComplianceRequest#builder()}
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConformancePackComplianceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException AWS Config rule that you passed in the filter does not
     *         exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            Consumer<DescribeConformancePackComplianceRequest.Builder> describeConformancePackComplianceRequest) {
        return describeConformancePackCompliance(DescribeConformancePackComplianceRequest.builder()
                .applyMutation(describeConformancePackComplianceRequest).build());
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackStatusRequest#builder()}
     * </p>
     *
     * @param describeConformancePackStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConformancePackStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            Consumer<DescribeConformancePackStatusRequest.Builder> describeConformancePackStatusRequest) {
        return describeConformancePackStatus(DescribeConformancePackStatusRequest.builder()
                .applyMutation(describeConformancePackStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePacksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeConformancePacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConformancePacksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            Consumer<DescribeConformancePacksRequest.Builder> describeConformancePacksRequest) {
        return describeConformancePacks(DescribeConformancePacksRequest.builder().applyMutation(describeConformancePacksRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDeliveryChannelStatusRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeliveryChannelStatusRequest.Builder} to
     *        create a request. The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            Consumer<DescribeDeliveryChannelStatusRequest.Builder> describeDeliveryChannelStatusRequest) {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder()
                .applyMutation(describeDeliveryChannelStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus() {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeliveryChannelsRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeliveryChannelsRequest.Builder} to create a
     *        request. The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            Consumer<DescribeDeliveryChannelsRequest.Builder> describeDeliveryChannelsRequest) {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().applyMutation(describeDeliveryChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels() {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().build());
    }

    /**
     * <p>
     * Provides organization config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConfigRuleStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConfigRuleStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigRuleStatusesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            Consumer<DescribeOrganizationConfigRuleStatusesRequest.Builder> describeOrganizationConfigRuleStatusesRequest) {
        return describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesRequest.builder()
                .applyMutation(describeOrganizationConfigRuleStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization config rule names. It is only applicable, when you request all the
     * organization config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigRulesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            Consumer<DescribeOrganizationConfigRulesRequest.Builder> describeOrganizationConfigRulesRequest) {
        return describeOrganizationConfigRules(DescribeOrganizationConfigRulesRequest.builder()
                .applyMutation(describeOrganizationConfigRulesRequest).build());
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePackStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePackStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeOrganizationConformancePackStatusesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            Consumer<DescribeOrganizationConformancePackStatusesRequest.Builder> describeOrganizationConformancePackStatusesRequest) {
        return describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesRequest.builder()
                .applyMutation(describeOrganizationConformancePackStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConformancePacksRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            Consumer<DescribeOrganizationConformancePacksRequest.Builder> describeOrganizationConformancePacksRequest) {
        return describeOrganizationConformancePacks(DescribeOrganizationConformancePacksRequest.builder()
                .applyMutation(describeOrganizationConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingAggregationRequestsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingAggregationRequestsRequest#builder()}
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingAggregationRequestsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(
            Consumer<DescribePendingAggregationRequestsRequest.Builder> describePendingAggregationRequestsRequest) {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder()
                .applyMutation(describePendingAggregationRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests() {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(
            DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRemediationConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(
            Consumer<DescribeRemediationConfigurationsRequest.Builder> describeRemediationConfigurationsRequest) {
        return describeRemediationConfigurations(DescribeRemediationConfigurationsRequest.builder()
                .applyMutation(describeRemediationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note>
     *
     * @param describeRemediationExceptionsRequest
     * @return A Java Future containing the result of the DescribeRemediationExceptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationExceptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest) {
        return describeRemediationExceptions(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsPublisher describeRemediationExceptionsPaginator(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsPublisher describeRemediationExceptionsPaginator(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest) {
        return describeRemediationExceptionsPaginator(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A Java Future containing the result of the DescribeRemediationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRemediationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest) {
        return describeRemediationExecutionStatus(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusPublisher describeRemediationExecutionStatusPaginator(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusPublisher describeRemediationExecutionStatusPaginator(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest) {
        return describeRemediationExecutionStatusPaginator(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetentionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetentionConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRetentionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(
            Consumer<DescribeRetentionConfigurationsRequest.Builder> describeRetentionConfigurationsRequest) {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder()
                .applyMutation(describeRetentionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations() {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule for a specific resource in a rule. The results
     * indicate which AWS resources were evaluated by the rule, when each resource was last evaluated, and whether each
     * resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetAggregateComplianceDetailsByConfigRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule for a specific resource in a rule. The results
     * indicate which AWS resources were evaluated by the rule, when each resource was last evaluated, and whether each
     * resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAggregateComplianceDetailsByConfigRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(
            Consumer<GetAggregateComplianceDetailsByConfigRuleRequest.Builder> getAggregateComplianceDetailsByConfigRuleRequest) {
        return getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getAggregateComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConfigRuleComplianceSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConfigRuleComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAggregateConfigRuleComplianceSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(
            Consumer<GetAggregateConfigRuleComplianceSummaryRequest.Builder> getAggregateConfigRuleComplianceSummaryRequest) {
        return getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConfigRuleComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all AWS Accounts and AWS Regions in an
     * aggregator. You can filter based on AWS Account ID or AWS Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConformancePackComplianceSummary operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> getAggregateConformancePackComplianceSummary(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all AWS Accounts and AWS Regions in an
     * aggregator. You can filter based on AWS Account ID or AWS Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAggregateConformancePackComplianceSummary operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> getAggregateConformancePackComplianceSummary(
            Consumer<GetAggregateConformancePackComplianceSummaryRequest.Builder> getAggregateConformancePackComplianceSummaryRequest) {
        return getAggregateConformancePackComplianceSummary(GetAggregateConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your AWS Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetAggregateDiscoveredResourceCounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your AWS Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateDiscoveredResourceCountsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetAggregateDiscoveredResourceCountsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAggregateDiscoveredResourceCounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(
            Consumer<GetAggregateDiscoveredResourceCountsRequest.Builder> getAggregateDiscoveredResourceCountsRequest) {
        return getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsRequest.builder()
                .applyMutation(getAggregateDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     * @return A Java Future containing the result of the GetAggregateResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>OversizedConfigurationItemException The configuration item size is outside the allowable range.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(
            GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAggregateResourceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetAggregateResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAggregateResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>OversizedConfigurationItemException The configuration item size is outside the allowable range.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(
            Consumer<GetAggregateResourceConfigRequest.Builder> getAggregateResourceConfigRequest) {
        return getAggregateResourceConfig(GetAggregateResourceConfigRequest.builder()
                .applyMutation(getAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule. The results indicate which AWS resources were
     * evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule. The results indicate which AWS resources were
     * evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceDetailsByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceDetailsByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(
            Consumer<GetComplianceDetailsByConfigRuleRequest.Builder> getComplianceDetailsByConfigRuleRequest) {
        return getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS resource. The results indicate which AWS Config rules were
     * used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS resource. The results indicate which AWS Config rules were
     * used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByResourceRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceDetailsByResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceDetailsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(
            Consumer<GetComplianceDetailsByResourceRequest.Builder> getComplianceDetailsByResourceRequest) {
        return getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest.builder()
                .applyMutation(getComplianceDetailsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceSummaryByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(
            Consumer<GetComplianceSummaryByConfigRuleRequest.Builder> getComplianceSummaryByConfigRuleRequest) {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder()
                .applyMutation(getComplianceSummaryByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule() {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByResourceTypeRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByResourceTypeRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceSummaryByResourceTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(
            Consumer<GetComplianceSummaryByResourceTypeRequest.Builder> getComplianceSummaryByResourceTypeRequest) {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder()
                .applyMutation(getComplianceSummaryByResourceTypeRequest).build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType() {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException AWS Config rule that you passed in the filter does not
     *         exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceDetailsResponse> getConformancePackComplianceDetails(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceDetailsRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetConformancePackComplianceDetailsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConformancePackComplianceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException AWS Config rule that you passed in the filter does not
     *         exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceDetailsResponse> getConformancePackComplianceDetails(
            Consumer<GetConformancePackComplianceDetailsRequest.Builder> getConformancePackComplianceDetailsRequest) {
        return getConformancePackComplianceDetails(GetConformancePackComplianceDetailsRequest.builder()
                .applyMutation(getConformancePackComplianceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceSummaryResponse> getConformancePackComplianceSummary(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetConformancePackComplianceSummaryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConformancePackComplianceSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConformancePackComplianceSummaryResponse> getConformancePackComplianceSummary(
            Consumer<GetConformancePackComplianceSummaryRequest.Builder> getConformancePackComplianceSummaryRequest) {
        return getConformancePackComplianceSummary(GetConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that AWS Config
     * is recording in this region for your AWS account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new AWS Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for AWS Config to record and count your resources. Wait a few minutes and then retry
     * the <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that AWS Config
     * is recording in this region for your AWS account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new AWS Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for AWS Config to record and count your resources. Wait a few minutes and then retry
     * the <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredResourceCountsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on {@link GetDiscoveredResourceCountsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(
            Consumer<GetDiscoveredResourceCountsRequest.Builder> getDiscoveredResourceCountsRequest) {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder()
                .applyMutation(getDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that AWS Config
     * is recording in this region for your AWS account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * AWS Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20
     * IAM users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new AWS Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for AWS Config to record and count your resources. Wait a few minutes and then retry
     * the <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts() {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder().build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization config rule.
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConfigRuleDetailedStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> getOrganizationConfigRuleDetailedStatus(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization config rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConfigRuleDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOrganizationConfigRuleDetailedStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException You specified one or more organization config rules that do not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> getOrganizationConfigRuleDetailedStatus(
            Consumer<GetOrganizationConfigRuleDetailedStatusRequest.Builder> getOrganizationConfigRuleDetailedStatusRequest) {
        return getOrganizationConfigRuleDetailedStatus(GetOrganizationConfigRuleDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConfigRuleDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConformancePackDetailedStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> getOrganizationConformancePackDetailedStatus(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConformancePackDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOrganizationConformancePackDetailedStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException AWS Config organization conformance pack that you passed
     *         in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> getOrganizationConformancePackDetailedStatus(
            Consumer<GetOrganizationConformancePackDetailedStatusRequest.Builder> getOrganizationConformancePackDetailedStatusRequest) {
        return getOrganizationConformancePackDetailedStatus(GetOrganizationConformancePackDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConformancePackDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A Java Future containing the result of the GetResourceConfigHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceConfigHistoryResponse> getResourceConfigHistory(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigHistoryRequest#builder()}
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceConfigHistoryRequest.Builder} to create a
     *        request. The input for the <a>GetResourceConfigHistory</a> action.
     * @return A Java Future containing the result of the GetResourceConfigHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceConfigHistoryResponse> getResourceConfigHistory(
            Consumer<GetResourceConfigHistoryRequest.Builder> getResourceConfigHistoryRequest) {
        return getResourceConfigHistory(GetResourceConfigHistoryRequest.builder().applyMutation(getResourceConfigHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryPublisher getResourceConfigHistoryPaginator(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
     * returns the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigHistoryRequest#builder()}
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceConfigHistoryRequest.Builder} to create a
     *        request. The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryPublisher getResourceConfigHistoryPaginator(
            Consumer<GetResourceConfigHistoryRequest.Builder> getResourceConfigHistoryRequest) {
        return getResourceConfigHistoryPaginator(GetResourceConfigHistoryRequest.builder()
                .applyMutation(getResourceConfigHistoryRequest).build());
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     *
     * @param getStoredQueryRequest
     * @return A Java Future containing the result of the GetStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStoredQueryResponse> getStoredQuery(GetStoredQueryRequest getStoredQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStoredQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GetStoredQueryRequest#builder()}
     * </p>
     *
     * @param getStoredQueryRequest
     *        A {@link Consumer} that will call methods on {@link GetStoredQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStoredQueryResponse> getStoredQuery(Consumer<GetStoredQueryRequest.Builder> getStoredQueryRequest) {
        return getStoredQuery(GetStoredQueryRequest.builder().applyMutation(getStoredQueryRequest).build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return A Java Future containing the result of the ListAggregateDiscoveredResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAggregateDiscoveredResourcesResponse> listAggregateDiscoveredResources(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregateDiscoveredResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAggregateDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListAggregateDiscoveredResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAggregateDiscoveredResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAggregateDiscoveredResourcesResponse> listAggregateDiscoveredResources(
            Consumer<ListAggregateDiscoveredResourcesRequest.Builder> listAggregateDiscoveredResourcesRequest) {
        return listAggregateDiscoveredResources(ListAggregateDiscoveredResourcesRequest.builder()
                .applyMutation(listAggregateDiscoveredResourcesRequest).build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that AWS Config has discovered, including those that AWS Config is not currently recording. You can
     * narrow the results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 resource identifiers on each page. You can customize
     * this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get
     * the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return A Java Future containing the result of the ListDiscoveredResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDiscoveredResourcesResponse> listDiscoveredResources(
            ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that AWS Config has discovered, including those that AWS Config is not currently recording. You can
     * narrow the results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, AWS Config lists 100 resource identifiers on each page. You can customize
     * this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get
     * the next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDiscoveredResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDiscoveredResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDiscoveredResourcesResponse> listDiscoveredResources(
            Consumer<ListDiscoveredResourcesRequest.Builder> listDiscoveredResourcesRequest) {
        return listDiscoveredResources(ListDiscoveredResourcesRequest.builder().applyMutation(listDiscoveredResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A Java Future containing the result of the ListStoredQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStoredQueriesResponse> listStoredQueries(ListStoredQueriesRequest listStoredQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStoredQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStoredQueriesRequest#builder()}
     * </p>
     *
     * @param listStoredQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListStoredQueriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStoredQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStoredQueriesResponse> listStoredQueries(
            Consumer<ListStoredQueriesRequest.Builder> listStoredQueriesRequest) {
        return listStoredQueries(ListStoredQueriesRequest.builder().applyMutation(listStoredQueriesRequest).build());
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListStoredQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesPublisher listStoredQueriesPaginator(ListStoredQueriesRequest listStoredQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListStoredQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStoredQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStoredQueriesRequest#builder()}
     * </p>
     *
     * @param listStoredQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListStoredQueriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesPublisher listStoredQueriesPaginator(
            Consumer<ListStoredQueriesRequest.Builder> listStoredQueriesRequest) {
        return listStoredQueriesPaginator(ListStoredQueriesRequest.builder().applyMutation(listStoredQueriesRequest).build());
    }

    /**
     * <p>
     * List the tags for AWS Config resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for AWS Config resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     *
     * @param putAggregationAuthorizationRequest
     * @return A Java Future containing the result of the PutAggregationAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAggregationAuthorizationResponse> putAggregationAuthorization(
            PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAggregationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link PutAggregationAuthorizationRequest#builder()}
     * </p>
     *
     * @param putAggregationAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link PutAggregationAuthorizationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutAggregationAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAggregationAuthorizationResponse> putAggregationAuthorization(
            Consumer<PutAggregationAuthorizationRequest.Builder> putAggregationAuthorizationRequest) {
        return putAggregationAuthorization(PutAggregationAuthorizationRequest.builder()
                .applyMutation(putAggregationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired
     * configurations.
     * </p>
     * <p>
     * You can use this action for custom AWS Config rules and AWS managed Config rules. A custom AWS Config rule is a
     * rule that you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config
     * provides.
     * </p>
     * <p>
     * If you are adding a new custom AWS Config rule, you must first create the AWS Lambda function that the rule
     * invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to AWS
     * Config, you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN
     * for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * If you are adding an AWS managed Config rule, specify the rule's identifier for the <code>SourceIdentifier</code>
     * key. To reference AWS managed Config rule identifiers, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About AWS
     * Managed Config Rules</a>.
     * </p>
     * <p>
     * For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do
     * not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by AWS
     * Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * The maximum number of rules that AWS Config supports is 150.
     * </p>
     * <p>
     * For information about requesting a rule limit increase, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a>
     * in the <i>AWS General Reference Guide</i>.
     * </p>
     * <p>
     * For more information about developing and using AWS Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource
     * Configurations with AWS Config</a> in the <i>AWS Config Developer Guide</i>.
     * </p>
     *
     * @param putConfigRuleRequest
     * @return A Java Future containing the result of the PutConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfConfigRulesExceededException Failed to add the AWS Config rule because the account already
     *         contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new
     *         rules.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutConfigRuleResponse> putConfigRule(PutConfigRuleRequest putConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired
     * configurations.
     * </p>
     * <p>
     * You can use this action for custom AWS Config rules and AWS managed Config rules. A custom AWS Config rule is a
     * rule that you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config
     * provides.
     * </p>
     * <p>
     * If you are adding a new custom AWS Config rule, you must first create the AWS Lambda function that the rule
     * invokes to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to AWS
     * Config, you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN
     * for the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * If you are adding an AWS managed Config rule, specify the rule's identifier for the <code>SourceIdentifier</code>
     * key. To reference AWS managed Config rule identifiers, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About AWS
     * Managed Config Rules</a>.
     * </p>
     * <p>
     * For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do
     * not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by AWS
     * Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * The maximum number of rules that AWS Config supports is 150.
     * </p>
     * <p>
     * For information about requesting a rule limit increase, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a>
     * in the <i>AWS General Reference Guide</i>.
     * </p>
     * <p>
     * For more information about developing and using AWS Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource
     * Configurations with AWS Config</a> in the <i>AWS Config Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigRuleRequest.Builder} avoiding the need to
     * create one manually via {@link PutConfigRuleRequest#builder()}
     * </p>
     *
     * @param putConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfConfigRulesExceededException Failed to add the AWS Config rule because the account already
     *         contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new
     *         rules.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutConfigRuleResponse> putConfigRule(Consumer<PutConfigRuleRequest.Builder> putConfigRuleRequest) {
        return putConfigRule(PutConfigRuleRequest.builder().applyMutation(putConfigRuleRequest).build());
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeAggregator</code> to get the previous accounts and then append
     * new ones.
     * </p>
     * <note>
     * <p>
     * AWS Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * AWS Config calls <code>EnableAwsServiceAccess</code> API to enable integration between AWS Config and AWS
     * Organizations. If the caller is a registered delegated administrator, AWS Config calls
     * <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the AWS Config developer guide.
     * </p>
     * </note>
     *
     * @param putConfigurationAggregatorRequest
     * @return A Java Future containing the result of the PutConfigurationAggregator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationAggregatorResponse> putConfigurationAggregator(
            PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeAggregator</code> to get the previous accounts and then append
     * new ones.
     * </p>
     * <note>
     * <p>
     * AWS Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * AWS Config calls <code>EnableAwsServiceAccess</code> API to enable integration between AWS Config and AWS
     * Organizations. If the caller is a registered delegated administrator, AWS Config calls
     * <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the AWS Config developer guide.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link PutConfigurationAggregatorRequest#builder()}
     * </p>
     *
     * @param putConfigurationAggregatorRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationAggregatorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutConfigurationAggregator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationAggregatorResponse> putConfigurationAggregator(
            Consumer<PutConfigurationAggregatorRequest.Builder> putConfigurationAggregatorRequest) {
        return putConfigurationAggregator(PutConfigurationAggregatorRequest.builder()
                .applyMutation(putConfigurationAggregatorRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration recorder to record the selected resource configurations.
     * </p>
     * <p>
     * You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. To change the role, call the action on the existing configuration recorder and specify a role.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * <p>
     * If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is
     * to record all supported resource types.
     * </p>
     * </note>
     *
     * @param putConfigurationRecorderRequest
     *        The input for the <a>PutConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the PutConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfConfigurationRecordersExceededException You have reached the limit of the number of
     *         recorders you can create.</li>
     *         <li>InvalidConfigurationRecorderNameException You have provided a configuration recorder name that is not
     *         valid.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>InvalidRecordingGroupException AWS Config throws an exception if the recording group does not contain
     *         a valid list of resource types. Invalid values might also be incorrectly formatted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationRecorderResponse> putConfigurationRecorder(
            PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration recorder to record the selected resource configurations.
     * </p>
     * <p>
     * You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. To change the role, call the action on the existing configuration recorder and specify a role.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * <p>
     * If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is
     * to record all supported resource types.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationRecorderRequest.Builder} avoiding
     * the need to create one manually via {@link PutConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param putConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationRecorderRequest.Builder} to create a
     *        request. The input for the <a>PutConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the PutConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfConfigurationRecordersExceededException You have reached the limit of the number of
     *         recorders you can create.</li>
     *         <li>InvalidConfigurationRecorderNameException You have provided a configuration recorder name that is not
     *         valid.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>InvalidRecordingGroupException AWS Config throws an exception if the recording group does not contain
     *         a valid list of resource types. Invalid values might also be incorrectly formatted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationRecorderResponse> putConfigurationRecorder(
            Consumer<PutConfigurationRecorderRequest.Builder> putConfigurationRecorderRequest) {
        return putConfigurationRecorder(PutConfigurationRecorderRequest.builder().applyMutation(putConfigurationRecorderRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates a conformance pack. A conformance pack is a collection of AWS Config rules that can be easily
     * deployed in an account and a region and across AWS Organization.
     * </p>
     * <p>
     * This API creates a service linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The service
     * linked role is created only when the role does not exist in your account.
     * </p>
     * <note>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * </note>
     *
     * @param putConformancePackRequest
     * @return A Java Future containing the result of the PutConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>ConformancePackTemplateValidationException You have specified a template that is not valid or
     *         supported.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfConformancePacksExceededException You have reached the limit (6) of the number of
     *         conformance packs in an account (6 conformance pack with 25 AWS Config rules per pack).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutConformancePackResponse> putConformancePack(PutConformancePackRequest putConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a conformance pack. A conformance pack is a collection of AWS Config rules that can be easily
     * deployed in an account and a region and across AWS Organization.
     * </p>
     * <p>
     * This API creates a service linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The service
     * linked role is created only when the role does not exist in your account.
     * </p>
     * <note>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConformancePackRequest.Builder} avoiding the
     * need to create one manually via {@link PutConformancePackRequest#builder()}
     * </p>
     *
     * @param putConformancePackRequest
     *        A {@link Consumer} that will call methods on {@link PutConformancePackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>ConformancePackTemplateValidationException You have specified a template that is not valid or
     *         supported.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfConformancePacksExceededException You have reached the limit (6) of the number of
     *         conformance packs in an account (6 conformance pack with 25 AWS Config rules per pack).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutConformancePackResponse> putConformancePack(
            Consumer<PutConformancePackRequest.Builder> putConformancePackRequest) {
        return putConformancePack(PutConformancePackRequest.builder().applyMutation(putConformancePackRequest).build());
    }

    /**
     * <p>
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS
     * topic.
     * </p>
     * <p>
     * Before you can create a delivery channel, you must create a configuration recorder.
     * </p>
     * <p>
     * You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel.
     * To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3
     * bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action
     * will keep the existing value for the parameter that is not changed.
     * </p>
     * <note>
     * <p>
     * You can have only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param putDeliveryChannelRequest
     *        The input for the <a>PutDeliveryChannel</a> action.
     * @return A Java Future containing the result of the PutDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfDeliveryChannelsExceededException You have reached the limit of the number of delivery
     *         channels you can create.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>InvalidDeliveryChannelNameException The specified delivery channel name is not valid.</li>
     *         <li>NoSuchBucketException The specified Amazon S3 bucket does not exist.</li>
     *         <li>InvalidS3KeyPrefixException The specified Amazon S3 key prefix is not valid.</li>
     *         <li>InvalidS3KmsKeyArnException The specified Amazon KMS Key ARN is not valid.</li>
     *         <li>InvalidSnsTopicArnException The specified Amazon SNS topic does not exist.</li>
     *         <li>InsufficientDeliveryPolicyException Your Amazon S3 bucket policy does not permit AWS Config to write
     *         to it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDeliveryChannelResponse> putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS
     * topic.
     * </p>
     * <p>
     * Before you can create a delivery channel, you must create a configuration recorder.
     * </p>
     * <p>
     * You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel.
     * To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3
     * bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action
     * will keep the existing value for the parameter that is not changed.
     * </p>
     * <note>
     * <p>
     * You can have only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliveryChannelRequest.Builder} avoiding the
     * need to create one manually via {@link PutDeliveryChannelRequest#builder()}
     * </p>
     *
     * @param putDeliveryChannelRequest
     *        A {@link Consumer} that will call methods on {@link PutDeliveryChannelRequest.Builder} to create a
     *        request. The input for the <a>PutDeliveryChannel</a> action.
     * @return A Java Future containing the result of the PutDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfDeliveryChannelsExceededException You have reached the limit of the number of delivery
     *         channels you can create.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>InvalidDeliveryChannelNameException The specified delivery channel name is not valid.</li>
     *         <li>NoSuchBucketException The specified Amazon S3 bucket does not exist.</li>
     *         <li>InvalidS3KeyPrefixException The specified Amazon S3 key prefix is not valid.</li>
     *         <li>InvalidS3KmsKeyArnException The specified Amazon KMS Key ARN is not valid.</li>
     *         <li>InvalidSnsTopicArnException The specified Amazon SNS topic does not exist.</li>
     *         <li>InsufficientDeliveryPolicyException Your Amazon S3 bucket policy does not permit AWS Config to write
     *         to it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDeliveryChannelResponse> putDeliveryChannel(
            Consumer<PutDeliveryChannelRequest.Builder> putDeliveryChannelRequest) {
        return putDeliveryChannel(PutDeliveryChannelRequest.builder().applyMutation(putDeliveryChannelRequest).build());
    }

    /**
     * <p>
     * Used by an AWS Lambda function to deliver evaluation results to AWS Config. This action is required in every AWS
     * Lambda function that is invoked by an AWS Config rule.
     * </p>
     *
     * @param putEvaluationsRequest
     * @return A Java Future containing the result of the PutEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidResultTokenException The specified <code>ResultToken</code> is invalid.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEvaluationsResponse> putEvaluations(PutEvaluationsRequest putEvaluationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by an AWS Lambda function to deliver evaluation results to AWS Config. This action is required in every AWS
     * Lambda function that is invoked by an AWS Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEvaluationsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEvaluationsRequest#builder()}
     * </p>
     *
     * @param putEvaluationsRequest
     *        A {@link Consumer} that will call methods on {@link PutEvaluationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InvalidResultTokenException The specified <code>ResultToken</code> is invalid.</li>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEvaluationsResponse> putEvaluations(Consumer<PutEvaluationsRequest.Builder> putEvaluationsRequest) {
        return putEvaluations(PutEvaluationsRequest.builder().applyMutation(putEvaluationsRequest).build());
    }

    /**
     * <p>
     * Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name
     * of the AWS Config rule is provided.
     * </p>
     *
     * @param putExternalEvaluationRequest
     * @return A Java Future containing the result of the PutExternalEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutExternalEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutExternalEvaluationResponse> putExternalEvaluation(
            PutExternalEvaluationRequest putExternalEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name
     * of the AWS Config rule is provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutExternalEvaluationRequest.Builder} avoiding the
     * need to create one manually via {@link PutExternalEvaluationRequest#builder()}
     * </p>
     *
     * @param putExternalEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link PutExternalEvaluationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutExternalEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutExternalEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutExternalEvaluationResponse> putExternalEvaluation(
            Consumer<PutExternalEvaluationRequest.Builder> putExternalEvaluationRequest) {
        return putExternalEvaluation(PutExternalEvaluationRequest.builder().applyMutation(putExternalEvaluationRequest).build());
    }

    /**
     * <p>
     * Adds or updates organization config rule for your entire organization evaluating whether your AWS resources
     * comply with your desired configurations.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can create or update an organization config rule. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a
     * service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated
     * administrator account of your organization. The service linked role is created only when the role does not exist
     * in the caller account. AWS Config verifies the existence of role with <code>GetRole</code> action.
     * </p>
     * <p>
     * To use this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * You can use this action to create both custom AWS Config rules and AWS managed Config rules. If you are adding a
     * new custom AWS Config rule, you must first create AWS Lambda function in the master account or a delegated
     * administrator that the rule invokes to evaluate your resources. When you use the
     * <code>PutOrganizationConfigRule</code> action to add the rule to AWS Config, you must specify the Amazon Resource
     * Name (ARN) that AWS Lambda assigns to the function. If you are adding an AWS managed Config rule, specify the
     * rule's identifier for the <code>RuleIdentifier</code> key.
     * </p>
     * <p>
     * The maximum number of organization config rules that AWS Config supports is 150 and 3 delegated administrator per
     * organization.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * Specify either <code>OrganizationCustomRuleMetadata</code> or <code>OrganizationManagedRuleMetadata</code>.
     * </p>
     * </note>
     *
     * @param putOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the PutOrganizationConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConfigRulesExceededException You have reached the limit of the number of
     *         organization config rules you can create.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOrganizationConfigRuleResponse> putOrganizationConfigRule(
            PutOrganizationConfigRuleRequest putOrganizationConfigRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates organization config rule for your entire organization evaluating whether your AWS resources
     * comply with your desired configurations.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can create or update an organization config rule. When
     * calling this API with a delegated administrator, you must ensure AWS Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a
     * service linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated
     * administrator account of your organization. The service linked role is created only when the role does not exist
     * in the caller account. AWS Config verifies the existence of role with <code>GetRole</code> action.
     * </p>
     * <p>
     * To use this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegated-administrator</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * You can use this action to create both custom AWS Config rules and AWS managed Config rules. If you are adding a
     * new custom AWS Config rule, you must first create AWS Lambda function in the master account or a delegated
     * administrator that the rule invokes to evaluate your resources. When you use the
     * <code>PutOrganizationConfigRule</code> action to add the rule to AWS Config, you must specify the Amazon Resource
     * Name (ARN) that AWS Lambda assigns to the function. If you are adding an AWS managed Config rule, specify the
     * rule's identifier for the <code>RuleIdentifier</code> key.
     * </p>
     * <p>
     * The maximum number of organization config rules that AWS Config supports is 150 and 3 delegated administrator per
     * organization.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * Specify either <code>OrganizationCustomRuleMetadata</code> or <code>OrganizationManagedRuleMetadata</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOrganizationConfigRuleRequest.Builder} avoiding
     * the need to create one manually via {@link PutOrganizationConfigRuleRequest#builder()}
     * </p>
     *
     * @param putOrganizationConfigRuleRequest
     *        A {@link Consumer} that will call methods on {@link PutOrganizationConfigRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutOrganizationConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConfigRulesExceededException You have reached the limit of the number of
     *         organization config rules you can create.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOrganizationConfigRuleResponse> putOrganizationConfigRule(
            Consumer<PutOrganizationConfigRuleRequest.Builder> putOrganizationConfigRuleRequest) {
        return putOrganizationConfigRule(PutOrganizationConfigRuleRequest.builder()
                .applyMutation(putOrganizationConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deploys conformance packs across member accounts in an AWS Organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can call this API. When calling this API with a delegated
     * administrator, you must ensure AWS Organizations <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the
     * <code>EnableAWSServiceAccess</code> action and creates a service linked role
     * <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your
     * organization. The service linked role is created only when the role does not exist in the caller account. To use
     * this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the
     * conformance pack is created or updated. You cannot update a conformance pack while it is in this state.
     * </p>
     * <p>
     * You can create 50 conformance packs with 25 AWS Config rules in each pack and 3 delegated administrator per
     * organization.
     * </p>
     * </note>
     *
     * @param putOrganizationConformancePackRequest
     * @return A Java Future containing the result of the PutOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConformancePacksExceededException You have reached the limit (6) of the number
     *         of organization conformance packs in an account (6 conformance pack with 25 AWS Config rules per pack per
     *         account).</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>OrganizationConformancePackTemplateValidationException You have specified a template that is not
     *         valid or supported.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOrganizationConformancePackResponse> putOrganizationConformancePack(
            PutOrganizationConformancePackRequest putOrganizationConformancePackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys conformance packs across member accounts in an AWS Organization.
     * </p>
     * <p>
     * Only a master account and a delegated administrator can call this API. When calling this API with a delegated
     * administrator, you must ensure AWS Organizations <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the
     * <code>EnableAWSServiceAccess</code> action and creates a service linked role
     * <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the master or delegated administrator account of your
     * organization. The service linked role is created only when the role does not exist in the caller account. To use
     * this API with delegated administrator, register a delegated administrator by calling AWS Organization
     * <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both AWS Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * <p>
     * AWS Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the
     * conformance pack is created or updated. You cannot update a conformance pack while it is in this state.
     * </p>
     * <p>
     * You can create 50 conformance packs with 25 AWS Config rules in each pack and 3 delegated administrator per
     * organization.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOrganizationConformancePackRequest.Builder}
     * avoiding the need to create one manually via {@link PutOrganizationConformancePackRequest#builder()}
     * </p>
     *
     * @param putOrganizationConformancePackRequest
     *        A {@link Consumer} that will call methods on {@link PutOrganizationConformancePackRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConformancePacksExceededException You have reached the limit (6) of the number
     *         of organization conformance packs in an account (6 conformance pack with 25 AWS Config rules per pack per
     *         account).</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your AWS Organization management account or the
     *         delegated administrator role changed. Delete this aggregator and create a new one with the current AWS
     *         Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous AWS Organization and AWS Config cannot
     *         aggregate data with current AWS Organization. Delete this aggregator and create a new one with the
     *         current AWS Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for AWS Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for AWS Config service principle name before the delegated administrator creates an
     *         aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, AWS Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         master account.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>OrganizationConformancePackTemplateValidationException You have specified a template that is not
     *         valid or supported.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException AWS Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOrganizationConformancePackResponse> putOrganizationConformancePack(
            Consumer<PutOrganizationConformancePackRequest.Builder> putOrganizationConformancePackRequest) {
        return putOrganizationConformancePack(PutOrganizationConformancePackRequest.builder()
                .applyMutation(putOrganizationConformancePackRequest).build());
    }

    /**
     * <p>
     * Adds or updates the remediation configuration with a specific AWS Config rule with the selected target or action.
     * The API creates the <code>RemediationConfiguration</code> object for the AWS Config rule. The AWS Config rule
     * must already exist for you to add a remediation configuration. The target (SSM document) must exist and have
     * permissions to use the target.
     * </p>
     * <note>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call this again to ensure the
     * remediations can run.
     * </p>
     * <p>
     * This API does not support adding remediation configurations for service-linked AWS Config Rules such as
     * Organization Config rules, the rules deployed by conformance packs, and rules deployed by AWS Security Hub.
     * </p>
     * </note>
     *
     * @param putRemediationConfigurationsRequest
     * @return A Java Future containing the result of the PutRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRemediationConfigurationsResponse> putRemediationConfigurations(
            PutRemediationConfigurationsRequest putRemediationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the remediation configuration with a specific AWS Config rule with the selected target or action.
     * The API creates the <code>RemediationConfiguration</code> object for the AWS Config rule. The AWS Config rule
     * must already exist for you to add a remediation configuration. The target (SSM document) must exist and have
     * permissions to use the target.
     * </p>
     * <note>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call this again to ensure the
     * remediations can run.
     * </p>
     * <p>
     * This API does not support adding remediation configurations for service-linked AWS Config Rules such as
     * Organization Config rules, the rules deployed by conformance packs, and rules deployed by AWS Security Hub.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRemediationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link PutRemediationConfigurationsRequest#builder()}
     * </p>
     *
     * @param putRemediationConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link PutRemediationConfigurationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRemediationConfigurationsResponse> putRemediationConfigurations(
            Consumer<PutRemediationConfigurationsRequest.Builder> putRemediationConfigurationsRequest) {
        return putRemediationConfigurations(PutRemediationConfigurationsRequest.builder()
                .applyMutation(putRemediationConfigurationsRequest).build());
    }

    /**
     * <p>
     * A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a
     * new exception or updates an existing exception for a specific resource with a specific AWS Config rule.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param putRemediationExceptionsRequest
     * @return A Java Future containing the result of the PutRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRemediationExceptionsResponse> putRemediationExceptions(
            PutRemediationExceptionsRequest putRemediationExceptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a
     * new exception or updates an existing exception for a specific resource with a specific AWS Config rule.
     * </p>
     * <note>
     * <p>
     * AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRemediationExceptionsRequest.Builder} avoiding
     * the need to create one manually via {@link PutRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param putRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutRemediationExceptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRemediationExceptionsResponse> putRemediationExceptions(
            Consumer<PutRemediationExceptionsRequest.Builder> putRemediationExceptionsRequest) {
        return putRemediationExceptions(PutRemediationExceptionsRequest.builder().applyMutation(putRemediationExceptionsRequest)
                .build());
    }

    /**
     * <p>
     * Records the configuration state for the resource provided in the request. The configuration state of a resource
     * is represented in AWS Config as Configuration Items. Once this API records the configuration item, you can
     * retrieve the list of configuration items for the custom resource type using existing AWS Config APIs.
     * </p>
     * <note>
     * <p>
     * The custom resource type must be registered with AWS CloudFormation. This API accepts the configuration item
     * registered with AWS CloudFormation.
     * </p>
     * <p>
     * When you call this API, AWS Config only stores configuration state of the resource provided in the request. This
     * API does not change or remediate the configuration of the resource.
     * </p>
     * <p>
     * Write-only schema properites are not recorded as part of the published configuration item.
     * </p>
     * </note>
     *
     * @param putResourceConfigRequest
     * @return A Java Future containing the result of the PutResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>MaxActiveResourcesExceededException You have reached the limit (100,000) of active custom resource
     *         types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourceConfigResponse> putResourceConfig(PutResourceConfigRequest putResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records the configuration state for the resource provided in the request. The configuration state of a resource
     * is represented in AWS Config as Configuration Items. Once this API records the configuration item, you can
     * retrieve the list of configuration items for the custom resource type using existing AWS Config APIs.
     * </p>
     * <note>
     * <p>
     * The custom resource type must be registered with AWS CloudFormation. This API accepts the configuration item
     * registered with AWS CloudFormation.
     * </p>
     * <p>
     * When you call this API, AWS Config only stores configuration state of the resource provided in the request. This
     * API does not change or remediate the configuration of the resource.
     * </p>
     * <p>
     * Write-only schema properites are not recorded as part of the published configuration item.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourceConfigRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourceConfigRequest#builder()}
     * </p>
     *
     * @param putResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link PutResourceConfigRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>MaxActiveResourcesExceededException You have reached the limit (100,000) of active custom resource
     *         types in your account. Delete unused resources using <code>DeleteResourceConfig</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourceConfigResponse> putResourceConfig(
            Consumer<PutResourceConfigRequest.Builder> putResourceConfigRequest) {
        return putResourceConfig(PutResourceConfigRequest.builder().applyMutation(putResourceConfigRequest).build());
    }

    /**
     * <p>
     * Creates and updates the retention configuration with details about retention period (number of days) that AWS
     * Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and
     * names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named
     * <b>default</b>, calling the API modifies the default object.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param putRetentionConfigurationRequest
     * @return A Java Future containing the result of the PutRetentionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfRetentionConfigurationsExceededException Failed to add the retention configuration because
     *         a retention configuration with that name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRetentionConfigurationResponse> putRetentionConfiguration(
            PutRetentionConfigurationRequest putRetentionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and updates the retention configuration with details about retention period (number of days) that AWS
     * Config stores your historical information. The API creates the <code>RetentionConfiguration</code> object and
     * names the object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named
     * <b>default</b>, calling the API modifies the default object.
     * </p>
     * <note>
     * <p>
     * Currently, AWS Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRetentionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutRetentionConfigurationRequest#builder()}
     * </p>
     *
     * @param putRetentionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutRetentionConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRetentionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>MaxNumberOfRetentionConfigurationsExceededException Failed to add the retention configuration because
     *         a retention configuration with that name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRetentionConfigurationResponse> putRetentionConfiguration(
            Consumer<PutRetentionConfigurationRequest.Builder> putRetentionConfigurationRequest) {
        return putRetentionConfiguration(PutRetentionConfigurationRequest.builder()
                .applyMutation(putRetentionConfigurationRequest).build());
    }

    /**
     * <p>
     * Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single AWS
     * account and a single AWS Region. You can create upto 300 queries in a single AWS account and a single AWS Region.
     * </p>
     *
     * @param putStoredQueryRequest
     * @return A Java Future containing the result of the PutStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. You have more than
     *         50 tags.</li>
     *         <li>ResourceConcurrentModificationException Two users are trying to modify the same query at the same
     *         time. Wait for a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutStoredQueryResponse> putStoredQuery(PutStoredQueryRequest putStoredQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single AWS
     * account and a single AWS Region. You can create upto 300 queries in a single AWS account and a single AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutStoredQueryRequest.Builder} avoiding the need to
     * create one manually via {@link PutStoredQueryRequest#builder()}
     * </p>
     *
     * @param putStoredQueryRequest
     *        A {@link Consumer} that will call methods on {@link PutStoredQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. You have more than
     *         50 tags.</li>
     *         <li>ResourceConcurrentModificationException Two users are trying to modify the same query at the same
     *         time. Wait for a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutStoredQueryResponse> putStoredQuery(Consumer<PutStoredQueryRequest.Builder> putStoredQueryRequest) {
        return putStoredQuery(PutStoredQueryRequest.builder().applyMutation(putStoredQueryRequest).build());
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     * @return A Java Future containing the result of the SelectAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SelectAggregateResourceConfigResponse> selectAggregateResourceConfig(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SelectAggregateResourceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link SelectAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link SelectAggregateResourceConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SelectAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SelectAggregateResourceConfigResponse> selectAggregateResourceConfig(
            Consumer<SelectAggregateResourceConfigRequest.Builder> selectAggregateResourceConfigRequest) {
        return selectAggregateResourceConfig(SelectAggregateResourceConfigRequest.builder()
                .applyMutation(selectAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default SelectAggregateResourceConfigPublisher selectAggregateResourceConfigPaginator(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS
     * resources across multiple accounts and regions, performs the corresponding search, and returns resource
     * configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SelectAggregateResourceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link SelectAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link SelectAggregateResourceConfigRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default SelectAggregateResourceConfigPublisher selectAggregateResourceConfigPaginator(
            Consumer<SelectAggregateResourceConfigRequest.Builder> selectAggregateResourceConfigRequest) {
        return selectAggregateResourceConfigPaginator(SelectAggregateResourceConfigRequest.builder()
                .applyMutation(selectAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and
     * returns resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     *
     * @param selectResourceConfigRequest
     * @return A Java Future containing the result of the SelectResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SelectResourceConfigResponse> selectResourceConfig(
            SelectResourceConfigRequest selectResourceConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and
     * returns resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the AWS Config Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SelectResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link SelectResourceConfigRequest#builder()}
     * </p>
     *
     * @param selectResourceConfigRequest
     *        A {@link Consumer} that will call methods on {@link SelectResourceConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SelectResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is invalid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SelectResourceConfigResponse> selectResourceConfig(
            Consumer<SelectResourceConfigRequest.Builder> selectResourceConfigRequest) {
        return selectResourceConfig(SelectResourceConfigRequest.builder().applyMutation(selectResourceConfigRequest).build());
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified AWS Config rules against the last known configuration state of the
     * resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working
     * as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your
     * resources. It re-runs an evaluation against the last known state of your resources.
     * </p>
     * <p>
     * You can specify up to 25 AWS Config rules per request.
     * </p>
     * <p>
     * An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can
     * call the API again. If you chose to have AWS Config stream to an Amazon SNS topic, you will receive a
     * <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.
     * </p>
     * <note>
     * <p>
     * You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When
     * you create a rule, AWS Config evaluates your resources against the rule automatically.
     * </p>
     * </note>
     * <p>
     * The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the
     * following example:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You have a custom rule that evaluates your IAM resources every 24 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You update your Lambda function to add additional conditions to your rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config invokes your Lambda function and evaluates your IAM resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule will still run periodic evaluations every 24 hours.
     * </p>
     * </li>
     * </ol>
     *
     * @param startConfigRulesEvaluationRequest
     * @return A Java Future containing the result of the StartConfigRulesEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigRulesEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigRulesEvaluationResponse> startConfigRulesEvaluation(
            StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified AWS Config rules against the last known configuration state of the
     * resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working
     * as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your
     * resources. It re-runs an evaluation against the last known state of your resources.
     * </p>
     * <p>
     * You can specify up to 25 AWS Config rules per request.
     * </p>
     * <p>
     * An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can
     * call the API again. If you chose to have AWS Config stream to an Amazon SNS topic, you will receive a
     * <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.
     * </p>
     * <note>
     * <p>
     * You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When
     * you create a rule, AWS Config evaluates your resources against the rule automatically.
     * </p>
     * </note>
     * <p>
     * The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the
     * following example:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You have a custom rule that evaluates your IAM resources every 24 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You update your Lambda function to add additional conditions to your rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config invokes your Lambda function and evaluates your IAM resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule will still run periodic evaluations every 24 hours.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConfigRulesEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link StartConfigRulesEvaluationRequest#builder()}
     * </p>
     *
     * @param startConfigRulesEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link StartConfigRulesEvaluationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartConfigRulesEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException One or more AWS Config rules in the request are invalid. Verify that the
     *         rule names are correct and try again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, AWS Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and AWS Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigRulesEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigRulesEvaluationResponse> startConfigRulesEvaluation(
            Consumer<StartConfigRulesEvaluationRequest.Builder> startConfigRulesEvaluationRequest) {
        return startConfigRulesEvaluation(StartConfigRulesEvaluationRequest.builder()
                .applyMutation(startConfigRulesEvaluationRequest).build());
    }

    /**
     * <p>
     * Starts recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     * <p>
     * You must have created at least one delivery channel to successfully start the configuration recorder.
     * </p>
     *
     * @param startConfigurationRecorderRequest
     *        The input for the <a>StartConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StartConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>NoAvailableDeliveryChannelException There is no delivery channel available to record configurations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigurationRecorderResponse> startConfigurationRecorder(
            StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     * <p>
     * You must have created at least one delivery channel to successfully start the configuration recorder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConfigurationRecorderRequest.Builder} avoiding
     * the need to create one manually via {@link StartConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param startConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on {@link StartConfigurationRecorderRequest.Builder} to create a
     *        request. The input for the <a>StartConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StartConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>NoAvailableDeliveryChannelException There is no delivery channel available to record configurations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartConfigurationRecorderResponse> startConfigurationRecorder(
            Consumer<StartConfigurationRecorderRequest.Builder> startConfigurationRecorderRequest) {
        return startConfigurationRecorder(StartConfigurationRecorderRequest.builder()
                .applyMutation(startConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Runs an on-demand remediation for the specified AWS Config rules against the last known remediation
     * configuration. It runs an execution against the current state of your resources. Remediation execution is
     * asynchronous.
     * </p>
     * <p>
     * You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified
     * resource keys must complete before you can call the API again.
     * </p>
     *
     * @param startRemediationExecutionRequest
     * @return A Java Future containing the result of the StartRemediationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartRemediationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRemediationExecutionResponse> startRemediationExecution(
            StartRemediationExecutionRequest startRemediationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an on-demand remediation for the specified AWS Config rules against the last known remediation
     * configuration. It runs an execution against the current state of your resources. Remediation execution is
     * asynchronous.
     * </p>
     * <p>
     * You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified
     * resource keys must complete before you can call the API again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRemediationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link StartRemediationExecutionRequest#builder()}
     * </p>
     *
     * @param startRemediationExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartRemediationExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartRemediationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are invalid. Verify that your
     *         parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to AWS Config lacks
     *         permissions to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the AWS Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To call IAM <code>GetRole</code> action or create a service linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To read Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoSuchRemediationConfigurationException You specified an AWS Config rule without a remediation
     *         configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartRemediationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartRemediationExecutionResponse> startRemediationExecution(
            Consumer<StartRemediationExecutionRequest.Builder> startRemediationExecutionRequest) {
        return startRemediationExecution(StartRemediationExecutionRequest.builder()
                .applyMutation(startRemediationExecutionRequest).build());
    }

    /**
     * <p>
     * Stops recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     *
     * @param stopConfigurationRecorderRequest
     *        The input for the <a>StopConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StopConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StopConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopConfigurationRecorderResponse> stopConfigurationRecorder(
            StopConfigurationRecorderRequest stopConfigurationRecorderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopConfigurationRecorderRequest.Builder} avoiding
     * the need to create one manually via {@link StopConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param stopConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on {@link StopConfigurationRecorderRequest.Builder} to create a
     *        request. The input for the <a>StopConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StopConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StopConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopConfigurationRecorderResponse> stopConfigurationRecorder(
            Consumer<StopConfigurationRecorderRequest.Builder> stopConfigurationRecorderRequest) {
        return stopConfigurationRecorder(StopConfigurationRecorderRequest.builder()
                .applyMutation(stopConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are
     * not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated
     * with that resource are deleted as well.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. You have more than
     *         50 tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are
     * not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated
     * with that resource are deleted as well.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. You have more than
     *         50 tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }
}
