/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An organization conformance pack that has information about conformance packs that AWS Config creates in member
 * accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConformancePack implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConformancePack.Builder, OrganizationConformancePack> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConformancePackName")
            .getter(getter(OrganizationConformancePack::organizationConformancePackName))
            .setter(setter(Builder::organizationConformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName")
                    .build()).build();

    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConformancePackArn")
            .getter(getter(OrganizationConformancePack::organizationConformancePackArn))
            .setter(setter(Builder::organizationConformancePackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackArn")
                    .build()).build();

    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3Bucket").getter(getter(OrganizationConformancePack::deliveryS3Bucket))
            .setter(setter(Builder::deliveryS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()).build();

    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3KeyPrefix").getter(getter(OrganizationConformancePack::deliveryS3KeyPrefix))
            .setter(setter(Builder::deliveryS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build())
            .build();

    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField
            .<List<ConformancePackInputParameter>> builder(MarshallingType.LIST)
            .memberName("ConformancePackInputParameters")
            .getter(getter(OrganizationConformancePack::conformancePackInputParameters))
            .setter(setter(Builder::conformancePackInputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackInputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackInputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedAccounts")
            .getter(getter(OrganizationConformancePack::excludedAccounts))
            .setter(setter(Builder::excludedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(OrganizationConformancePack::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, ORGANIZATION_CONFORMANCE_PACK_ARN_FIELD, DELIVERY_S3_BUCKET_FIELD,
            DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, EXCLUDED_ACCOUNTS_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationConformancePackName;

    private final String organizationConformancePackArn;

    private final String deliveryS3Bucket;

    private final String deliveryS3KeyPrefix;

    private final List<ConformancePackInputParameter> conformancePackInputParameters;

    private final List<String> excludedAccounts;

    private final Instant lastUpdateTime;

    private OrganizationConformancePack(BuilderImpl builder) {
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.organizationConformancePackArn = builder.organizationConformancePackArn;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.excludedAccounts = builder.excludedAccounts;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name you assign to an organization conformance pack.
     * </p>
     * 
     * @return The name you assign to an organization conformance pack.
     */
    public final String organizationConformancePackName() {
        return organizationConformancePackName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of organization conformance pack.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of organization conformance pack.
     */
    public final String organizationConformancePackArn() {
        return organizationConformancePackArn;
    }

    /**
     * <p>
     * Amazon S3 bucket where AWS Config stores conformance pack templates.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return Amazon S3 bucket where AWS Config stores conformance pack templates. </p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3Bucket() {
        return deliveryS3Bucket;
    }

    /**
     * <p>
     * Any folder structure you want to add to an Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return Any folder structure you want to add to an Amazon S3 bucket.</p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3KeyPrefix() {
        return deliveryS3KeyPrefix;
    }

    /**
     * Returns true if the ConformancePackInputParameters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasConformancePackInputParameters() {
        return conformancePackInputParameters != null && !(conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackInputParameter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackInputParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ConformancePackInputParameter</code> objects.
     */
    public final List<ConformancePackInputParameter> conformancePackInputParameters() {
        return conformancePackInputParameters;
    }

    /**
     * Returns true if the ExcludedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExcludedAccounts() {
        return excludedAccounts != null && !(excludedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A comma-separated list of accounts excluded from organization conformance pack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A comma-separated list of accounts excluded from organization conformance pack.
     */
    public final List<String> excludedAccounts() {
        return excludedAccounts;
    }

    /**
     * <p>
     * Last time when organization conformation pack was updated.
     * </p>
     * 
     * @return Last time when organization conformation pack was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3KeyPrefix());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackInputParameters() ? conformancePackInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedAccounts() ? excludedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePack)) {
            return false;
        }
        OrganizationConformancePack other = (OrganizationConformancePack) obj;
        return Objects.equals(organizationConformancePackName(), other.organizationConformancePackName())
                && Objects.equals(organizationConformancePackArn(), other.organizationConformancePackArn())
                && Objects.equals(deliveryS3Bucket(), other.deliveryS3Bucket())
                && Objects.equals(deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix())
                && hasConformancePackInputParameters() == other.hasConformancePackInputParameters()
                && Objects.equals(conformancePackInputParameters(), other.conformancePackInputParameters())
                && hasExcludedAccounts() == other.hasExcludedAccounts()
                && Objects.equals(excludedAccounts(), other.excludedAccounts())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OrganizationConformancePack")
                .add("OrganizationConformancePackName", organizationConformancePackName())
                .add("OrganizationConformancePackArn", organizationConformancePackArn())
                .add("DeliveryS3Bucket", deliveryS3Bucket())
                .add("DeliveryS3KeyPrefix", deliveryS3KeyPrefix())
                .add("ConformancePackInputParameters",
                        hasConformancePackInputParameters() ? conformancePackInputParameters() : null)
                .add("ExcludedAccounts", hasExcludedAccounts() ? excludedAccounts() : null)
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackName":
            return Optional.ofNullable(clazz.cast(organizationConformancePackName()));
        case "OrganizationConformancePackArn":
            return Optional.ofNullable(clazz.cast(organizationConformancePackArn()));
        case "DeliveryS3Bucket":
            return Optional.ofNullable(clazz.cast(deliveryS3Bucket()));
        case "DeliveryS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(deliveryS3KeyPrefix()));
        case "ConformancePackInputParameters":
            return Optional.ofNullable(clazz.cast(conformancePackInputParameters()));
        case "ExcludedAccounts":
            return Optional.ofNullable(clazz.cast(excludedAccounts()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePack, T> g) {
        return obj -> g.apply((OrganizationConformancePack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConformancePack> {
        /**
         * <p>
         * The name you assign to an organization conformance pack.
         * </p>
         * 
         * @param organizationConformancePackName
         *        The name you assign to an organization conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackName(String organizationConformancePackName);

        /**
         * <p>
         * Amazon Resource Name (ARN) of organization conformance pack.
         * </p>
         * 
         * @param organizationConformancePackArn
         *        Amazon Resource Name (ARN) of organization conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackArn(String organizationConformancePackArn);

        /**
         * <p>
         * Amazon S3 bucket where AWS Config stores conformance pack templates.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3Bucket
         *        Amazon S3 bucket where AWS Config stores conformance pack templates. </p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3Bucket(String deliveryS3Bucket);

        /**
         * <p>
         * Any folder structure you want to add to an Amazon S3 bucket.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3KeyPrefix
         *        Any folder structure you want to add to an Amazon S3 bucket.</p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackInputParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackInputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackInputParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackInputParameters(List<ConformancePackInputParameter>)}.
         * 
         * @param conformancePackInputParameters
         *        a consumer that will call methods on {@link List<ConformancePackInputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackInputParameters(List<ConformancePackInputParameter>)
         */
        Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters);

        /**
         * <p>
         * A comma-separated list of accounts excluded from organization conformance pack.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts excluded from organization conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(Collection<String> excludedAccounts);

        /**
         * <p>
         * A comma-separated list of accounts excluded from organization conformance pack.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts excluded from organization conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(String... excludedAccounts);

        /**
         * <p>
         * Last time when organization conformation pack was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        Last time when organization conformation pack was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String organizationConformancePackName;

        private String organizationConformancePackArn;

        private String deliveryS3Bucket;

        private String deliveryS3KeyPrefix;

        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePack model) {
            organizationConformancePackName(model.organizationConformancePackName);
            organizationConformancePackArn(model.organizationConformancePackArn);
            deliveryS3Bucket(model.deliveryS3Bucket);
            deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            conformancePackInputParameters(model.conformancePackInputParameters);
            excludedAccounts(model.excludedAccounts);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConformancePackName() {
            return organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        public final String getOrganizationConformancePackArn() {
            return organizationConformancePackArn;
        }

        @Override
        public final Builder organizationConformancePackArn(String organizationConformancePackArn) {
            this.organizationConformancePackArn = organizationConformancePackArn;
            return this;
        }

        public final void setOrganizationConformancePackArn(String organizationConformancePackArn) {
            this.organizationConformancePackArn = organizationConformancePackArn;
        }

        public final String getDeliveryS3Bucket() {
            return deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final List<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            List<ConformancePackInputParameter.Builder> result = ConformancePackInputParametersCopier
                    .copyToBuilder(this.conformancePackInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conformancePackInputParameters(
                Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters) {
            conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(
                Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters) {
            conformancePackInputParameters(Stream.of(conformancePackInputParameters)
                    .map(c -> ConformancePackInputParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(
                Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier
                    .copyFromBuilder(conformancePackInputParameters);
        }

        public final Collection<String> getExcludedAccounts() {
            if (excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String... excludedAccounts) {
            excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public OrganizationConformancePack build() {
            return new OrganizationConformancePack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
