/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigRuleEvaluationStatusResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigRuleEvaluationStatusResponse.Builder, DescribeConfigRuleEvaluationStatusResponse> {
    private static final SdkField<List<ConfigRuleEvaluationStatus>> CONFIG_RULES_EVALUATION_STATUS_FIELD = SdkField
            .<List<ConfigRuleEvaluationStatus>> builder(MarshallingType.LIST)
            .memberName("ConfigRulesEvaluationStatus")
            .getter(getter(DescribeConfigRuleEvaluationStatusResponse::configRulesEvaluationStatus))
            .setter(setter(Builder::configRulesEvaluationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRulesEvaluationStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigRuleEvaluationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigRuleEvaluationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigRuleEvaluationStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIG_RULES_EVALUATION_STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus;

    private final String nextToken;

    private DescribeConfigRuleEvaluationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.configRulesEvaluationStatus = builder.configRulesEvaluationStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConfigRulesEvaluationStatus property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasConfigRulesEvaluationStatus() {
        return configRulesEvaluationStatus != null && !(configRulesEvaluationStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status information about your AWS managed Config rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigRulesEvaluationStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Status information about your AWS managed Config rules.
     */
    public final List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus() {
        return configRulesEvaluationStatus;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigRulesEvaluationStatus() ? configRulesEvaluationStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRuleEvaluationStatusResponse)) {
            return false;
        }
        DescribeConfigRuleEvaluationStatusResponse other = (DescribeConfigRuleEvaluationStatusResponse) obj;
        return hasConfigRulesEvaluationStatus() == other.hasConfigRulesEvaluationStatus()
                && Objects.equals(configRulesEvaluationStatus(), other.configRulesEvaluationStatus())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigRuleEvaluationStatusResponse")
                .add("ConfigRulesEvaluationStatus", hasConfigRulesEvaluationStatus() ? configRulesEvaluationStatus() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRulesEvaluationStatus":
            return Optional.ofNullable(clazz.cast(configRulesEvaluationStatus()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigRuleEvaluationStatusResponse, T> g) {
        return obj -> g.apply((DescribeConfigRuleEvaluationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusResponse> {
        /**
         * <p>
         * Status information about your AWS managed Config rules.
         * </p>
         * 
         * @param configRulesEvaluationStatus
         *        Status information about your AWS managed Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRulesEvaluationStatus(Collection<ConfigRuleEvaluationStatus> configRulesEvaluationStatus);

        /**
         * <p>
         * Status information about your AWS managed Config rules.
         * </p>
         * 
         * @param configRulesEvaluationStatus
         *        Status information about your AWS managed Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRulesEvaluationStatus(ConfigRuleEvaluationStatus... configRulesEvaluationStatus);

        /**
         * <p>
         * Status information about your AWS managed Config rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigRuleEvaluationStatus>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigRuleEvaluationStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigRuleEvaluationStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #configRulesEvaluationStatus(List<ConfigRuleEvaluationStatus>)}.
         * 
         * @param configRulesEvaluationStatus
         *        a consumer that will call methods on {@link List<ConfigRuleEvaluationStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configRulesEvaluationStatus(List<ConfigRuleEvaluationStatus>)
         */
        Builder configRulesEvaluationStatus(Consumer<ConfigRuleEvaluationStatus.Builder>... configRulesEvaluationStatus);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRuleEvaluationStatusResponse model) {
            super(model);
            configRulesEvaluationStatus(model.configRulesEvaluationStatus);
            nextToken(model.nextToken);
        }

        public final List<ConfigRuleEvaluationStatus.Builder> getConfigRulesEvaluationStatus() {
            List<ConfigRuleEvaluationStatus.Builder> result = ConfigRuleEvaluationStatusListCopier
                    .copyToBuilder(this.configRulesEvaluationStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configRulesEvaluationStatus(Collection<ConfigRuleEvaluationStatus> configRulesEvaluationStatus) {
            this.configRulesEvaluationStatus = ConfigRuleEvaluationStatusListCopier.copy(configRulesEvaluationStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRulesEvaluationStatus(ConfigRuleEvaluationStatus... configRulesEvaluationStatus) {
            configRulesEvaluationStatus(Arrays.asList(configRulesEvaluationStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRulesEvaluationStatus(
                Consumer<ConfigRuleEvaluationStatus.Builder>... configRulesEvaluationStatus) {
            configRulesEvaluationStatus(Stream.of(configRulesEvaluationStatus)
                    .map(c -> ConfigRuleEvaluationStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigRulesEvaluationStatus(
                Collection<ConfigRuleEvaluationStatus.BuilderImpl> configRulesEvaluationStatus) {
            this.configRulesEvaluationStatus = ConfigRuleEvaluationStatusListCopier.copyFromBuilder(configRulesEvaluationStatus);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRuleEvaluationStatusResponse build() {
            return new DescribeConfigRuleEvaluationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
