/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryInfo implements SdkPojo, Serializable, ToCopyableBuilder<QueryInfo.Builder, QueryInfo> {
    private static final SdkField<List<FieldInfo>> SELECT_FIELDS_FIELD = SdkField
            .<List<FieldInfo>> builder(MarshallingType.LIST)
            .memberName("SelectFields")
            .getter(getter(QueryInfo::selectFields))
            .setter(setter(Builder::selectFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECT_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FieldInfo> selectFields;

    private QueryInfo(BuilderImpl builder) {
        this.selectFields = builder.selectFields;
    }

    /**
     * Returns true if the SelectFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSelectFields() {
        return selectFields != null && !(selectFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a <code>FieldInfo</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSelectFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a <code>FieldInfo</code> object.
     */
    public final List<FieldInfo> selectFields() {
        return selectFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectFields() ? selectFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInfo)) {
            return false;
        }
        QueryInfo other = (QueryInfo) obj;
        return hasSelectFields() == other.hasSelectFields() && Objects.equals(selectFields(), other.selectFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryInfo").add("SelectFields", hasSelectFields() ? selectFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectFields":
            return Optional.ofNullable(clazz.cast(selectFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryInfo, T> g) {
        return obj -> g.apply((QueryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryInfo> {
        /**
         * <p>
         * Returns a <code>FieldInfo</code> object.
         * </p>
         * 
         * @param selectFields
         *        Returns a <code>FieldInfo</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectFields(Collection<FieldInfo> selectFields);

        /**
         * <p>
         * Returns a <code>FieldInfo</code> object.
         * </p>
         * 
         * @param selectFields
         *        Returns a <code>FieldInfo</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectFields(FieldInfo... selectFields);

        /**
         * <p>
         * Returns a <code>FieldInfo</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FieldInfo>.Builder} avoiding the need to
         * create one manually via {@link List<FieldInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FieldInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #selectFields(List<FieldInfo>)}.
         * 
         * @param selectFields
         *        a consumer that will call methods on {@link List<FieldInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectFields(List<FieldInfo>)
         */
        Builder selectFields(Consumer<FieldInfo.Builder>... selectFields);
    }

    static final class BuilderImpl implements Builder {
        private List<FieldInfo> selectFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInfo model) {
            selectFields(model.selectFields);
        }

        public final Collection<FieldInfo.Builder> getSelectFields() {
            if (selectFields instanceof SdkAutoConstructList) {
                return null;
            }
            return selectFields != null ? selectFields.stream().map(FieldInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectFields(Collection<FieldInfo> selectFields) {
            this.selectFields = FieldInfoListCopier.copy(selectFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectFields(FieldInfo... selectFields) {
            selectFields(Arrays.asList(selectFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectFields(Consumer<FieldInfo.Builder>... selectFields) {
            selectFields(Stream.of(selectFields).map(c -> FieldInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSelectFields(Collection<FieldInfo.BuilderImpl> selectFields) {
            this.selectFields = FieldInfoListCopier.copyFromBuilder(selectFields);
        }

        @Override
        public QueryInfo build() {
            return new QueryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
