/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance;
import software.amazon.awssdk.services.config.model.ConformancePackRuleComplianceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConformancePackComplianceResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConformancePackComplianceResponse> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(DescribeConformancePackComplianceResponse.getter(DescribeConformancePackComplianceResponse::conformancePackName)).setter(DescribeConformancePackComplianceResponse.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<List<ConformancePackRuleCompliance>> CONFORMANCE_PACK_RULE_COMPLIANCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackRuleComplianceList").getter(DescribeConformancePackComplianceResponse.getter(DescribeConformancePackComplianceResponse::conformancePackRuleComplianceList)).setter(DescribeConformancePackComplianceResponse.setter(Builder::conformancePackRuleComplianceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackRuleComplianceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackRuleCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConformancePackComplianceResponse.getter(DescribeConformancePackComplianceResponse::nextToken)).setter(DescribeConformancePackComplianceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, CONFORMANCE_PACK_RULE_COMPLIANCE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String conformancePackName;
    private final List<ConformancePackRuleCompliance> conformancePackRuleComplianceList;
    private final String nextToken;

    private DescribeConformancePackComplianceResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackRuleComplianceList = builder.conformancePackRuleComplianceList;
        this.nextToken = builder.nextToken;
    }

    public final String conformancePackName() {
        return this.conformancePackName;
    }

    public final boolean hasConformancePackRuleComplianceList() {
        return this.conformancePackRuleComplianceList != null && !(this.conformancePackRuleComplianceList instanceof SdkAutoConstructList);
    }

    public final List<ConformancePackRuleCompliance> conformancePackRuleComplianceList() {
        return this.conformancePackRuleComplianceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackRuleComplianceList() ? this.conformancePackRuleComplianceList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConformancePackComplianceResponse)) {
            return false;
        }
        DescribeConformancePackComplianceResponse other = (DescribeConformancePackComplianceResponse)((Object)obj);
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && this.hasConformancePackRuleComplianceList() == other.hasConformancePackRuleComplianceList() && Objects.equals(this.conformancePackRuleComplianceList(), other.conformancePackRuleComplianceList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConformancePackComplianceResponse").add("ConformancePackName", (Object)this.conformancePackName()).add("ConformancePackRuleComplianceList", this.hasConformancePackRuleComplianceList() ? this.conformancePackRuleComplianceList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ConformancePackRuleComplianceList": {
                return Optional.ofNullable(clazz.cast(this.conformancePackRuleComplianceList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConformancePackComplianceResponse, T> g) {
        return obj -> g.apply((DescribeConformancePackComplianceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String conformancePackName;
        private List<ConformancePackRuleCompliance> conformancePackRuleComplianceList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConformancePackComplianceResponse model) {
            super(model);
            this.conformancePackName(model.conformancePackName);
            this.conformancePackRuleComplianceList(model.conformancePackRuleComplianceList);
            this.nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final List<ConformancePackRuleCompliance.Builder> getConformancePackRuleComplianceList() {
            List<ConformancePackRuleCompliance.Builder> result = ConformancePackRuleComplianceListCopier.copyToBuilder(this.conformancePackRuleComplianceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conformancePackRuleComplianceList(Collection<ConformancePackRuleCompliance> conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList = ConformancePackRuleComplianceListCopier.copy(conformancePackRuleComplianceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleComplianceList(ConformancePackRuleCompliance ... conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList(Arrays.asList(conformancePackRuleComplianceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleComplianceList(Consumer<ConformancePackRuleCompliance.Builder> ... conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList(Stream.of(conformancePackRuleComplianceList).map(c -> (ConformancePackRuleCompliance)((ConformancePackRuleCompliance.Builder)ConformancePackRuleCompliance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackRuleComplianceList(Collection<ConformancePackRuleCompliance.BuilderImpl> conformancePackRuleComplianceList) {
            this.conformancePackRuleComplianceList = ConformancePackRuleComplianceListCopier.copyFromBuilder(conformancePackRuleComplianceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConformancePackComplianceResponse build() {
            return new DescribeConformancePackComplianceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConformancePackComplianceResponse> {
        public Builder conformancePackName(String var1);

        public Builder conformancePackRuleComplianceList(Collection<ConformancePackRuleCompliance> var1);

        public Builder conformancePackRuleComplianceList(ConformancePackRuleCompliance ... var1);

        public Builder conformancePackRuleComplianceList(Consumer<ConformancePackRuleCompliance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

