/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConformancePackComplianceDetailsResponse extends ConfigResponse implements
        ToCopyableBuilder<GetConformancePackComplianceDetailsResponse.Builder, GetConformancePackComplianceDetailsResponse> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(GetConformancePackComplianceDetailsResponse::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<List<ConformancePackEvaluationResult>> CONFORMANCE_PACK_RULE_EVALUATION_RESULTS_FIELD = SdkField
            .<List<ConformancePackEvaluationResult>> builder(MarshallingType.LIST)
            .memberName("ConformancePackRuleEvaluationResults")
            .getter(getter(GetConformancePackComplianceDetailsResponse::conformancePackRuleEvaluationResults))
            .setter(setter(Builder::conformancePackRuleEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ConformancePackRuleEvaluationResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackEvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackEvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConformancePackComplianceDetailsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            CONFORMANCE_PACK_RULE_EVALUATION_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String conformancePackName;

    private final List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults;

    private final String nextToken;

    private GetConformancePackComplianceDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackRuleEvaluationResults = builder.conformancePackRuleEvaluationResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Name of the conformance pack.
     * </p>
     * 
     * @return Name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * Returns true if the ConformancePackRuleEvaluationResults property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasConformancePackRuleEvaluationResults() {
        return conformancePackRuleEvaluationResults != null
                && !(conformancePackRuleEvaluationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>ConformancePackEvaluationResult</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackRuleEvaluationResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of <code>ConformancePackEvaluationResult</code> objects.
     */
    public final List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults() {
        return conformancePackRuleEvaluationResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackRuleEvaluationResults() ? conformancePackRuleEvaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConformancePackComplianceDetailsResponse)) {
            return false;
        }
        GetConformancePackComplianceDetailsResponse other = (GetConformancePackComplianceDetailsResponse) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && hasConformancePackRuleEvaluationResults() == other.hasConformancePackRuleEvaluationResults()
                && Objects.equals(conformancePackRuleEvaluationResults(), other.conformancePackRuleEvaluationResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetConformancePackComplianceDetailsResponse")
                .add("ConformancePackName", conformancePackName())
                .add("ConformancePackRuleEvaluationResults",
                        hasConformancePackRuleEvaluationResults() ? conformancePackRuleEvaluationResults() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ConformancePackRuleEvaluationResults":
            return Optional.ofNullable(clazz.cast(conformancePackRuleEvaluationResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConformancePackComplianceDetailsResponse, T> g) {
        return obj -> g.apply((GetConformancePackComplianceDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConformancePackComplianceDetailsResponse> {
        /**
         * <p>
         * Name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * Returns a list of <code>ConformancePackEvaluationResult</code> objects.
         * </p>
         * 
         * @param conformancePackRuleEvaluationResults
         *        Returns a list of <code>ConformancePackEvaluationResult</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackRuleEvaluationResults(
                Collection<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults);

        /**
         * <p>
         * Returns a list of <code>ConformancePackEvaluationResult</code> objects.
         * </p>
         * 
         * @param conformancePackRuleEvaluationResults
         *        Returns a list of <code>ConformancePackEvaluationResult</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackRuleEvaluationResults(ConformancePackEvaluationResult... conformancePackRuleEvaluationResults);

        /**
         * <p>
         * Returns a list of <code>ConformancePackEvaluationResult</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackEvaluationResult>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackEvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackEvaluationResult>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackRuleEvaluationResults(List<ConformancePackEvaluationResult>)}.
         * 
         * @param conformancePackRuleEvaluationResults
         *        a consumer that will call methods on {@link List<ConformancePackEvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackRuleEvaluationResults(List<ConformancePackEvaluationResult>)
         */
        Builder conformancePackRuleEvaluationResults(
                Consumer<ConformancePackEvaluationResult.Builder>... conformancePackRuleEvaluationResults);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String conformancePackName;

        private List<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConformancePackComplianceDetailsResponse model) {
            super(model);
            conformancePackName(model.conformancePackName);
            conformancePackRuleEvaluationResults(model.conformancePackRuleEvaluationResults);
            nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final List<ConformancePackEvaluationResult.Builder> getConformancePackRuleEvaluationResults() {
            List<ConformancePackEvaluationResult.Builder> result = ConformancePackRuleEvaluationResultsListCopier
                    .copyToBuilder(this.conformancePackRuleEvaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conformancePackRuleEvaluationResults(
                Collection<ConformancePackEvaluationResult> conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults = ConformancePackRuleEvaluationResultsListCopier
                    .copy(conformancePackRuleEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleEvaluationResults(
                ConformancePackEvaluationResult... conformancePackRuleEvaluationResults) {
            conformancePackRuleEvaluationResults(Arrays.asList(conformancePackRuleEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackRuleEvaluationResults(
                Consumer<ConformancePackEvaluationResult.Builder>... conformancePackRuleEvaluationResults) {
            conformancePackRuleEvaluationResults(Stream.of(conformancePackRuleEvaluationResults)
                    .map(c -> ConformancePackEvaluationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackRuleEvaluationResults(
                Collection<ConformancePackEvaluationResult.BuilderImpl> conformancePackRuleEvaluationResults) {
            this.conformancePackRuleEvaluationResults = ConformancePackRuleEvaluationResultsListCopier
                    .copyFromBuilder(conformancePackRuleEvaluationResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConformancePackComplianceDetailsResponse build() {
            return new GetConformancePackComplianceDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
