/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAggregateComplianceByConfigRulesResponse extends ConfigResponse
        implements
        ToCopyableBuilder<DescribeAggregateComplianceByConfigRulesResponse.Builder, DescribeAggregateComplianceByConfigRulesResponse> {
    private static final SdkField<List<AggregateComplianceByConfigRule>> AGGREGATE_COMPLIANCE_BY_CONFIG_RULES_FIELD = SdkField
            .<List<AggregateComplianceByConfigRule>> builder(MarshallingType.LIST)
            .memberName("AggregateComplianceByConfigRules")
            .getter(getter(DescribeAggregateComplianceByConfigRulesResponse::aggregateComplianceByConfigRules))
            .setter(setter(Builder::aggregateComplianceByConfigRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateComplianceByConfigRules")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateComplianceByConfigRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateComplianceByConfigRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAggregateComplianceByConfigRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATE_COMPLIANCE_BY_CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules;

    private final String nextToken;

    private DescribeAggregateComplianceByConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateComplianceByConfigRules = builder.aggregateComplianceByConfigRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AggregateComplianceByConfigRules property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasAggregateComplianceByConfigRules() {
        return aggregateComplianceByConfigRules != null && !(aggregateComplianceByConfigRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of AggregateComplianceByConfigRule object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAggregateComplianceByConfigRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of AggregateComplianceByConfigRule object.
     */
    public final List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules() {
        return aggregateComplianceByConfigRules;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAggregateComplianceByConfigRules() ? aggregateComplianceByConfigRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregateComplianceByConfigRulesResponse)) {
            return false;
        }
        DescribeAggregateComplianceByConfigRulesResponse other = (DescribeAggregateComplianceByConfigRulesResponse) obj;
        return hasAggregateComplianceByConfigRules() == other.hasAggregateComplianceByConfigRules()
                && Objects.equals(aggregateComplianceByConfigRules(), other.aggregateComplianceByConfigRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAggregateComplianceByConfigRulesResponse")
                .add("AggregateComplianceByConfigRules",
                        hasAggregateComplianceByConfigRules() ? aggregateComplianceByConfigRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregateComplianceByConfigRules":
            return Optional.ofNullable(clazz.cast(aggregateComplianceByConfigRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAggregateComplianceByConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeAggregateComplianceByConfigRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAggregateComplianceByConfigRulesResponse> {
        /**
         * <p>
         * Returns a list of AggregateComplianceByConfigRule object.
         * </p>
         * 
         * @param aggregateComplianceByConfigRules
         *        Returns a list of AggregateComplianceByConfigRule object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceByConfigRules(Collection<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules);

        /**
         * <p>
         * Returns a list of AggregateComplianceByConfigRule object.
         * </p>
         * 
         * @param aggregateComplianceByConfigRules
         *        Returns a list of AggregateComplianceByConfigRule object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateComplianceByConfigRules(AggregateComplianceByConfigRule... aggregateComplianceByConfigRules);

        /**
         * <p>
         * Returns a list of AggregateComplianceByConfigRule object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateComplianceByConfigRule>.Builder}
         * avoiding the need to create one manually via {@link List<AggregateComplianceByConfigRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateComplianceByConfigRule>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #aggregateComplianceByConfigRules(List<AggregateComplianceByConfigRule>)}.
         * 
         * @param aggregateComplianceByConfigRules
         *        a consumer that will call methods on {@link List<AggregateComplianceByConfigRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateComplianceByConfigRules(List<AggregateComplianceByConfigRule>)
         */
        Builder aggregateComplianceByConfigRules(
                Consumer<AggregateComplianceByConfigRule.Builder>... aggregateComplianceByConfigRules);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregateComplianceByConfigRulesResponse model) {
            super(model);
            aggregateComplianceByConfigRules(model.aggregateComplianceByConfigRules);
            nextToken(model.nextToken);
        }

        public final List<AggregateComplianceByConfigRule.Builder> getAggregateComplianceByConfigRules() {
            List<AggregateComplianceByConfigRule.Builder> result = AggregateComplianceByConfigRuleListCopier
                    .copyToBuilder(this.aggregateComplianceByConfigRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder aggregateComplianceByConfigRules(
                Collection<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules = AggregateComplianceByConfigRuleListCopier
                    .copy(aggregateComplianceByConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConfigRules(AggregateComplianceByConfigRule... aggregateComplianceByConfigRules) {
            aggregateComplianceByConfigRules(Arrays.asList(aggregateComplianceByConfigRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConfigRules(
                Consumer<AggregateComplianceByConfigRule.Builder>... aggregateComplianceByConfigRules) {
            aggregateComplianceByConfigRules(Stream.of(aggregateComplianceByConfigRules)
                    .map(c -> AggregateComplianceByConfigRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateComplianceByConfigRules(
                Collection<AggregateComplianceByConfigRule.BuilderImpl> aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules = AggregateComplianceByConfigRuleListCopier
                    .copyFromBuilder(aggregateComplianceByConfigRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAggregateComplianceByConfigRulesResponse build() {
            return new DescribeAggregateComplianceByConfigRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
