/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRemediationExecutionResponse extends ConfigResponse implements
        ToCopyableBuilder<StartRemediationExecutionResponse.Builder, StartRemediationExecutionResponse> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(StartRemediationExecutionResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<List<ResourceKey>> FAILED_ITEMS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .memberName("FailedItems")
            .getter(getter(StartRemediationExecutionResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD,
            FAILED_ITEMS_FIELD));

    private final String failureMessage;

    private final List<ResourceKey> failedItems;

    private StartRemediationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Returns a failure message. For example, the resource is already compliant.
     * </p>
     * 
     * @return Returns a failure message. For example, the resource is already compliant.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * Returns true if the FailedItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For resources that have failed to start execution, the API returns a resource key object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For resources that have failed to start execution, the API returns a resource key object.
     */
    public final List<ResourceKey> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedItems() ? failedItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemediationExecutionResponse)) {
            return false;
        }
        StartRemediationExecutionResponse other = (StartRemediationExecutionResponse) obj;
        return Objects.equals(failureMessage(), other.failureMessage()) && hasFailedItems() == other.hasFailedItems()
                && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRemediationExecutionResponse").add("FailureMessage", failureMessage())
                .add("FailedItems", hasFailedItems() ? failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "FailedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRemediationExecutionResponse, T> g) {
        return obj -> g.apply((StartRemediationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartRemediationExecutionResponse> {
        /**
         * <p>
         * Returns a failure message. For example, the resource is already compliant.
         * </p>
         * 
         * @param failureMessage
         *        Returns a failure message. For example, the resource is already compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * For resources that have failed to start execution, the API returns a resource key object.
         * </p>
         * 
         * @param failedItems
         *        For resources that have failed to start execution, the API returns a resource key object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Collection<ResourceKey> failedItems);

        /**
         * <p>
         * For resources that have failed to start execution, the API returns a resource key object.
         * </p>
         * 
         * @param failedItems
         *        For resources that have failed to start execution, the API returns a resource key object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(ResourceKey... failedItems);

        /**
         * <p>
         * For resources that have failed to start execution, the API returns a resource key object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceKey>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #failedItems(List<ResourceKey>)}.
         * 
         * @param failedItems
         *        a consumer that will call methods on {@link List<ResourceKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedItems(List<ResourceKey>)
         */
        Builder failedItems(Consumer<ResourceKey.Builder>... failedItems);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String failureMessage;

        private List<ResourceKey> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemediationExecutionResponse model) {
            super(model);
            failureMessage(model.failureMessage);
            failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final List<ResourceKey.Builder> getFailedItems() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedItems(Collection<ResourceKey> failedItems) {
            this.failedItems = ResourceKeysCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(ResourceKey... failedItems) {
            failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<ResourceKey.Builder>... failedItems) {
            failedItems(Stream.of(failedItems).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedItems(Collection<ResourceKey.BuilderImpl> failedItems) {
            this.failedItems = ResourceKeysCopier.copyFromBuilder(failedItems);
        }

        @Override
        public StartRemediationExecutionResponse build() {
            return new StartRemediationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
