/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateConformancePackComplianceSummaryResponse extends ConfigResponse
        implements
        ToCopyableBuilder<GetAggregateConformancePackComplianceSummaryResponse.Builder, GetAggregateConformancePackComplianceSummaryResponse> {
    private static final SdkField<List<AggregateConformancePackComplianceSummary>> AGGREGATE_CONFORMANCE_PACK_COMPLIANCE_SUMMARIES_FIELD = SdkField
            .<List<AggregateConformancePackComplianceSummary>> builder(MarshallingType.LIST)
            .memberName("AggregateConformancePackComplianceSummaries")
            .getter(getter(GetAggregateConformancePackComplianceSummaryResponse::aggregateConformancePackComplianceSummaries))
            .setter(setter(Builder::aggregateConformancePackComplianceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AggregateConformancePackComplianceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateConformancePackComplianceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateConformancePackComplianceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByKey").getter(getter(GetAggregateConformancePackComplianceSummaryResponse::groupByKey))
            .setter(setter(Builder::groupByKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetAggregateConformancePackComplianceSummaryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATE_CONFORMANCE_PACK_COMPLIANCE_SUMMARIES_FIELD, GROUP_BY_KEY_FIELD, NEXT_TOKEN_FIELD));

    private final List<AggregateConformancePackComplianceSummary> aggregateConformancePackComplianceSummaries;

    private final String groupByKey;

    private final String nextToken;

    private GetAggregateConformancePackComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateConformancePackComplianceSummaries = builder.aggregateConformancePackComplianceSummaries;
        this.groupByKey = builder.groupByKey;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * AggregateConformancePackComplianceSummaries property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAggregateConformancePackComplianceSummaries() {
        return aggregateConformancePackComplianceSummaries != null
                && !(aggregateConformancePackComplianceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasAggregateConformancePackComplianceSummaries} method.
     * </p>
     * 
     * @return Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
     */
    public final List<AggregateConformancePackComplianceSummary> aggregateConformancePackComplianceSummaries() {
        return aggregateConformancePackComplianceSummaries;
    }

    /**
     * <p>
     * Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
     * </p>
     * 
     * @return Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
     */
    public final String groupByKey() {
        return groupByKey;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasAggregateConformancePackComplianceSummaries() ? aggregateConformancePackComplianceSummaries()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(groupByKey());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateConformancePackComplianceSummaryResponse)) {
            return false;
        }
        GetAggregateConformancePackComplianceSummaryResponse other = (GetAggregateConformancePackComplianceSummaryResponse) obj;
        return hasAggregateConformancePackComplianceSummaries() == other.hasAggregateConformancePackComplianceSummaries()
                && Objects.equals(aggregateConformancePackComplianceSummaries(),
                        other.aggregateConformancePackComplianceSummaries()) && Objects.equals(groupByKey(), other.groupByKey())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetAggregateConformancePackComplianceSummaryResponse")
                .add("AggregateConformancePackComplianceSummaries",
                        hasAggregateConformancePackComplianceSummaries() ? aggregateConformancePackComplianceSummaries() : null)
                .add("GroupByKey", groupByKey()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregateConformancePackComplianceSummaries":
            return Optional.ofNullable(clazz.cast(aggregateConformancePackComplianceSummaries()));
        case "GroupByKey":
            return Optional.ofNullable(clazz.cast(groupByKey()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateConformancePackComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetAggregateConformancePackComplianceSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateConformancePackComplianceSummaryResponse> {
        /**
         * <p>
         * Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
         * </p>
         * 
         * @param aggregateConformancePackComplianceSummaries
         *        Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateConformancePackComplianceSummaries(
                Collection<AggregateConformancePackComplianceSummary> aggregateConformancePackComplianceSummaries);

        /**
         * <p>
         * Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
         * </p>
         * 
         * @param aggregateConformancePackComplianceSummaries
         *        Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateConformancePackComplianceSummaries(
                AggregateConformancePackComplianceSummary... aggregateConformancePackComplianceSummaries);

        /**
         * <p>
         * Returns a list of <code>AggregateConformancePackComplianceSummary</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AggregateConformancePackComplianceSummary>.Builder} avoiding the need to create one manually via
         * {@link List<AggregateConformancePackComplianceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateConformancePackComplianceSummary>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #aggregateConformancePackComplianceSummaries(List<AggregateConformancePackComplianceSummary>)}.
         * 
         * @param aggregateConformancePackComplianceSummaries
         *        a consumer that will call methods on {@link List<AggregateConformancePackComplianceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateConformancePackComplianceSummaries(List<AggregateConformancePackComplianceSummary>)
         */
        Builder aggregateConformancePackComplianceSummaries(
                Consumer<AggregateConformancePackComplianceSummary.Builder>... aggregateConformancePackComplianceSummaries);

        /**
         * <p>
         * Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
         * </p>
         * 
         * @param groupByKey
         *        Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKey(String groupByKey);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregateConformancePackComplianceSummary> aggregateConformancePackComplianceSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String groupByKey;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateConformancePackComplianceSummaryResponse model) {
            super(model);
            aggregateConformancePackComplianceSummaries(model.aggregateConformancePackComplianceSummaries);
            groupByKey(model.groupByKey);
            nextToken(model.nextToken);
        }

        public final List<AggregateConformancePackComplianceSummary.Builder> getAggregateConformancePackComplianceSummaries() {
            List<AggregateConformancePackComplianceSummary.Builder> result = AggregateConformancePackComplianceSummaryListCopier
                    .copyToBuilder(this.aggregateConformancePackComplianceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregateConformancePackComplianceSummaries(
                Collection<AggregateConformancePackComplianceSummary.BuilderImpl> aggregateConformancePackComplianceSummaries) {
            this.aggregateConformancePackComplianceSummaries = AggregateConformancePackComplianceSummaryListCopier
                    .copyFromBuilder(aggregateConformancePackComplianceSummaries);
        }

        @Override
        @Transient
        public final Builder aggregateConformancePackComplianceSummaries(
                Collection<AggregateConformancePackComplianceSummary> aggregateConformancePackComplianceSummaries) {
            this.aggregateConformancePackComplianceSummaries = AggregateConformancePackComplianceSummaryListCopier
                    .copy(aggregateConformancePackComplianceSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregateConformancePackComplianceSummaries(
                AggregateConformancePackComplianceSummary... aggregateConformancePackComplianceSummaries) {
            aggregateConformancePackComplianceSummaries(Arrays.asList(aggregateConformancePackComplianceSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregateConformancePackComplianceSummaries(
                Consumer<AggregateConformancePackComplianceSummary.Builder>... aggregateConformancePackComplianceSummaries) {
            aggregateConformancePackComplianceSummaries(Stream.of(aggregateConformancePackComplianceSummaries)
                    .map(c -> AggregateConformancePackComplianceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGroupByKey() {
            return groupByKey;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        @Override
        @Transient
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAggregateConformancePackComplianceSummaryResponse build() {
            return new GetAggregateConformancePackComplianceSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
