/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<SelectResourceConfigResponse.Builder, SelectResourceConfigResponse> {
    private static final SdkField<List<String>> RESULTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SelectResourceConfigResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueryInfo> QUERY_INFO_FIELD = SdkField.<QueryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("QueryInfo").getter(getter(SelectResourceConfigResponse::queryInfo)).setter(setter(Builder::queryInfo))
            .constructor(QueryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInfo").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SelectResourceConfigResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            QUERY_INFO_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> results;

    private final QueryInfo queryInfo;

    private final String nextToken;

    private SelectResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.queryInfo = builder.queryInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the results for the SQL query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the results for the SQL query.
     */
    public final List<String> results() {
        return results;
    }

    /**
     * <p>
     * Returns the <code>QueryInfo</code> object.
     * </p>
     * 
     * @return Returns the <code>QueryInfo</code> object.
     */
    public final QueryInfo queryInfo() {
        return queryInfo;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectResourceConfigResponse)) {
            return false;
        }
        SelectResourceConfigResponse other = (SelectResourceConfigResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(queryInfo(), other.queryInfo()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectResourceConfigResponse").add("Results", hasResults() ? results() : null)
                .add("QueryInfo", queryInfo()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "QueryInfo":
            return Optional.ofNullable(clazz.cast(queryInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectResourceConfigResponse, T> g) {
        return obj -> g.apply((SelectResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, SelectResourceConfigResponse> {
        /**
         * <p>
         * Returns the results for the SQL query.
         * </p>
         * 
         * @param results
         *        Returns the results for the SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<String> results);

        /**
         * <p>
         * Returns the results for the SQL query.
         * </p>
         * 
         * @param results
         *        Returns the results for the SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(String... results);

        /**
         * <p>
         * Returns the <code>QueryInfo</code> object.
         * </p>
         * 
         * @param queryInfo
         *        Returns the <code>QueryInfo</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryInfo(QueryInfo queryInfo);

        /**
         * <p>
         * Returns the <code>QueryInfo</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryInfo.Builder} avoiding the need to create
         * one manually via {@link QueryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #queryInfo(QueryInfo)}.
         * 
         * @param queryInfo
         *        a consumer that will call methods on {@link QueryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryInfo(QueryInfo)
         */
        default Builder queryInfo(Consumer<QueryInfo.Builder> queryInfo) {
            return queryInfo(QueryInfo.builder().applyMutation(queryInfo).build());
        }

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<String> results = DefaultSdkAutoConstructList.getInstance();

        private QueryInfo queryInfo;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectResourceConfigResponse model) {
            super(model);
            results(model.results);
            queryInfo(model.queryInfo);
            nextToken(model.nextToken);
        }

        public final Collection<String> getResults() {
            if (results instanceof SdkAutoConstructList) {
                return null;
            }
            return results;
        }

        public final void setResults(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
        }

        @Override
        @Transient
        public final Builder results(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder results(String... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final QueryInfo.Builder getQueryInfo() {
            return queryInfo != null ? queryInfo.toBuilder() : null;
        }

        public final void setQueryInfo(QueryInfo.BuilderImpl queryInfo) {
            this.queryInfo = queryInfo != null ? queryInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder queryInfo(QueryInfo queryInfo) {
            this.queryInfo = queryInfo;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SelectResourceConfigResponse build() {
            return new SelectResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
