/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAggregationAuthorizationRequest extends ConfigRequest implements
        ToCopyableBuilder<PutAggregationAuthorizationRequest.Builder, PutAggregationAuthorizationRequest> {
    private static final SdkField<String> AUTHORIZED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAccountId").getter(getter(PutAggregationAuthorizationRequest::authorizedAccountId))
            .setter(setter(Builder::authorizedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAccountId").build())
            .build();

    private static final SdkField<String> AUTHORIZED_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAwsRegion").getter(getter(PutAggregationAuthorizationRequest::authorizedAwsRegion))
            .setter(setter(Builder::authorizedAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAwsRegion").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutAggregationAuthorizationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_ACCOUNT_ID_FIELD,
            AUTHORIZED_AWS_REGION_FIELD, TAGS_FIELD));

    private final String authorizedAccountId;

    private final String authorizedAwsRegion;

    private final List<Tag> tags;

    private PutAggregationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The 12-digit account ID of the account authorized to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account authorized to aggregate data.
     */
    public final String authorizedAccountId() {
        return authorizedAccountId;
    }

    /**
     * <p>
     * The region authorized to collect aggregated data.
     * </p>
     * 
     * @return The region authorized to collect aggregated data.
     */
    public final String authorizedAwsRegion() {
        return authorizedAwsRegion;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tag object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of tag object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAwsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAggregationAuthorizationRequest)) {
            return false;
        }
        PutAggregationAuthorizationRequest other = (PutAggregationAuthorizationRequest) obj;
        return Objects.equals(authorizedAccountId(), other.authorizedAccountId())
                && Objects.equals(authorizedAwsRegion(), other.authorizedAwsRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAggregationAuthorizationRequest").add("AuthorizedAccountId", authorizedAccountId())
                .add("AuthorizedAwsRegion", authorizedAwsRegion()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedAccountId":
            return Optional.ofNullable(clazz.cast(authorizedAccountId()));
        case "AuthorizedAwsRegion":
            return Optional.ofNullable(clazz.cast(authorizedAwsRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAggregationAuthorizationRequest, T> g) {
        return obj -> g.apply((PutAggregationAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAggregationAuthorizationRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account authorized to aggregate data.
         * </p>
         * 
         * @param authorizedAccountId
         *        The 12-digit account ID of the account authorized to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAccountId(String authorizedAccountId);

        /**
         * <p>
         * The region authorized to collect aggregated data.
         * </p>
         * 
         * @param authorizedAwsRegion
         *        The region authorized to collect aggregated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAwsRegion(String authorizedAwsRegion);

        /**
         * <p>
         * An array of tag object.
         * </p>
         * 
         * @param tags
         *        An array of tag object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tag object.
         * </p>
         * 
         * @param tags
         *        An array of tag object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tag object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String authorizedAccountId;

        private String authorizedAwsRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAggregationAuthorizationRequest model) {
            super(model);
            authorizedAccountId(model.authorizedAccountId);
            authorizedAwsRegion(model.authorizedAwsRegion);
            tags(model.tags);
        }

        public final String getAuthorizedAccountId() {
            return authorizedAccountId;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        @Override
        @Transient
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final String getAuthorizedAwsRegion() {
            return authorizedAwsRegion;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        @Override
        @Transient
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAggregationAuthorizationRequest build() {
            return new PutAggregationAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
