/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the current status of the invoked remediation action for that resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationExecutionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationExecutionStatus.Builder, RemediationExecutionStatus> {
    private static final SdkField<ResourceKey> RESOURCE_KEY_FIELD = SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceKey").getter(getter(RemediationExecutionStatus::resourceKey))
            .setter(setter(Builder::resourceKey)).constructor(ResourceKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RemediationExecutionStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<RemediationExecutionStep>> STEP_DETAILS_FIELD = SdkField
            .<List<RemediationExecutionStep>> builder(MarshallingType.LIST)
            .memberName("StepDetails")
            .getter(getter(RemediationExecutionStatus::stepDetails))
            .setter(setter(Builder::stepDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationExecutionStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationExecutionStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvocationTime").getter(getter(RemediationExecutionStatus::invocationTime))
            .setter(setter(Builder::invocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(RemediationExecutionStatus::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_KEY_FIELD,
            STATE_FIELD, STEP_DETAILS_FIELD, INVOCATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceKey resourceKey;

    private final String state;

    private final List<RemediationExecutionStep> stepDetails;

    private final Instant invocationTime;

    private final Instant lastUpdatedTime;

    private RemediationExecutionStatus(BuilderImpl builder) {
        this.resourceKey = builder.resourceKey;
        this.state = builder.state;
        this.stepDetails = builder.stepDetails;
        this.invocationTime = builder.invocationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * Returns the value of the ResourceKey property for this object.
     * 
     * @return The value of the ResourceKey property for this object.
     */
    public final ResourceKey resourceKey() {
        return resourceKey;
    }

    /**
     * <p>
     * ENUM of the values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RemediationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return ENUM of the values.
     * @see RemediationExecutionState
     */
    public final RemediationExecutionState state() {
        return RemediationExecutionState.fromValue(state);
    }

    /**
     * <p>
     * ENUM of the values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RemediationExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return ENUM of the values.
     * @see RemediationExecutionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns true if the StepDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStepDetails() {
        return stepDetails != null && !(stepDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of every step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details of every step.
     */
    public final List<RemediationExecutionStep> stepDetails() {
        return stepDetails;
    }

    /**
     * <p>
     * Start time when the remediation was executed.
     * </p>
     * 
     * @return Start time when the remediation was executed.
     */
    public final Instant invocationTime() {
        return invocationTime;
    }

    /**
     * <p>
     * The time when the remediation execution was last updated.
     * </p>
     * 
     * @return The time when the remediation execution was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStepDetails() ? stepDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationExecutionStatus)) {
            return false;
        }
        RemediationExecutionStatus other = (RemediationExecutionStatus) obj;
        return Objects.equals(resourceKey(), other.resourceKey()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasStepDetails() == other.hasStepDetails() && Objects.equals(stepDetails(), other.stepDetails())
                && Objects.equals(invocationTime(), other.invocationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationExecutionStatus").add("ResourceKey", resourceKey()).add("State", stateAsString())
                .add("StepDetails", hasStepDetails() ? stepDetails() : null).add("InvocationTime", invocationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceKey":
            return Optional.ofNullable(clazz.cast(resourceKey()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StepDetails":
            return Optional.ofNullable(clazz.cast(stepDetails()));
        case "InvocationTime":
            return Optional.ofNullable(clazz.cast(invocationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationExecutionStatus, T> g) {
        return obj -> g.apply((RemediationExecutionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationExecutionStatus> {
        /**
         * Sets the value of the ResourceKey property for this object.
         *
         * @param resourceKey
         *        The new value for the ResourceKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKey(ResourceKey resourceKey);

        /**
         * Sets the value of the ResourceKey property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceKey.Builder} avoiding the need to create
         * one manually via {@link ResourceKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceKey.Builder#build()} is called immediately and its result
         * is passed to {@link #resourceKey(ResourceKey)}.
         * 
         * @param resourceKey
         *        a consumer that will call methods on {@link ResourceKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceKey(ResourceKey)
         */
        default Builder resourceKey(Consumer<ResourceKey.Builder> resourceKey) {
            return resourceKey(ResourceKey.builder().applyMutation(resourceKey).build());
        }

        /**
         * <p>
         * ENUM of the values.
         * </p>
         * 
         * @param state
         *        ENUM of the values.
         * @see RemediationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * ENUM of the values.
         * </p>
         * 
         * @param state
         *        ENUM of the values.
         * @see RemediationExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationExecutionState
         */
        Builder state(RemediationExecutionState state);

        /**
         * <p>
         * Details of every step.
         * </p>
         * 
         * @param stepDetails
         *        Details of every step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(Collection<RemediationExecutionStep> stepDetails);

        /**
         * <p>
         * Details of every step.
         * </p>
         * 
         * @param stepDetails
         *        Details of every step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(RemediationExecutionStep... stepDetails);

        /**
         * <p>
         * Details of every step.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationExecutionStep>.Builder} avoiding
         * the need to create one manually via {@link List<RemediationExecutionStep>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationExecutionStep>.Builder#build()} is called
         * immediately and its result is passed to {@link #stepDetails(List<RemediationExecutionStep>)}.
         * 
         * @param stepDetails
         *        a consumer that will call methods on {@link List<RemediationExecutionStep>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepDetails(List<RemediationExecutionStep>)
         */
        Builder stepDetails(Consumer<RemediationExecutionStep.Builder>... stepDetails);

        /**
         * <p>
         * Start time when the remediation was executed.
         * </p>
         * 
         * @param invocationTime
         *        Start time when the remediation was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationTime(Instant invocationTime);

        /**
         * <p>
         * The time when the remediation execution was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the remediation execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private ResourceKey resourceKey;

        private String state;

        private List<RemediationExecutionStep> stepDetails = DefaultSdkAutoConstructList.getInstance();

        private Instant invocationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationExecutionStatus model) {
            resourceKey(model.resourceKey);
            state(model.state);
            stepDetails(model.stepDetails);
            invocationTime(model.invocationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final ResourceKey.Builder getResourceKey() {
            return resourceKey != null ? resourceKey.toBuilder() : null;
        }

        public final void setResourceKey(ResourceKey.BuilderImpl resourceKey) {
            this.resourceKey = resourceKey != null ? resourceKey.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceKey(ResourceKey resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(RemediationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<RemediationExecutionStep.Builder> getStepDetails() {
            List<RemediationExecutionStep.Builder> result = RemediationExecutionStepsCopier.copyToBuilder(this.stepDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepDetails(Collection<RemediationExecutionStep.BuilderImpl> stepDetails) {
            this.stepDetails = RemediationExecutionStepsCopier.copyFromBuilder(stepDetails);
        }

        @Override
        @Transient
        public final Builder stepDetails(Collection<RemediationExecutionStep> stepDetails) {
            this.stepDetails = RemediationExecutionStepsCopier.copy(stepDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepDetails(RemediationExecutionStep... stepDetails) {
            stepDetails(Arrays.asList(stepDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepDetails(Consumer<RemediationExecutionStep.Builder>... stepDetails) {
            stepDetails(Stream.of(stepDetails).map(c -> RemediationExecutionStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getInvocationTime() {
            return invocationTime;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        @Override
        @Transient
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public RemediationExecutionStatus build() {
            return new RemediationExecutionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
