/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConformancePackStatusesResponse extends ConfigResponse
        implements
        ToCopyableBuilder<DescribeOrganizationConformancePackStatusesResponse.Builder, DescribeOrganizationConformancePackStatusesResponse> {
    private static final SdkField<List<OrganizationConformancePackStatus>> ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD = SdkField
            .<List<OrganizationConformancePackStatus>> builder(MarshallingType.LIST)
            .memberName("OrganizationConformancePackStatuses")
            .getter(getter(DescribeOrganizationConformancePackStatusesResponse::organizationConformancePackStatuses))
            .setter(setter(Builder::organizationConformancePackStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationConformancePackStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationConformancePackStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationConformancePackStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationConformancePackStatusesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private final List<OrganizationConformancePackStatus> organizationConformancePackStatuses;

    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackStatuses = builder.organizationConformancePackStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationConformancePackStatuses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOrganizationConformancePackStatuses() {
        return organizationConformancePackStatuses != null
                && !(organizationConformancePackStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OrganizationConformancePackStatus</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationConformancePackStatuses}
     * method.
     * </p>
     * 
     * @return A list of <code>OrganizationConformancePackStatus</code> objects.
     */
    public final List<OrganizationConformancePackStatus> organizationConformancePackStatuses() {
        return organizationConformancePackStatuses;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOrganizationConformancePackStatuses() ? organizationConformancePackStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesResponse other = (DescribeOrganizationConformancePackStatusesResponse) obj;
        return hasOrganizationConformancePackStatuses() == other.hasOrganizationConformancePackStatuses()
                && Objects.equals(organizationConformancePackStatuses(), other.organizationConformancePackStatuses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeOrganizationConformancePackStatusesResponse")
                .add("OrganizationConformancePackStatuses",
                        hasOrganizationConformancePackStatuses() ? organizationConformancePackStatuses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackStatuses":
            return Optional.ofNullable(clazz.cast(organizationConformancePackStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackStatuses
         *        A list of <code>OrganizationConformancePackStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * 
         * @param organizationConformancePackStatuses
         *        A list of <code>OrganizationConformancePackStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackStatuses(OrganizationConformancePackStatus... organizationConformancePackStatuses);

        /**
         * <p>
         * A list of <code>OrganizationConformancePackStatus</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrganizationConformancePackStatus>.Builder}
         * avoiding the need to create one manually via {@link List<OrganizationConformancePackStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationConformancePackStatus>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #organizationConformancePackStatuses(List<OrganizationConformancePackStatus>)}.
         * 
         * @param organizationConformancePackStatuses
         *        a consumer that will call methods on {@link List<OrganizationConformancePackStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConformancePackStatuses(List<OrganizationConformancePackStatus>)
         */
        Builder organizationConformancePackStatuses(
                Consumer<OrganizationConformancePackStatus.Builder>... organizationConformancePackStatuses);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<OrganizationConformancePackStatus> organizationConformancePackStatuses = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesResponse model) {
            super(model);
            organizationConformancePackStatuses(model.organizationConformancePackStatuses);
            nextToken(model.nextToken);
        }

        public final List<OrganizationConformancePackStatus.Builder> getOrganizationConformancePackStatuses() {
            List<OrganizationConformancePackStatus.Builder> result = OrganizationConformancePackStatusesCopier
                    .copyToBuilder(this.organizationConformancePackStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus.BuilderImpl> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier
                    .copyFromBuilder(organizationConformancePackStatuses);
        }

        @Override
        @Transient
        public final Builder organizationConformancePackStatuses(
                Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier
                    .copy(organizationConformancePackStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(
                OrganizationConformancePackStatus... organizationConformancePackStatuses) {
            organizationConformancePackStatuses(Arrays.asList(organizationConformancePackStatuses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(
                Consumer<OrganizationConformancePackStatus.Builder>... organizationConformancePackStatuses) {
            organizationConformancePackStatuses(Stream.of(organizationConformancePackStatuses)
                    .map(c -> OrganizationConformancePackStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesResponse build() {
            return new DescribeOrganizationConformancePackStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
