/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRecordersResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeConfigurationRecordersResponse.Builder, DescribeConfigurationRecordersResponse> {
    private static final SdkField<List<ConfigurationRecorder>> CONFIGURATION_RECORDERS_FIELD = SdkField
            .<List<ConfigurationRecorder>> builder(MarshallingType.LIST)
            .memberName("ConfigurationRecorders")
            .getter(getter(DescribeConfigurationRecordersResponse::configurationRecorders))
            .setter(setter(Builder::configurationRecorders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationRecorder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationRecorder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONFIGURATION_RECORDERS_FIELD));

    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorders = builder.configurationRecorders;
    }

    /**
     * Returns true if the ConfigurationRecorders property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConfigurationRecorders() {
        return configurationRecorders != null && !(configurationRecorders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the descriptions of the specified configuration recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationRecorders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the descriptions of the specified configuration recorders.
     */
    public final List<ConfigurationRecorder> configurationRecorders() {
        return configurationRecorders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationRecorders() ? configurationRecorders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse) obj;
        return hasConfigurationRecorders() == other.hasConfigurationRecorders()
                && Objects.equals(configurationRecorders(), other.configurationRecorders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationRecordersResponse")
                .add("ConfigurationRecorders", hasConfigurationRecorders() ? configurationRecorders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorders":
            return Optional.ofNullable(clazz.cast(configurationRecorders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecordersResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRecordersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(ConfigurationRecorder... configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationRecorder>.Builder} avoiding
         * the need to create one manually via {@link List<ConfigurationRecorder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationRecorder>.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationRecorders(List<ConfigurationRecorder>)}.
         * 
         * @param configurationRecorders
         *        a consumer that will call methods on {@link List<ConfigurationRecorder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecorders(List<ConfigurationRecorder>)
         */
        Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder>... configurationRecorders);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationRecorder> configurationRecorders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            super(model);
            configurationRecorders(model.configurationRecorders);
        }

        public final List<ConfigurationRecorder.Builder> getConfigurationRecorders() {
            List<ConfigurationRecorder.Builder> result = ConfigurationRecorderListCopier
                    .copyToBuilder(this.configurationRecorders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder.BuilderImpl> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copyFromBuilder(configurationRecorders);
        }

        @Override
        @Transient
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder... configurationRecorders) {
            configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder>... configurationRecorders) {
            configurationRecorders(Stream.of(configurationRecorders)
                    .map(c -> ConfigurationRecorder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
