/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compliance information of one or more Config rules within a conformance pack. You can filter using Config rule names
 * and compliance types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackRuleCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackRuleCompliance.Builder, ConformancePackRuleCompliance> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(ConformancePackRuleCompliance::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ConformancePackRuleCompliance::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<List<String>> CONTROLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Controls")
            .getter(getter(ConformancePackRuleCompliance::controls))
            .setter(setter(Builder::controls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Controls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_TYPE_FIELD, CONTROLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String complianceType;

    private final List<String> controls;

    private ConformancePackRuleCompliance(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.complianceType = builder.complianceType;
        this.controls = builder.controls;
    }

    /**
     * <p>
     * Name of the config rule.
     * </p>
     * 
     * @return Name of the config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Compliance of the Config rule.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Compliance of the Config rule.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>INSUFFICIENT_DATA</code>.
     * @see ConformancePackComplianceType
     */
    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Compliance of the Config rule.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Compliance of the Config rule.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>INSUFFICIENT_DATA</code>.
     * @see ConformancePackComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Controls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasControls() {
        return controls != null && !(controls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Controls for the conformance pack. A control is a process to prevent or detect problems while meeting objectives.
     * A control can align with a specific compliance regime or map to internal controls defined by an organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControls} method.
     * </p>
     * 
     * @return Controls for the conformance pack. A control is a process to prevent or detect problems while meeting
     *         objectives. A control can align with a specific compliance regime or map to internal controls defined by
     *         an organization.
     */
    public final List<String> controls() {
        return controls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasControls() ? controls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackRuleCompliance)) {
            return false;
        }
        ConformancePackRuleCompliance other = (ConformancePackRuleCompliance) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && hasControls() == other.hasControls() && Objects.equals(controls(), other.controls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConformancePackRuleCompliance").add("ConfigRuleName", configRuleName())
                .add("ComplianceType", complianceTypeAsString()).add("Controls", hasControls() ? controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "Controls":
            return Optional.ofNullable(clazz.cast(controls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackRuleCompliance, T> g) {
        return obj -> g.apply((ConformancePackRuleCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackRuleCompliance> {
        /**
         * <p>
         * Name of the config rule.
         * </p>
         * 
         * @param configRuleName
         *        Name of the config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Compliance of the Config rule.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceType
         *        Compliance of the Config rule.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Compliance of the Config rule.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceType
         *        Compliance of the Config rule.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);

        /**
         * <p>
         * Controls for the conformance pack. A control is a process to prevent or detect problems while meeting
         * objectives. A control can align with a specific compliance regime or map to internal controls defined by an
         * organization.
         * </p>
         * 
         * @param controls
         *        Controls for the conformance pack. A control is a process to prevent or detect problems while meeting
         *        objectives. A control can align with a specific compliance regime or map to internal controls defined
         *        by an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(Collection<String> controls);

        /**
         * <p>
         * Controls for the conformance pack. A control is a process to prevent or detect problems while meeting
         * objectives. A control can align with a specific compliance regime or map to internal controls defined by an
         * organization.
         * </p>
         * 
         * @param controls
         *        Controls for the conformance pack. A control is a process to prevent or detect problems while meeting
         *        objectives. A control can align with a specific compliance regime or map to internal controls defined
         *        by an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(String... controls);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String complianceType;

        private List<String> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackRuleCompliance model) {
            configRuleName(model.configRuleName);
            complianceType(model.complianceType);
            controls(model.controls);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        @Transient
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final Collection<String> getControls() {
            if (controls instanceof SdkAutoConstructList) {
                return null;
            }
            return controls;
        }

        public final void setControls(Collection<String> controls) {
            this.controls = ControlsListCopier.copy(controls);
        }

        @Override
        @Transient
        public final Builder controls(Collection<String> controls) {
            this.controls = ControlsListCopier.copy(controls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder controls(String... controls) {
            controls(Arrays.asList(controls));
            return this;
        }

        @Override
        public ConformancePackRuleCompliance build() {
            return new ConformancePackRuleCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
