/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConformancePackRequest extends ConfigRequest implements
        ToCopyableBuilder<PutConformancePackRequest.Builder, PutConformancePackRequest> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(PutConformancePackRequest::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> TEMPLATE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateS3Uri").getter(getter(PutConformancePackRequest::templateS3Uri))
            .setter(setter(Builder::templateS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateS3Uri").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(PutConformancePackRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3Bucket").getter(getter(PutConformancePackRequest::deliveryS3Bucket))
            .setter(setter(Builder::deliveryS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()).build();

    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3KeyPrefix").getter(getter(PutConformancePackRequest::deliveryS3KeyPrefix))
            .setter(setter(Builder::deliveryS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build())
            .build();

    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField
            .<List<ConformancePackInputParameter>> builder(MarshallingType.LIST)
            .memberName("ConformancePackInputParameters")
            .getter(getter(PutConformancePackRequest::conformancePackInputParameters))
            .setter(setter(Builder::conformancePackInputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackInputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackInputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            TEMPLATE_S3_URI_FIELD, TEMPLATE_BODY_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD,
            CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD));

    private final String conformancePackName;

    private final String templateS3Uri;

    private final String templateBody;

    private final String deliveryS3Bucket;

    private final String deliveryS3KeyPrefix;

    private final List<ConformancePackInputParameter> conformancePackInputParameters;

    private PutConformancePackRequest(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.templateS3Uri = builder.templateS3Uri;
        this.templateBody = builder.templateBody;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
    }

    /**
     * <p>
     * Name of the conformance pack you want to create.
     * </p>
     * 
     * @return Name of the conformance pack you want to create.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to the
     * conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the
     * conformance pack.
     * </p>
     * <note>
     * <p>
     * You must have access to read Amazon S3 bucket.
     * </p>
     * </note>
     * 
     * @return Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point
     *         to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same
     *         region as the conformance pack. </p> <note>
     *         <p>
     *         You must have access to read Amazon S3 bucket.
     *         </p>
     */
    public final String templateS3Uri() {
        return templateS3Uri;
    }

    /**
     * <p>
     * A string containing full conformance pack template body. Structure containing the template body with a minimum
     * length of 1 byte and a maximum length of 51,200 bytes.
     * </p>
     * <note>
     * <p>
     * You can only use a YAML template with two resource types: config rule (<code>AWS::Config::ConfigRule</code>) and
     * a remediation action (<code>AWS::Config::RemediationConfiguration</code>).
     * </p>
     * </note>
     * 
     * @return A string containing full conformance pack template body. Structure containing the template body with a
     *         minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
     *         <p>
     *         You can only use a YAML template with two resource types: config rule (
     *         <code>AWS::Config::ConfigRule</code>) and a remediation action (
     *         <code>AWS::Config::RemediationConfiguration</code>).
     *         </p>
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where Config stores conformance pack templates.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3Bucket() {
        return deliveryS3Bucket;
    }

    /**
     * <p>
     * The prefix for the Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return The prefix for the Amazon S3 bucket. </p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3KeyPrefix() {
        return deliveryS3KeyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConformancePackInputParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConformancePackInputParameters() {
        return conformancePackInputParameters != null && !(conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackInputParameter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConformancePackInputParameters} method.
     * </p>
     * 
     * @return A list of <code>ConformancePackInputParameter</code> objects.
     */
    public final List<ConformancePackInputParameter> conformancePackInputParameters() {
        return conformancePackInputParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3KeyPrefix());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackInputParameters() ? conformancePackInputParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConformancePackRequest)) {
            return false;
        }
        PutConformancePackRequest other = (PutConformancePackRequest) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(templateS3Uri(), other.templateS3Uri()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(deliveryS3Bucket(), other.deliveryS3Bucket())
                && Objects.equals(deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix())
                && hasConformancePackInputParameters() == other.hasConformancePackInputParameters()
                && Objects.equals(conformancePackInputParameters(), other.conformancePackInputParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutConformancePackRequest")
                .add("ConformancePackName", conformancePackName())
                .add("TemplateS3Uri", templateS3Uri())
                .add("TemplateBody", templateBody())
                .add("DeliveryS3Bucket", deliveryS3Bucket())
                .add("DeliveryS3KeyPrefix", deliveryS3KeyPrefix())
                .add("ConformancePackInputParameters",
                        hasConformancePackInputParameters() ? conformancePackInputParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "TemplateS3Uri":
            return Optional.ofNullable(clazz.cast(templateS3Uri()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "DeliveryS3Bucket":
            return Optional.ofNullable(clazz.cast(deliveryS3Bucket()));
        case "DeliveryS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(deliveryS3KeyPrefix()));
        case "ConformancePackInputParameters":
            return Optional.ofNullable(clazz.cast(conformancePackInputParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConformancePackRequest, T> g) {
        return obj -> g.apply((PutConformancePackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutConformancePackRequest> {
        /**
         * <p>
         * Name of the conformance pack you want to create.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must point to
         * the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as
         * the conformance pack.
         * </p>
         * <note>
         * <p>
         * You must have access to read Amazon S3 bucket.
         * </p>
         * </note>
         * 
         * @param templateS3Uri
         *        Location of file containing the template body (<code>s3://bucketname/prefix</code>). The uri must
         *        point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in
         *        the same region as the conformance pack. </p> <note>
         *        <p>
         *        You must have access to read Amazon S3 bucket.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateS3Uri(String templateS3Uri);

        /**
         * <p>
         * A string containing full conformance pack template body. Structure containing the template body with a
         * minimum length of 1 byte and a maximum length of 51,200 bytes.
         * </p>
         * <note>
         * <p>
         * You can only use a YAML template with two resource types: config rule (<code>AWS::Config::ConfigRule</code>)
         * and a remediation action (<code>AWS::Config::RemediationConfiguration</code>).
         * </p>
         * </note>
         * 
         * @param templateBody
         *        A string containing full conformance pack template body. Structure containing the template body with a
         *        minimum length of 1 byte and a maximum length of 51,200 bytes.</p> <note>
         *        <p>
         *        You can only use a YAML template with two resource types: config rule (
         *        <code>AWS::Config::ConfigRule</code>) and a remediation action (
         *        <code>AWS::Config::RemediationConfiguration</code>).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The name of the Amazon S3 bucket where Config stores conformance pack templates.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3Bucket
         *        The name of the Amazon S3 bucket where Config stores conformance pack templates.</p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3Bucket(String deliveryS3Bucket);

        /**
         * <p>
         * The prefix for the Amazon S3 bucket.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3KeyPrefix
         *        The prefix for the Amazon S3 bucket. </p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackInputParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackInputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackInputParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackInputParameters(List<ConformancePackInputParameter>)}.
         * 
         * @param conformancePackInputParameters
         *        a consumer that will call methods on {@link List<ConformancePackInputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackInputParameters(List<ConformancePackInputParameter>)
         */
        Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String conformancePackName;

        private String templateS3Uri;

        private String templateBody;

        private String deliveryS3Bucket;

        private String deliveryS3KeyPrefix;

        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutConformancePackRequest model) {
            super(model);
            conformancePackName(model.conformancePackName);
            templateS3Uri(model.templateS3Uri);
            templateBody(model.templateBody);
            deliveryS3Bucket(model.deliveryS3Bucket);
            deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            conformancePackInputParameters(model.conformancePackInputParameters);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        @Transient
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getTemplateS3Uri() {
            return templateS3Uri;
        }

        public final void setTemplateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
        }

        @Override
        @Transient
        public final Builder templateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        @Transient
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getDeliveryS3Bucket() {
            return deliveryS3Bucket;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        @Override
        @Transient
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final String getDeliveryS3KeyPrefix() {
            return deliveryS3KeyPrefix;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        @Override
        @Transient
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final List<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            List<ConformancePackInputParameter.Builder> result = ConformancePackInputParametersCopier
                    .copyToBuilder(this.conformancePackInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConformancePackInputParameters(
                Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier
                    .copyFromBuilder(conformancePackInputParameters);
        }

        @Override
        @Transient
        public final Builder conformancePackInputParameters(
                Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters) {
            conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conformancePackInputParameters(
                Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters) {
            conformancePackInputParameters(Stream.of(conformancePackInputParameters)
                    .map(c -> ConformancePackInputParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConformancePackRequest build() {
            return new PutConformancePackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
