/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePendingAggregationRequestsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribePendingAggregationRequestsResponse.Builder, DescribePendingAggregationRequestsResponse> {
    private static final SdkField<List<PendingAggregationRequest>> PENDING_AGGREGATION_REQUESTS_FIELD = SdkField
            .<List<PendingAggregationRequest>> builder(MarshallingType.LIST)
            .memberName("PendingAggregationRequests")
            .getter(getter(DescribePendingAggregationRequestsResponse::pendingAggregationRequests))
            .setter(setter(Builder::pendingAggregationRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingAggregationRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingAggregationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingAggregationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePendingAggregationRequestsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PENDING_AGGREGATION_REQUESTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<PendingAggregationRequest> pendingAggregationRequests;

    private final String nextToken;

    private DescribePendingAggregationRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingAggregationRequests = builder.pendingAggregationRequests;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingAggregationRequests property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPendingAggregationRequests() {
        return pendingAggregationRequests != null && !(pendingAggregationRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a PendingAggregationRequests object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingAggregationRequests} method.
     * </p>
     * 
     * @return Returns a PendingAggregationRequests object.
     */
    public final List<PendingAggregationRequest> pendingAggregationRequests() {
        return pendingAggregationRequests;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingAggregationRequests() ? pendingAggregationRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingAggregationRequestsResponse)) {
            return false;
        }
        DescribePendingAggregationRequestsResponse other = (DescribePendingAggregationRequestsResponse) obj;
        return hasPendingAggregationRequests() == other.hasPendingAggregationRequests()
                && Objects.equals(pendingAggregationRequests(), other.pendingAggregationRequests())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePendingAggregationRequestsResponse")
                .add("PendingAggregationRequests", hasPendingAggregationRequests() ? pendingAggregationRequests() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingAggregationRequests":
            return Optional.ofNullable(clazz.cast(pendingAggregationRequests()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePendingAggregationRequestsResponse, T> g) {
        return obj -> g.apply((DescribePendingAggregationRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePendingAggregationRequestsResponse> {
        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * 
         * @param pendingAggregationRequests
         *        Returns a PendingAggregationRequests object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingAggregationRequests(Collection<PendingAggregationRequest> pendingAggregationRequests);

        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * 
         * @param pendingAggregationRequests
         *        Returns a PendingAggregationRequests object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingAggregationRequests(PendingAggregationRequest... pendingAggregationRequests);

        /**
         * <p>
         * Returns a PendingAggregationRequests object.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PendingAggregationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<PendingAggregationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingAggregationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingAggregationRequests(List<PendingAggregationRequest>)}.
         * 
         * @param pendingAggregationRequests
         *        a consumer that will call methods on {@link List<PendingAggregationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingAggregationRequests(List<PendingAggregationRequest>)
         */
        Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder>... pendingAggregationRequests);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<PendingAggregationRequest> pendingAggregationRequests = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingAggregationRequestsResponse model) {
            super(model);
            pendingAggregationRequests(model.pendingAggregationRequests);
            nextToken(model.nextToken);
        }

        public final List<PendingAggregationRequest.Builder> getPendingAggregationRequests() {
            List<PendingAggregationRequest.Builder> result = PendingAggregationRequestListCopier
                    .copyToBuilder(this.pendingAggregationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingAggregationRequests(
                Collection<PendingAggregationRequest.BuilderImpl> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copyFromBuilder(pendingAggregationRequests);
        }

        @Override
        @Transient
        public final Builder pendingAggregationRequests(Collection<PendingAggregationRequest> pendingAggregationRequests) {
            this.pendingAggregationRequests = PendingAggregationRequestListCopier.copy(pendingAggregationRequests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pendingAggregationRequests(PendingAggregationRequest... pendingAggregationRequests) {
            pendingAggregationRequests(Arrays.asList(pendingAggregationRequests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pendingAggregationRequests(Consumer<PendingAggregationRequest.Builder>... pendingAggregationRequests) {
            pendingAggregationRequests(Stream.of(pendingAggregationRequests)
                    .map(c -> PendingAggregationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePendingAggregationRequestsResponse build() {
            return new DescribePendingAggregationRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
