/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStoredQueryResponse extends ConfigResponse implements
        ToCopyableBuilder<GetStoredQueryResponse.Builder, GetStoredQueryResponse> {
    private static final SdkField<StoredQuery> STORED_QUERY_FIELD = SdkField.<StoredQuery> builder(MarshallingType.SDK_POJO)
            .memberName("StoredQuery").getter(getter(GetStoredQueryResponse::storedQuery)).setter(setter(Builder::storedQuery))
            .constructor(StoredQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORED_QUERY_FIELD));

    private final StoredQuery storedQuery;

    private GetStoredQueryResponse(BuilderImpl builder) {
        super(builder);
        this.storedQuery = builder.storedQuery;
    }

    /**
     * <p>
     * Returns a <code>StoredQuery</code> object.
     * </p>
     * 
     * @return Returns a <code>StoredQuery</code> object.
     */
    public final StoredQuery storedQuery() {
        return storedQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storedQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStoredQueryResponse)) {
            return false;
        }
        GetStoredQueryResponse other = (GetStoredQueryResponse) obj;
        return Objects.equals(storedQuery(), other.storedQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStoredQueryResponse").add("StoredQuery", storedQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoredQuery":
            return Optional.ofNullable(clazz.cast(storedQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStoredQueryResponse, T> g) {
        return obj -> g.apply((GetStoredQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStoredQueryResponse> {
        /**
         * <p>
         * Returns a <code>StoredQuery</code> object.
         * </p>
         * 
         * @param storedQuery
         *        Returns a <code>StoredQuery</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedQuery(StoredQuery storedQuery);

        /**
         * <p>
         * Returns a <code>StoredQuery</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoredQuery.Builder} avoiding the need to
         * create one manually via {@link StoredQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link StoredQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #storedQuery(StoredQuery)}.
         * 
         * @param storedQuery
         *        a consumer that will call methods on {@link StoredQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storedQuery(StoredQuery)
         */
        default Builder storedQuery(Consumer<StoredQuery.Builder> storedQuery) {
            return storedQuery(StoredQuery.builder().applyMutation(storedQuery).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private StoredQuery storedQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStoredQueryResponse model) {
            super(model);
            storedQuery(model.storedQuery);
        }

        public final StoredQuery.Builder getStoredQuery() {
            return storedQuery != null ? storedQuery.toBuilder() : null;
        }

        public final void setStoredQuery(StoredQuery.BuilderImpl storedQuery) {
            this.storedQuery = storedQuery != null ? storedQuery.build() : null;
        }

        @Override
        @Transient
        public final Builder storedQuery(StoredQuery storedQuery) {
            this.storedQuery = storedQuery;
            return this;
        }

        @Override
        public GetStoredQueryResponse build() {
            return new GetStoredQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
