/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEvaluationsRequest extends ConfigRequest implements
        ToCopyableBuilder<PutEvaluationsRequest.Builder, PutEvaluationsRequest> {
    private static final SdkField<List<Evaluation>> EVALUATIONS_FIELD = SdkField
            .<List<Evaluation>> builder(MarshallingType.LIST)
            .memberName("Evaluations")
            .getter(getter(PutEvaluationsRequest::evaluations))
            .setter(setter(Builder::evaluations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Evaluation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Evaluation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESULT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultToken").getter(getter(PutEvaluationsRequest::resultToken)).setter(setter(Builder::resultToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultToken").build()).build();

    private static final SdkField<Boolean> TEST_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TestMode").getter(getter(PutEvaluationsRequest::testMode)).setter(setter(Builder::testMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATIONS_FIELD,
            RESULT_TOKEN_FIELD, TEST_MODE_FIELD));

    private final List<Evaluation> evaluations;

    private final String resultToken;

    private final Boolean testMode;

    private PutEvaluationsRequest(BuilderImpl builder) {
        super(builder);
        this.evaluations = builder.evaluations;
        this.resultToken = builder.resultToken;
        this.testMode = builder.testMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Evaluations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluations() {
        return evaluations != null && !(evaluations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource and
     * indicates whether it complies with the Config rule that invokes the Lambda function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluations} method.
     * </p>
     * 
     * @return The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services
     *         resource and indicates whether it complies with the Config rule that invokes the Lambda function.
     */
    public final List<Evaluation> evaluations() {
        return evaluations;
    }

    /**
     * <p>
     * An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that
     * triggered the evaluation.
     * </p>
     * 
     * @return An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event
     *         that triggered the evaluation.
     */
    public final String resultToken() {
        return resultToken;
    }

    /**
     * <p>
     * Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda
     * function will deliver evaluation results to Config. No updates occur to your existing evaluations, and evaluation
     * results are not sent to Config.
     * </p>
     * <note>
     * <p>
     * When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value for
     * the <code>ResultToken</code> parameter, but the value cannot be null.
     * </p>
     * </note>
     * 
     * @return Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your
     *         Lambda function will deliver evaluation results to Config. No updates occur to your existing evaluations,
     *         and evaluation results are not sent to Config.</p> <note>
     *         <p>
     *         When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid
     *         value for the <code>ResultToken</code> parameter, but the value cannot be null.
     *         </p>
     */
    public final Boolean testMode() {
        return testMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluations() ? evaluations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resultToken());
        hashCode = 31 * hashCode + Objects.hashCode(testMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsRequest)) {
            return false;
        }
        PutEvaluationsRequest other = (PutEvaluationsRequest) obj;
        return hasEvaluations() == other.hasEvaluations() && Objects.equals(evaluations(), other.evaluations())
                && Objects.equals(resultToken(), other.resultToken()) && Objects.equals(testMode(), other.testMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEvaluationsRequest").add("Evaluations", hasEvaluations() ? evaluations() : null)
                .add("ResultToken", resultToken()).add("TestMode", testMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluations":
            return Optional.ofNullable(clazz.cast(evaluations()));
        case "ResultToken":
            return Optional.ofNullable(clazz.cast(resultToken()));
        case "TestMode":
            return Optional.ofNullable(clazz.cast(testMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEvaluationsRequest, T> g) {
        return obj -> g.apply((PutEvaluationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEvaluationsRequest> {
        /**
         * <p>
         * The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource
         * and indicates whether it complies with the Config rule that invokes the Lambda function.
         * </p>
         * 
         * @param evaluations
         *        The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services
         *        resource and indicates whether it complies with the Config rule that invokes the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(Collection<Evaluation> evaluations);

        /**
         * <p>
         * The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource
         * and indicates whether it complies with the Config rule that invokes the Lambda function.
         * </p>
         * 
         * @param evaluations
         *        The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services
         *        resource and indicates whether it complies with the Config rule that invokes the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluations(Evaluation... evaluations);

        /**
         * <p>
         * The assessments that the Lambda function performs. Each evaluation identifies an Amazon Web Services resource
         * and indicates whether it complies with the Config rule that invokes the Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Evaluation>.Builder} avoiding the
         * need to create one manually via {@link List<Evaluation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Evaluation>.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluations(List<Evaluation>)}.
         * 
         * @param evaluations
         *        a consumer that will call methods on {@link List<Evaluation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluations(List<Evaluation>)
         */
        Builder evaluations(Consumer<Evaluation.Builder>... evaluations);

        /**
         * <p>
         * An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the event that
         * triggered the evaluation.
         * </p>
         * 
         * @param resultToken
         *        An encrypted token that associates an evaluation with an Config rule. Identifies the rule and the
         *        event that triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultToken(String resultToken);

        /**
         * <p>
         * Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your Lambda
         * function will deliver evaluation results to Config. No updates occur to your existing evaluations, and
         * evaluation results are not sent to Config.
         * </p>
         * <note>
         * <p>
         * When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid value
         * for the <code>ResultToken</code> parameter, but the value cannot be null.
         * </p>
         * </note>
         * 
         * @param testMode
         *        Use this parameter to specify a test run for <code>PutEvaluations</code>. You can verify whether your
         *        Lambda function will deliver evaluation results to Config. No updates occur to your existing
         *        evaluations, and evaluation results are not sent to Config.</p> <note>
         *        <p>
         *        When <code>TestMode</code> is <code>true</code>, <code>PutEvaluations</code> doesn't require a valid
         *        value for the <code>ResultToken</code> parameter, but the value cannot be null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testMode(Boolean testMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<Evaluation> evaluations = DefaultSdkAutoConstructList.getInstance();

        private String resultToken;

        private Boolean testMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsRequest model) {
            super(model);
            evaluations(model.evaluations);
            resultToken(model.resultToken);
            testMode(model.testMode);
        }

        public final List<Evaluation.Builder> getEvaluations() {
            List<Evaluation.Builder> result = EvaluationsCopier.copyToBuilder(this.evaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluations(Collection<Evaluation.BuilderImpl> evaluations) {
            this.evaluations = EvaluationsCopier.copyFromBuilder(evaluations);
        }

        @Override
        @Transient
        public final Builder evaluations(Collection<Evaluation> evaluations) {
            this.evaluations = EvaluationsCopier.copy(evaluations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluations(Evaluation... evaluations) {
            evaluations(Arrays.asList(evaluations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluations(Consumer<Evaluation.Builder>... evaluations) {
            evaluations(Stream.of(evaluations).map(c -> Evaluation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResultToken() {
            return resultToken;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        @Override
        @Transient
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final Boolean getTestMode() {
            return testMode;
        }

        public final void setTestMode(Boolean testMode) {
            this.testMode = testMode;
        }

        @Override
        @Transient
        public final Builder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEvaluationsRequest build() {
            return new PutEvaluationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
