/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregate compliance of the conformance pack. Indicates whether a conformance pack is compliant based on the
 * name of the conformance pack, account ID, and region.
 * </p>
 * <p>
 * A conformance pack is compliant if all of the rules in a conformance packs are compliant. It is noncompliant if any
 * of the rules are not compliant. The compliance status of a conformance pack is INSUFFICIENT_DATA only if all rules
 * within a conformance pack cannot be evaluated due to insufficient data. If some of the rules in a conformance pack
 * are compliant but the compliance status of other rules in that same conformance pack is INSUFFICIENT_DATA, the
 * conformance pack shows compliant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateComplianceByConformancePack implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateComplianceByConformancePack.Builder, AggregateComplianceByConformancePack> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(AggregateComplianceByConformancePack::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<AggregateConformancePackCompliance> COMPLIANCE_FIELD = SdkField
            .<AggregateConformancePackCompliance> builder(MarshallingType.SDK_POJO).memberName("Compliance")
            .getter(getter(AggregateComplianceByConformancePack::compliance)).setter(setter(Builder::compliance))
            .constructor(AggregateConformancePackCompliance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AggregateComplianceByConformancePack::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(AggregateComplianceByConformancePack::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            COMPLIANCE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conformancePackName;

    private final AggregateConformancePackCompliance compliance;

    private final String accountId;

    private final String awsRegion;

    private AggregateComplianceByConformancePack(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.compliance = builder.compliance;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * The name of the conformance pack.
     * </p>
     * 
     * @return The name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * The compliance status of the conformance pack.
     * </p>
     * 
     * @return The compliance status of the conformance pack.
     */
    public final AggregateConformancePackCompliance compliance() {
        return compliance;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account ID of the source account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     * 
     * @return The source Amazon Web Services Region from where the data is aggregated.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceByConformancePack)) {
            return false;
        }
        AggregateComplianceByConformancePack other = (AggregateComplianceByConformancePack) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(compliance(), other.compliance()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(awsRegion(), other.awsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateComplianceByConformancePack").add("ConformancePackName", conformancePackName())
                .add("Compliance", compliance()).add("AccountId", accountId()).add("AwsRegion", awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateComplianceByConformancePack, T> g) {
        return obj -> g.apply((AggregateComplianceByConformancePack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateComplianceByConformancePack> {
        /**
         * <p>
         * The name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        The name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * 
         * @param compliance
         *        The compliance status of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(AggregateConformancePackCompliance compliance);

        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AggregateConformancePackCompliance.Builder} avoiding the need to create one manually via
         * {@link AggregateConformancePackCompliance#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregateConformancePackCompliance.Builder#build()} is called
         * immediately and its result is passed to {@link #compliance(AggregateConformancePackCompliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link AggregateConformancePackCompliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(AggregateConformancePackCompliance)
         */
        default Builder compliance(Consumer<AggregateConformancePackCompliance.Builder> compliance) {
            return compliance(AggregateConformancePackCompliance.builder().applyMutation(compliance).build());
        }

        /**
         * <p>
         * The 12-digit Amazon Web Services account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit Amazon Web Services account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source Amazon Web Services Region from where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source Amazon Web Services Region from where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String conformancePackName;

        private AggregateConformancePackCompliance compliance;

        private String accountId;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceByConformancePack model) {
            conformancePackName(model.conformancePackName);
            compliance(model.compliance);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final AggregateConformancePackCompliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        public final void setCompliance(AggregateConformancePackCompliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(AggregateConformancePackCompliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public AggregateComplianceByConformancePack build() {
            return new AggregateComplianceByConformancePack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
