/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates one of the following errors:
 * </p>
 * <ul>
 * <li>
 * <p>
 * For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions to perform
 * the config:Put* action.
 * </p>
 * </li>
 * <li>
 * <p>
 * For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the function's
 * permissions.
 * </p>
 * </li>
 * <li>
 * <p>
 * For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have permissions to call
 * IAM <code>GetRole</code> action or create a service linked role.
 * </p>
 * </li>
 * <li>
 * <p>
 * For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because you do not
 * have permissions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * To call IAM <code>GetRole</code> action or create a service linked role.
 * </p>
 * </li>
 * <li>
 * <p>
 * To read Amazon S3 bucket.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsufficientPermissionsException extends ConfigException implements
        ToCopyableBuilder<InsufficientPermissionsException.Builder, InsufficientPermissionsException> {
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList());

    private static final long serialVersionUID = 1L;

    private InsufficientPermissionsException(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsufficientPermissionsException>, ConfigException.Builder {
        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ConfigException.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(InsufficientPermissionsException model) {
            super(model);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InsufficientPermissionsException build() {
            return new InsufficientPermissionsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
