/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourceConfigRequest extends ConfigRequest implements
        ToCopyableBuilder<PutResourceConfigRequest.Builder, PutResourceConfigRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(PutResourceConfigRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(PutResourceConfigRequest::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(PutResourceConfigRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(PutResourceConfigRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Configuration").getter(getter(PutResourceConfigRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PutResourceConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SCHEMA_VERSION_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, CONFIGURATION_FIELD, TAGS_FIELD));

    private final String resourceType;

    private final String schemaVersionId;

    private final String resourceId;

    private final String resourceName;

    private final String configuration;

    private final Map<String, String> tags;

    private PutResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.schemaVersionId = builder.schemaVersionId;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The type of the resource. The custom resource type must be registered with CloudFormation.
     * </p>
     * <note>
     * <p>
     * You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the
     * first part of the ResourceType up to the first ::.
     * </p>
     * </note>
     * 
     * @return The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
     *         <p>
     *         You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It
     *         is the first part of the ResourceType up to the first ::.
     *         </p>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Version of the schema registered for the ResourceType in CloudFormation.
     * </p>
     * 
     * @return Version of the schema registered for the ResourceType in CloudFormation.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * Unique identifier of the resource.
     * </p>
     * 
     * @return Unique identifier of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Name of the resource.
     * </p>
     * 
     * @return Name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The configuration object of the resource in valid JSON format. It must match the schema registered with
     * CloudFormation.
     * </p>
     * <note>
     * <p>
     * The configuration JSON must not exceed 64 KB.
     * </p>
     * </note>
     * 
     * @return The configuration object of the resource in valid JSON format. It must match the schema registered with
     *         CloudFormation.</p> <note>
     *         <p>
     *         The configuration JSON must not exceed 64 KB.
     *         </p>
     */
    public final String configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags associated with the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceConfigRequest)) {
            return false;
        }
        PutResourceConfigRequest other = (PutResourceConfigRequest) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(schemaVersionId(), other.schemaVersionId())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(configuration(), other.configuration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourceConfigRequest").add("ResourceType", resourceType())
                .add("SchemaVersionId", schemaVersionId()).add("ResourceId", resourceId()).add("ResourceName", resourceName())
                .add("Configuration", configuration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourceConfigRequest, T> g) {
        return obj -> g.apply((PutResourceConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourceConfigRequest> {
        /**
         * <p>
         * The type of the resource. The custom resource type must be registered with CloudFormation.
         * </p>
         * <note>
         * <p>
         * You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is
         * the first part of the ResourceType up to the first ::.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        The type of the resource. The custom resource type must be registered with CloudFormation. </p> <note>
         *        <p>
         *        You cannot use the organization names “amzn”, “amazon”, “alexa”, “custom” with custom resource types.
         *        It is the first part of the ResourceType up to the first ::.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Version of the schema registered for the ResourceType in CloudFormation.
         * </p>
         * 
         * @param schemaVersionId
         *        Version of the schema registered for the ResourceType in CloudFormation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * Unique identifier of the resource.
         * </p>
         * 
         * @param resourceId
         *        Unique identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Name of the resource.
         * </p>
         * 
         * @param resourceName
         *        Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The configuration object of the resource in valid JSON format. It must match the schema registered with
         * CloudFormation.
         * </p>
         * <note>
         * <p>
         * The configuration JSON must not exceed 64 KB.
         * </p>
         * </note>
         * 
         * @param configuration
         *        The configuration object of the resource in valid JSON format. It must match the schema registered
         *        with CloudFormation.</p> <note>
         *        <p>
         *        The configuration JSON must not exceed 64 KB.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * Tags associated with the resource.
         * </p>
         * 
         * @param tags
         *        Tags associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String schemaVersionId;

        private String resourceId;

        private String resourceName;

        private String configuration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourceConfigRequest model) {
            super(model);
            resourceType(model.resourceType);
            schemaVersionId(model.schemaVersionId);
            resourceId(model.resourceId);
            resourceName(model.resourceName);
            configuration(model.configuration);
            tags(model.tags);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourceConfigRequest build() {
            return new PutResourceConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
