/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns details of a conformance pack. A conformance pack is a collection of AWS Config rules and remediation actions
 * that can be easily deployed in an account and a region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackDetail.Builder, ConformancePackDetail> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(ConformancePackDetail::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> CONFORMANCE_PACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackArn").getter(getter(ConformancePackDetail::conformancePackArn))
            .setter(setter(Builder::conformancePackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackArn").build())
            .build();

    private static final SdkField<String> CONFORMANCE_PACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackId").getter(getter(ConformancePackDetail::conformancePackId))
            .setter(setter(Builder::conformancePackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackId").build()).build();

    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3Bucket").getter(getter(ConformancePackDetail::deliveryS3Bucket))
            .setter(setter(Builder::deliveryS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()).build();

    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3KeyPrefix").getter(getter(ConformancePackDetail::deliveryS3KeyPrefix))
            .setter(setter(Builder::deliveryS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build())
            .build();

    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField
            .<List<ConformancePackInputParameter>> builder(MarshallingType.LIST)
            .memberName("ConformancePackInputParameters")
            .getter(getter(ConformancePackDetail::conformancePackInputParameters))
            .setter(setter(Builder::conformancePackInputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackInputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackInputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_REQUESTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateRequestedTime").getter(getter(ConformancePackDetail::lastUpdateRequestedTime))
            .setter(setter(Builder::lastUpdateRequestedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateRequestedTime").build())
            .build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(ConformancePackDetail::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            CONFORMANCE_PACK_ARN_FIELD, CONFORMANCE_PACK_ID_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD,
            CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, LAST_UPDATE_REQUESTED_TIME_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conformancePackName;

    private final String conformancePackArn;

    private final String conformancePackId;

    private final String deliveryS3Bucket;

    private final String deliveryS3KeyPrefix;

    private final List<ConformancePackInputParameter> conformancePackInputParameters;

    private final Instant lastUpdateRequestedTime;

    private final String createdBy;

    private ConformancePackDetail(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackArn = builder.conformancePackArn;
        this.conformancePackId = builder.conformancePackId;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.lastUpdateRequestedTime = builder.lastUpdateRequestedTime;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * Name of the conformance pack.
     * </p>
     * 
     * @return Name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the conformance pack.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the conformance pack.
     */
    public final String conformancePackArn() {
        return conformancePackArn;
    }

    /**
     * <p>
     * ID of the conformance pack.
     * </p>
     * 
     * @return ID of the conformance pack.
     */
    public final String conformancePackId() {
        return conformancePackId;
    }

    /**
     * <p>
     * Amazon S3 bucket where AWS Config stores conformance pack templates.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return Amazon S3 bucket where AWS Config stores conformance pack templates. </p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3Bucket() {
        return deliveryS3Bucket;
    }

    /**
     * <p>
     * The prefix for the Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return The prefix for the Amazon S3 bucket.</p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3KeyPrefix() {
        return deliveryS3KeyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConformancePackInputParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConformancePackInputParameters() {
        return conformancePackInputParameters != null && !(conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackInputParameter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConformancePackInputParameters} method.
     * </p>
     * 
     * @return A list of <code>ConformancePackInputParameter</code> objects.
     */
    public final List<ConformancePackInputParameter> conformancePackInputParameters() {
        return conformancePackInputParameters;
    }

    /**
     * <p>
     * Last time when conformation pack update was requested.
     * </p>
     * 
     * @return Last time when conformation pack update was requested.
     */
    public final Instant lastUpdateRequestedTime() {
        return lastUpdateRequestedTime;
    }

    /**
     * <p>
     * AWS service that created the conformance pack.
     * </p>
     * 
     * @return AWS service that created the conformance pack.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackId());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3KeyPrefix());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackInputParameters() ? conformancePackInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateRequestedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackDetail)) {
            return false;
        }
        ConformancePackDetail other = (ConformancePackDetail) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(conformancePackArn(), other.conformancePackArn())
                && Objects.equals(conformancePackId(), other.conformancePackId())
                && Objects.equals(deliveryS3Bucket(), other.deliveryS3Bucket())
                && Objects.equals(deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix())
                && hasConformancePackInputParameters() == other.hasConformancePackInputParameters()
                && Objects.equals(conformancePackInputParameters(), other.conformancePackInputParameters())
                && Objects.equals(lastUpdateRequestedTime(), other.lastUpdateRequestedTime())
                && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConformancePackDetail")
                .add("ConformancePackName", conformancePackName())
                .add("ConformancePackArn", conformancePackArn())
                .add("ConformancePackId", conformancePackId())
                .add("DeliveryS3Bucket", deliveryS3Bucket())
                .add("DeliveryS3KeyPrefix", deliveryS3KeyPrefix())
                .add("ConformancePackInputParameters",
                        hasConformancePackInputParameters() ? conformancePackInputParameters() : null)
                .add("LastUpdateRequestedTime", lastUpdateRequestedTime()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ConformancePackArn":
            return Optional.ofNullable(clazz.cast(conformancePackArn()));
        case "ConformancePackId":
            return Optional.ofNullable(clazz.cast(conformancePackId()));
        case "DeliveryS3Bucket":
            return Optional.ofNullable(clazz.cast(deliveryS3Bucket()));
        case "DeliveryS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(deliveryS3KeyPrefix()));
        case "ConformancePackInputParameters":
            return Optional.ofNullable(clazz.cast(conformancePackInputParameters()));
        case "LastUpdateRequestedTime":
            return Optional.ofNullable(clazz.cast(lastUpdateRequestedTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackDetail, T> g) {
        return obj -> g.apply((ConformancePackDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackDetail> {
        /**
         * <p>
         * Name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the conformance pack.
         * </p>
         * 
         * @param conformancePackArn
         *        Amazon Resource Name (ARN) of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackArn(String conformancePackArn);

        /**
         * <p>
         * ID of the conformance pack.
         * </p>
         * 
         * @param conformancePackId
         *        ID of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackId(String conformancePackId);

        /**
         * <p>
         * Amazon S3 bucket where AWS Config stores conformance pack templates.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3Bucket
         *        Amazon S3 bucket where AWS Config stores conformance pack templates. </p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3Bucket(String deliveryS3Bucket);

        /**
         * <p>
         * The prefix for the Amazon S3 bucket.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3KeyPrefix
         *        The prefix for the Amazon S3 bucket.</p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackInputParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackInputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackInputParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackInputParameters(List<ConformancePackInputParameter>)}.
         * 
         * @param conformancePackInputParameters
         *        a consumer that will call methods on {@link List<ConformancePackInputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackInputParameters(List<ConformancePackInputParameter>)
         */
        Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters);

        /**
         * <p>
         * Last time when conformation pack update was requested.
         * </p>
         * 
         * @param lastUpdateRequestedTime
         *        Last time when conformation pack update was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime);

        /**
         * <p>
         * AWS service that created the conformance pack.
         * </p>
         * 
         * @param createdBy
         *        AWS service that created the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String conformancePackName;

        private String conformancePackArn;

        private String conformancePackId;

        private String deliveryS3Bucket;

        private String deliveryS3KeyPrefix;

        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateRequestedTime;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackDetail model) {
            conformancePackName(model.conformancePackName);
            conformancePackArn(model.conformancePackArn);
            conformancePackId(model.conformancePackId);
            deliveryS3Bucket(model.deliveryS3Bucket);
            deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            conformancePackInputParameters(model.conformancePackInputParameters);
            lastUpdateRequestedTime(model.lastUpdateRequestedTime);
            createdBy(model.createdBy);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        @Transient
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getConformancePackArn() {
            return conformancePackArn;
        }

        public final void setConformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
        }

        @Override
        @Transient
        public final Builder conformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
            return this;
        }

        public final String getConformancePackId() {
            return conformancePackId;
        }

        public final void setConformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
        }

        @Override
        @Transient
        public final Builder conformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
            return this;
        }

        public final String getDeliveryS3Bucket() {
            return deliveryS3Bucket;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        @Override
        @Transient
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final String getDeliveryS3KeyPrefix() {
            return deliveryS3KeyPrefix;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        @Override
        @Transient
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final List<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            List<ConformancePackInputParameter.Builder> result = ConformancePackInputParametersCopier
                    .copyToBuilder(this.conformancePackInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConformancePackInputParameters(
                Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier
                    .copyFromBuilder(conformancePackInputParameters);
        }

        @Override
        @Transient
        public final Builder conformancePackInputParameters(
                Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters) {
            conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conformancePackInputParameters(
                Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters) {
            conformancePackInputParameters(Stream.of(conformancePackInputParameters)
                    .map(c -> ConformancePackInputParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdateRequestedTime() {
            return lastUpdateRequestedTime;
        }

        public final void setLastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public ConformancePackDetail build() {
            return new ConformancePackDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
