/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutOrganizationConformancePackRequest extends ConfigRequest implements
        ToCopyableBuilder<PutOrganizationConformancePackRequest.Builder, PutOrganizationConformancePackRequest> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConformancePackName")
            .getter(getter(PutOrganizationConformancePackRequest::organizationConformancePackName))
            .setter(setter(Builder::organizationConformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName")
                    .build()).build();

    private static final SdkField<String> TEMPLATE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateS3Uri").getter(getter(PutOrganizationConformancePackRequest::templateS3Uri))
            .setter(setter(Builder::templateS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateS3Uri").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(PutOrganizationConformancePackRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3Bucket").getter(getter(PutOrganizationConformancePackRequest::deliveryS3Bucket))
            .setter(setter(Builder::deliveryS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()).build();

    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryS3KeyPrefix").getter(getter(PutOrganizationConformancePackRequest::deliveryS3KeyPrefix))
            .setter(setter(Builder::deliveryS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build())
            .build();

    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField
            .<List<ConformancePackInputParameter>> builder(MarshallingType.LIST)
            .memberName("ConformancePackInputParameters")
            .getter(getter(PutOrganizationConformancePackRequest::conformancePackInputParameters))
            .setter(setter(Builder::conformancePackInputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackInputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackInputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedAccounts")
            .getter(getter(PutOrganizationConformancePackRequest::excludedAccounts))
            .setter(setter(Builder::excludedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, TEMPLATE_S3_URI_FIELD, TEMPLATE_BODY_FIELD, DELIVERY_S3_BUCKET_FIELD,
            DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, EXCLUDED_ACCOUNTS_FIELD));

    private final String organizationConformancePackName;

    private final String templateS3Uri;

    private final String templateBody;

    private final String deliveryS3Bucket;

    private final String deliveryS3KeyPrefix;

    private final List<ConformancePackInputParameter> conformancePackInputParameters;

    private final List<String> excludedAccounts;

    private PutOrganizationConformancePackRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.templateS3Uri = builder.templateS3Uri;
        this.templateBody = builder.templateBody;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.excludedAccounts = builder.excludedAccounts;
    }

    /**
     * <p>
     * Name of the organization conformance pack you want to create.
     * </p>
     * 
     * @return Name of the organization conformance pack you want to create.
     */
    public final String organizationConformancePackName() {
        return organizationConformancePackName;
    }

    /**
     * <p>
     * Location of file containing the template body. The uri must point to the conformance pack template (max size: 300
     * KB).
     * </p>
     * <note>
     * <p>
     * You must have access to read Amazon S3 bucket.
     * </p>
     * </note>
     * 
     * @return Location of file containing the template body. The uri must point to the conformance pack template (max
     *         size: 300 KB).</p> <note>
     *         <p>
     *         You must have access to read Amazon S3 bucket.
     *         </p>
     */
    public final String templateS3Uri() {
        return templateS3Uri;
    }

    /**
     * <p>
     * A string containing full conformance pack template body. Structure containing the template body with a minimum
     * length of 1 byte and a maximum length of 51,200 bytes.
     * </p>
     * 
     * @return A string containing full conformance pack template body. Structure containing the template body with a
     *         minimum length of 1 byte and a maximum length of 51,200 bytes.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Amazon S3 bucket where AWS Config stores conformance pack templates.
     * </p>
     * <note>
     * <p>
     * This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.
     * </p>
     * </note>
     * 
     * @return Amazon S3 bucket where AWS Config stores conformance pack templates.</p> <note>
     *         <p>
     *         This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.
     *         </p>
     */
    public final String deliveryS3Bucket() {
        return deliveryS3Bucket;
    }

    /**
     * <p>
     * The prefix for the Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * This field is optional.
     * </p>
     * </note>
     * 
     * @return The prefix for the Amazon S3 bucket.</p> <note>
     *         <p>
     *         This field is optional.
     *         </p>
     */
    public final String deliveryS3KeyPrefix() {
        return deliveryS3KeyPrefix;
    }

    /**
     * Returns true if the ConformancePackInputParameters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasConformancePackInputParameters() {
        return conformancePackInputParameters != null && !(conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackInputParameter</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConformancePackInputParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ConformancePackInputParameter</code> objects.
     */
    public final List<ConformancePackInputParameter> conformancePackInputParameters() {
        return conformancePackInputParameters;
    }

    /**
     * Returns true if the ExcludedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExcludedAccounts() {
        return excludedAccounts != null && !(excludedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance pack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance
     *         pack.
     */
    public final List<String> excludedAccounts() {
        return excludedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryS3KeyPrefix());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackInputParameters() ? conformancePackInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedAccounts() ? excludedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOrganizationConformancePackRequest)) {
            return false;
        }
        PutOrganizationConformancePackRequest other = (PutOrganizationConformancePackRequest) obj;
        return Objects.equals(organizationConformancePackName(), other.organizationConformancePackName())
                && Objects.equals(templateS3Uri(), other.templateS3Uri()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(deliveryS3Bucket(), other.deliveryS3Bucket())
                && Objects.equals(deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix())
                && hasConformancePackInputParameters() == other.hasConformancePackInputParameters()
                && Objects.equals(conformancePackInputParameters(), other.conformancePackInputParameters())
                && hasExcludedAccounts() == other.hasExcludedAccounts()
                && Objects.equals(excludedAccounts(), other.excludedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutOrganizationConformancePackRequest")
                .add("OrganizationConformancePackName", organizationConformancePackName())
                .add("TemplateS3Uri", templateS3Uri())
                .add("TemplateBody", templateBody())
                .add("DeliveryS3Bucket", deliveryS3Bucket())
                .add("DeliveryS3KeyPrefix", deliveryS3KeyPrefix())
                .add("ConformancePackInputParameters",
                        hasConformancePackInputParameters() ? conformancePackInputParameters() : null)
                .add("ExcludedAccounts", hasExcludedAccounts() ? excludedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackName":
            return Optional.ofNullable(clazz.cast(organizationConformancePackName()));
        case "TemplateS3Uri":
            return Optional.ofNullable(clazz.cast(templateS3Uri()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "DeliveryS3Bucket":
            return Optional.ofNullable(clazz.cast(deliveryS3Bucket()));
        case "DeliveryS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(deliveryS3KeyPrefix()));
        case "ConformancePackInputParameters":
            return Optional.ofNullable(clazz.cast(conformancePackInputParameters()));
        case "ExcludedAccounts":
            return Optional.ofNullable(clazz.cast(excludedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutOrganizationConformancePackRequest, T> g) {
        return obj -> g.apply((PutOrganizationConformancePackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutOrganizationConformancePackRequest> {
        /**
         * <p>
         * Name of the organization conformance pack you want to create.
         * </p>
         * 
         * @param organizationConformancePackName
         *        Name of the organization conformance pack you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackName(String organizationConformancePackName);

        /**
         * <p>
         * Location of file containing the template body. The uri must point to the conformance pack template (max size:
         * 300 KB).
         * </p>
         * <note>
         * <p>
         * You must have access to read Amazon S3 bucket.
         * </p>
         * </note>
         * 
         * @param templateS3Uri
         *        Location of file containing the template body. The uri must point to the conformance pack template
         *        (max size: 300 KB).</p> <note>
         *        <p>
         *        You must have access to read Amazon S3 bucket.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateS3Uri(String templateS3Uri);

        /**
         * <p>
         * A string containing full conformance pack template body. Structure containing the template body with a
         * minimum length of 1 byte and a maximum length of 51,200 bytes.
         * </p>
         * 
         * @param templateBody
         *        A string containing full conformance pack template body. Structure containing the template body with a
         *        minimum length of 1 byte and a maximum length of 51,200 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Amazon S3 bucket where AWS Config stores conformance pack templates.
         * </p>
         * <note>
         * <p>
         * This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.
         * </p>
         * </note>
         * 
         * @param deliveryS3Bucket
         *        Amazon S3 bucket where AWS Config stores conformance pack templates.</p> <note>
         *        <p>
         *        This field is optional. If used, it must be prefixed with <code>awsconfigconforms</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3Bucket(String deliveryS3Bucket);

        /**
         * <p>
         * The prefix for the Amazon S3 bucket.
         * </p>
         * <note>
         * <p>
         * This field is optional.
         * </p>
         * </note>
         * 
         * @param deliveryS3KeyPrefix
         *        The prefix for the Amazon S3 bucket.</p> <note>
         *        <p>
         *        This field is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * 
         * @param conformancePackInputParameters
         *        A list of <code>ConformancePackInputParameter</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters);

        /**
         * <p>
         * A list of <code>ConformancePackInputParameter</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConformancePackInputParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConformancePackInputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConformancePackInputParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #conformancePackInputParameters(List<ConformancePackInputParameter>)}.
         * 
         * @param conformancePackInputParameters
         *        a consumer that will call methods on {@link List<ConformancePackInputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackInputParameters(List<ConformancePackInputParameter>)
         */
        Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters);

        /**
         * <p>
         * A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance
         * pack.
         * </p>
         * 
         * @param excludedAccounts
         *        A list of AWS accounts to be excluded from an organization conformance pack while deploying a
         *        conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(Collection<String> excludedAccounts);

        /**
         * <p>
         * A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance
         * pack.
         * </p>
         * 
         * @param excludedAccounts
         *        A list of AWS accounts to be excluded from an organization conformance pack while deploying a
         *        conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(String... excludedAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String organizationConformancePackName;

        private String templateS3Uri;

        private String templateBody;

        private String deliveryS3Bucket;

        private String deliveryS3KeyPrefix;

        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutOrganizationConformancePackRequest model) {
            super(model);
            organizationConformancePackName(model.organizationConformancePackName);
            templateS3Uri(model.templateS3Uri);
            templateBody(model.templateBody);
            deliveryS3Bucket(model.deliveryS3Bucket);
            deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            conformancePackInputParameters(model.conformancePackInputParameters);
            excludedAccounts(model.excludedAccounts);
        }

        public final String getOrganizationConformancePackName() {
            return organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        public final String getTemplateS3Uri() {
            return templateS3Uri;
        }

        @Override
        public final Builder templateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        public final void setTemplateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getDeliveryS3Bucket() {
            return deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final List<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            List<ConformancePackInputParameter.Builder> result = ConformancePackInputParametersCopier
                    .copyToBuilder(this.conformancePackInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder conformancePackInputParameters(
                Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter... conformancePackInputParameters) {
            conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(
                Consumer<ConformancePackInputParameter.Builder>... conformancePackInputParameters) {
            conformancePackInputParameters(Stream.of(conformancePackInputParameters)
                    .map(c -> ConformancePackInputParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(
                Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier
                    .copyFromBuilder(conformancePackInputParameters);
        }

        public final Collection<String> getExcludedAccounts() {
            if (excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String... excludedAccounts) {
            excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutOrganizationConformancePackRequest build() {
            return new PutOrganizationConformancePackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
