/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EvaluationsCopier {
    static List<Evaluation> copy(Collection<? extends Evaluation> evaluationsParam) {
        List<Evaluation> list;
        if (evaluationsParam == null || evaluationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Evaluation> modifiableList = new ArrayList<>();
            evaluationsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Evaluation> copyFromBuilder(Collection<? extends Evaluation.Builder> evaluationsParam) {
        List<Evaluation> list;
        if (evaluationsParam == null || evaluationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Evaluation> modifiableList = new ArrayList<>();
            evaluationsParam.forEach(entry -> {
                Evaluation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Evaluation.Builder> copyToBuilder(Collection<? extends Evaluation> evaluationsParam) {
        List<Evaluation.Builder> list;
        if (evaluationsParam == null || evaluationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Evaluation.Builder> modifiableList = new ArrayList<>();
            evaluationsParam.forEach(entry -> {
                Evaluation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
