/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status filter object to filter results based on specific member account ID or status type for an organization Config
 * rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusDetailFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<StatusDetailFilters.Builder, StatusDetailFilters> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(StatusDetailFilters::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_RULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberAccountRuleStatus").getter(getter(StatusDetailFilters::memberAccountRuleStatusAsString))
            .setter(setter(Builder::memberAccountRuleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountRuleStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            MEMBER_ACCOUNT_RULE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String memberAccountRuleStatus;

    private StatusDetailFilters(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.memberAccountRuleStatus = builder.memberAccountRuleStatus;
    }

    /**
     * <p>
     * The 12-digit account ID of the member account within an organization.
     * </p>
     * 
     * @return The 12-digit account ID of the member account within an organization.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Indicates deployment status for Config rule in the member account. When master account calls
     * <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member
     * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule
     * status is updated in the member account. Config rule status is deleted when the master account deletes
     * <code>OrganizationConfigRule</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountRuleStatus} will return {@link MemberAccountRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #memberAccountRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for Config rule in the member account. When master account calls
     *         <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the
     *         member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
     *         time, Config rule status is updated in the member account. Config rule status is deleted when the master
     *         account deletes <code>OrganizationConfigRule</code> and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see MemberAccountRuleStatus
     */
    public final MemberAccountRuleStatus memberAccountRuleStatus() {
        return MemberAccountRuleStatus.fromValue(memberAccountRuleStatus);
    }

    /**
     * <p>
     * Indicates deployment status for Config rule in the member account. When master account calls
     * <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member
     * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule
     * status is updated in the member account. Config rule status is deleted when the master account deletes
     * <code>OrganizationConfigRule</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the rule to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountRuleStatus} will return {@link MemberAccountRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #memberAccountRuleStatusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for Config rule in the member account. When master account calls
     *         <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the
     *         member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
     *         time, Config rule status is updated in the member account. Config rule status is deleted when the master
     *         account deletes <code>OrganizationConfigRule</code> and disables service access for
     *         <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the rule to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see MemberAccountRuleStatus
     */
    public final String memberAccountRuleStatusAsString() {
        return memberAccountRuleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountRuleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetailFilters)) {
            return false;
        }
        StatusDetailFilters other = (StatusDetailFilters) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(memberAccountRuleStatusAsString(), other.memberAccountRuleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusDetailFilters").add("AccountId", accountId())
                .add("MemberAccountRuleStatus", memberAccountRuleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "MemberAccountRuleStatus":
            return Optional.ofNullable(clazz.cast(memberAccountRuleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusDetailFilters, T> g) {
        return obj -> g.apply((StatusDetailFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusDetailFilters> {
        /**
         * <p>
         * The 12-digit account ID of the member account within an organization.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the member account within an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Indicates deployment status for Config rule in the member account. When master account calls
         * <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member
         * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config
         * rule status is updated in the member account. Config rule status is deleted when the master account deletes
         * <code>OrganizationConfigRule</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memberAccountRuleStatus
         *        Indicates deployment status for Config rule in the member account. When master account calls
         *        <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the
         *        member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
         *        time, Config rule status is updated in the member account. Config rule status is deleted when the
         *        master account deletes <code>OrganizationConfigRule</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see MemberAccountRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountRuleStatus
         */
        Builder memberAccountRuleStatus(String memberAccountRuleStatus);

        /**
         * <p>
         * Indicates deployment status for Config rule in the member account. When master account calls
         * <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member
         * account. When master account calls <code>PutOrganizationConfigRule</code> action for the second time, Config
         * rule status is updated in the member account. Config rule status is deleted when the master account deletes
         * <code>OrganizationConfigRule</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the rule to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memberAccountRuleStatus
         *        Indicates deployment status for Config rule in the member account. When master account calls
         *        <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the
         *        member account. When master account calls <code>PutOrganizationConfigRule</code> action for the second
         *        time, Config rule status is updated in the member account. Config rule status is deleted when the
         *        master account deletes <code>OrganizationConfigRule</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the rule to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when Config rule creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see MemberAccountRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountRuleStatus
         */
        Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String memberAccountRuleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetailFilters model) {
            accountId(model.accountId);
            memberAccountRuleStatus(model.memberAccountRuleStatus);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMemberAccountRuleStatus() {
            return memberAccountRuleStatus;
        }

        public final void setMemberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
        }

        @Override
        public final Builder memberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
            return this;
        }

        @Override
        public final Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus) {
            this.memberAccountRuleStatus(memberAccountRuleStatus == null ? null : memberAccountRuleStatus.toString());
            return this;
        }

        @Override
        public StatusDetailFilters build() {
            return new StatusDetailFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
