/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Config evaluation. Provides the Amazon Web Services resource that was evaluated, the compliance of
 * the resource, related time stamps, and supplementary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationResult.Builder, EvaluationResult> {
    private static final SdkField<EvaluationResultIdentifier> EVALUATION_RESULT_IDENTIFIER_FIELD = SdkField
            .<EvaluationResultIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("EvaluationResultIdentifier")
            .getter(getter(EvaluationResult::evaluationResultIdentifier))
            .setter(setter(Builder::evaluationResultIdentifier))
            .constructor(EvaluationResultIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResultIdentifier").build())
            .build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(EvaluationResult::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<Instant> RESULT_RECORDED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResultRecordedTime").getter(getter(EvaluationResult::resultRecordedTime))
            .setter(setter(Builder::resultRecordedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRecordedTime").build())
            .build();

    private static final SdkField<Instant> CONFIG_RULE_INVOKED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ConfigRuleInvokedTime").getter(getter(EvaluationResult::configRuleInvokedTime))
            .setter(setter(Builder::configRuleInvokedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleInvokedTime").build())
            .build();

    private static final SdkField<String> ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Annotation").getter(getter(EvaluationResult::annotation)).setter(setter(Builder::annotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()).build();

    private static final SdkField<String> RESULT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultToken").getter(getter(EvaluationResult::resultToken)).setter(setter(Builder::resultToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVALUATION_RESULT_IDENTIFIER_FIELD, COMPLIANCE_TYPE_FIELD, RESULT_RECORDED_TIME_FIELD,
            CONFIG_RULE_INVOKED_TIME_FIELD, ANNOTATION_FIELD, RESULT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final EvaluationResultIdentifier evaluationResultIdentifier;

    private final String complianceType;

    private final Instant resultRecordedTime;

    private final Instant configRuleInvokedTime;

    private final String annotation;

    private final String resultToken;

    private EvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.resultToken = builder.resultToken;
    }

    /**
     * <p>
     * Uniquely identifies the evaluation result.
     * </p>
     * 
     * @return Uniquely identifies the evaluation result.
     */
    public final EvaluationResultIdentifier evaluationResultIdentifier() {
        return evaluationResultIdentifier;
    }

    /**
     * <p>
     * Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.
     * </p>
     * <p>
     * For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
     *         <p>
     *         For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * @see ComplianceType
     */
    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.
     * </p>
     * <p>
     * For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.</p>
     *         <p>
     *         For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * @see ComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The time when Config recorded the evaluation result.
     * </p>
     * 
     * @return The time when Config recorded the evaluation result.
     */
    public final Instant resultRecordedTime() {
        return resultRecordedTime;
    }

    /**
     * <p>
     * The time when the Config rule evaluated the Amazon Web Services resource.
     * </p>
     * 
     * @return The time when the Config rule evaluated the Amazon Web Services resource.
     */
    public final Instant configRuleInvokedTime() {
        return configRuleInvokedTime;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public final String annotation() {
        return annotation;
    }

    /**
     * <p>
     * An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the Amazon
     * Web Services resource being evaluated, and the event that triggered the evaluation.
     * </p>
     * 
     * @return An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the
     *         Amazon Web Services resource being evaluated, and the event that triggered the evaluation.
     */
    public final String resultToken() {
        return resultToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(annotation());
        hashCode = 31 * hashCode + Objects.hashCode(resultToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult) obj;
        return Objects.equals(evaluationResultIdentifier(), other.evaluationResultIdentifier())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(resultRecordedTime(), other.resultRecordedTime())
                && Objects.equals(configRuleInvokedTime(), other.configRuleInvokedTime())
                && Objects.equals(annotation(), other.annotation()) && Objects.equals(resultToken(), other.resultToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationResult").add("EvaluationResultIdentifier", evaluationResultIdentifier())
                .add("ComplianceType", complianceTypeAsString()).add("ResultRecordedTime", resultRecordedTime())
                .add("ConfigRuleInvokedTime", configRuleInvokedTime()).add("Annotation", annotation())
                .add("ResultToken", resultToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationResultIdentifier":
            return Optional.ofNullable(clazz.cast(evaluationResultIdentifier()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "ResultRecordedTime":
            return Optional.ofNullable(clazz.cast(resultRecordedTime()));
        case "ConfigRuleInvokedTime":
            return Optional.ofNullable(clazz.cast(configRuleInvokedTime()));
        case "Annotation":
            return Optional.ofNullable(clazz.cast(annotation()));
        case "ResultToken":
            return Optional.ofNullable(clazz.cast(resultToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationResult> {
        /**
         * <p>
         * Uniquely identifies the evaluation result.
         * </p>
         * 
         * @param evaluationResultIdentifier
         *        Uniquely identifies the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier);

        /**
         * <p>
         * Uniquely identifies the evaluation result.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationResultIdentifier.Builder}
         * avoiding the need to create one manually via {@link EvaluationResultIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link EvaluationResultIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluationResultIdentifier(EvaluationResultIdentifier)}.
         * 
         * @param evaluationResultIdentifier
         *        a consumer that will call methods on {@link EvaluationResultIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResultIdentifier(EvaluationResultIdentifier)
         */
        default Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return evaluationResultIdentifier(EvaluationResultIdentifier.builder().applyMutation(evaluationResultIdentifier)
                    .build());
        }

        /**
         * <p>
         * Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated
         *        it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the Amazon Web Services resource complies with the Config rule that evaluated
         *        it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The time when Config recorded the evaluation result.
         * </p>
         * 
         * @param resultRecordedTime
         *        The time when Config recorded the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRecordedTime(Instant resultRecordedTime);

        /**
         * <p>
         * The time when the Config rule evaluated the Amazon Web Services resource.
         * </p>
         * 
         * @param configRuleInvokedTime
         *        The time when the Config rule evaluated the Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleInvokedTime(Instant configRuleInvokedTime);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * An encrypted token that associates an evaluation with an Config rule. The token identifies the rule, the
         * Amazon Web Services resource being evaluated, and the event that triggered the evaluation.
         * </p>
         * 
         * @param resultToken
         *        An encrypted token that associates an evaluation with an Config rule. The token identifies the rule,
         *        the Amazon Web Services resource being evaluated, and the event that triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultToken(String resultToken);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;

        private String complianceType;

        private Instant resultRecordedTime;

        private Instant configRuleInvokedTime;

        private String annotation;

        private String resultToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            evaluationResultIdentifier(model.evaluationResultIdentifier);
            complianceType(model.complianceType);
            resultRecordedTime(model.resultRecordedTime);
            configRuleInvokedTime(model.configRuleInvokedTime);
            annotation(model.annotation);
            resultToken(model.resultToken);
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return evaluationResultIdentifier != null ? evaluationResultIdentifier.toBuilder() : null;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final Instant getResultRecordedTime() {
            return resultRecordedTime;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final Instant getConfigRuleInvokedTime() {
            return configRuleInvokedTime;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final String getAnnotation() {
            return annotation;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final String getResultToken() {
            return resultToken;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        @Override
        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
