/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationConformancePackDetailedStatusRequest extends ConfigRequest
        implements
        ToCopyableBuilder<GetOrganizationConformancePackDetailedStatusRequest.Builder, GetOrganizationConformancePackDetailedStatusRequest> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConformancePackName")
            .getter(getter(GetOrganizationConformancePackDetailedStatusRequest::organizationConformancePackName))
            .setter(setter(Builder::organizationConformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName")
                    .build()).build();

    private static final SdkField<OrganizationResourceDetailedStatusFilters> FILTERS_FIELD = SdkField
            .<OrganizationResourceDetailedStatusFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(GetOrganizationConformancePackDetailedStatusRequest::filters)).setter(setter(Builder::filters))
            .constructor(OrganizationResourceDetailedStatusFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(GetOrganizationConformancePackDetailedStatusRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetOrganizationConformancePackDetailedStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, FILTERS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String organizationConformancePackName;

    private final OrganizationResourceDetailedStatusFilters filters;

    private final Integer limit;

    private final String nextToken;

    private GetOrganizationConformancePackDetailedStatusRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of organization conformance pack for which you want status details for member accounts.
     * </p>
     * 
     * @return The name of organization conformance pack for which you want status details for member accounts.
     */
    public final String organizationConformancePackName() {
        return organizationConformancePackName;
    }

    /**
     * <p>
     * An <code>OrganizationResourceDetailedStatusFilters</code> object.
     * </p>
     * 
     * @return An <code>OrganizationResourceDetailedStatusFilters</code> object.
     */
    public final OrganizationResourceDetailedStatusFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you do
     * not specify a number, Config uses the default. The default is 100.
     * </p>
     * 
     * @return The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If
     *         you do not specify a number, Config uses the default. The default is 100.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationConformancePackDetailedStatusRequest)) {
            return false;
        }
        GetOrganizationConformancePackDetailedStatusRequest other = (GetOrganizationConformancePackDetailedStatusRequest) obj;
        return Objects.equals(organizationConformancePackName(), other.organizationConformancePackName())
                && Objects.equals(filters(), other.filters()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationConformancePackDetailedStatusRequest")
                .add("OrganizationConformancePackName", organizationConformancePackName()).add("Filters", filters())
                .add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackName":
            return Optional.ofNullable(clazz.cast(organizationConformancePackName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationConformancePackDetailedStatusRequest, T> g) {
        return obj -> g.apply((GetOrganizationConformancePackDetailedStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationConformancePackDetailedStatusRequest> {
        /**
         * <p>
         * The name of organization conformance pack for which you want status details for member accounts.
         * </p>
         * 
         * @param organizationConformancePackName
         *        The name of organization conformance pack for which you want status details for member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackName(String organizationConformancePackName);

        /**
         * <p>
         * An <code>OrganizationResourceDetailedStatusFilters</code> object.
         * </p>
         * 
         * @param filters
         *        An <code>OrganizationResourceDetailedStatusFilters</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OrganizationResourceDetailedStatusFilters filters);

        /**
         * <p>
         * An <code>OrganizationResourceDetailedStatusFilters</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationResourceDetailedStatusFilters.Builder} avoiding the need to create one manually via
         * {@link OrganizationResourceDetailedStatusFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationResourceDetailedStatusFilters.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(OrganizationResourceDetailedStatusFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link OrganizationResourceDetailedStatusFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(OrganizationResourceDetailedStatusFilters)
         */
        default Builder filters(Consumer<OrganizationResourceDetailedStatusFilters.Builder> filters) {
            return filters(OrganizationResourceDetailedStatusFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page. If you
         * do not specify a number, Config uses the default. The default is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of <code>OrganizationConformancePackDetailedStatuses</code> returned on each page.
         *        If you do not specify a number, Config uses the default. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String organizationConformancePackName;

        private OrganizationResourceDetailedStatusFilters filters;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationConformancePackDetailedStatusRequest model) {
            super(model);
            organizationConformancePackName(model.organizationConformancePackName);
            filters(model.filters);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getOrganizationConformancePackName() {
            return organizationConformancePackName;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final OrganizationResourceDetailedStatusFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(OrganizationResourceDetailedStatusFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(OrganizationResourceDetailedStatusFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOrganizationConformancePackDetailedStatusRequest build() {
            return new GetOrganizationConformancePackDetailedStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
