/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDiscoveredResourcesResponse extends ConfigResponse implements
        ToCopyableBuilder<ListDiscoveredResourcesResponse.Builder, ListDiscoveredResourcesResponse> {
    private static final SdkField<List<ResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<ResourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("resourceIdentifiers")
            .getter(getter(ListDiscoveredResourcesResponse::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDiscoveredResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private ListDiscoveredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIdentifiers() {
        return resourceIdentifiers != null && !(resourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details that identify a resource that is discovered by Config, including the resource type, ID, and (if
     * available) the custom resource name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIdentifiers} method.
     * </p>
     * 
     * @return The details that identify a resource that is discovered by Config, including the resource type, ID, and
     *         (if available) the custom resource name.
     */
    public final List<ResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIdentifiers() ? resourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResponse)) {
            return false;
        }
        ListDiscoveredResourcesResponse other = (ListDiscoveredResourcesResponse) obj;
        return hasResourceIdentifiers() == other.hasResourceIdentifiers()
                && Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDiscoveredResourcesResponse")
                .add("ResourceIdentifiers", hasResourceIdentifiers() ? resourceIdentifiers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveredResourcesResponse, T> g) {
        return obj -> g.apply((ListDiscoveredResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDiscoveredResourcesResponse> {
        /**
         * <p>
         * The details that identify a resource that is discovered by Config, including the resource type, ID, and (if
         * available) the custom resource name.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by Config, including the resource type, ID,
         *        and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * The details that identify a resource that is discovered by Config, including the resource type, ID, and (if
         * available) the custom resource name.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The details that identify a resource that is discovered by Config, including the resource type, ID,
         *        and (if available) the custom resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * The details that identify a resource that is discovered by Config, including the resource type, ID, and (if
         * available) the custom resource name.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ResourceIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<ResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceIdentifier>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIdentifiers(List<ResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on {@link List<ResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(List<ResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesResponse model) {
            super(model);
            resourceIdentifiers(model.resourceIdentifiers);
            nextToken(model.nextToken);
        }

        public final List<ResourceIdentifier.Builder> getResourceIdentifiers() {
            List<ResourceIdentifier.Builder> result = ResourceIdentifierListCopier.copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> ResourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDiscoveredResourcesResponse build() {
            return new ListDiscoveredResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
