/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
 * </p>
 * <ul>
 * <li>
 * <p>
 * No permission to call <code>EnableAWSServiceAccess</code> API
 * </p>
 * </li>
 * <li>
 * <p>
 * The configuration aggregator cannot be updated because your Amazon Web Services Organization management account or
 * the delegated administrator role changed. Delete this aggregator and create a new one with the current Amazon Web
 * Services Organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * The configuration aggregator is associated with a previous Amazon Web Services Organization and Config cannot
 * aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a new one with the
 * current Amazon Web Services Organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * You are not a registered delegated administrator for Config with permissions to call
 * <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated administrator
 * for Config service principle name before the delegated administrator creates an aggregator.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config throws an
 * exception if APIs are called from member accounts. All APIs must be called from organization master account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationAccessDeniedException extends ConfigException implements
        ToCopyableBuilder<OrganizationAccessDeniedException.Builder, OrganizationAccessDeniedException> {
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList());

    private static final long serialVersionUID = 1L;

    private OrganizationAccessDeniedException(BuilderImpl builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationAccessDeniedException>,
            ConfigException.Builder {
        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ConfigException.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationAccessDeniedException model) {
            super(model);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public OrganizationAccessDeniedException build() {
            return new OrganizationAccessDeniedException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
