/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details about the remediation configuration that includes the remediation action,
 * parameters, and data to execute the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationConfiguration.Builder, RemediationConfiguration> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(RemediationConfiguration::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(RemediationConfiguration::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(RemediationConfiguration::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetVersion").getter(getter(RemediationConfiguration::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<Map<String, RemediationParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, RemediationParameterValue>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(RemediationConfiguration::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RemediationParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(RemediationConfiguration::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Automatic").getter(getter(RemediationConfiguration::automatic)).setter(setter(Builder::automatic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automatic").build()).build();

    private static final SdkField<ExecutionControls> EXECUTION_CONTROLS_FIELD = SdkField
            .<ExecutionControls> builder(MarshallingType.SDK_POJO).memberName("ExecutionControls")
            .getter(getter(RemediationConfiguration::executionControls)).setter(setter(Builder::executionControls))
            .constructor(ExecutionControls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionControls").build()).build();

    private static final SdkField<Integer> MAXIMUM_AUTOMATIC_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumAutomaticAttempts").getter(getter(RemediationConfiguration::maximumAutomaticAttempts))
            .setter(setter(Builder::maximumAutomaticAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumAutomaticAttempts").build())
            .build();

    private static final SdkField<Long> RETRY_ATTEMPT_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RetryAttemptSeconds").getter(getter(RemediationConfiguration::retryAttemptSeconds))
            .setter(setter(Builder::retryAttemptSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttemptSeconds").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RemediationConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATED_BY_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByService").getter(getter(RemediationConfiguration::createdByService))
            .setter(setter(Builder::createdByService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            TARGET_TYPE_FIELD, TARGET_ID_FIELD, TARGET_VERSION_FIELD, PARAMETERS_FIELD, RESOURCE_TYPE_FIELD, AUTOMATIC_FIELD,
            EXECUTION_CONTROLS_FIELD, MAXIMUM_AUTOMATIC_ATTEMPTS_FIELD, RETRY_ATTEMPT_SECONDS_FIELD, ARN_FIELD,
            CREATED_BY_SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String targetType;

    private final String targetId;

    private final String targetVersion;

    private final Map<String, RemediationParameterValue> parameters;

    private final String resourceType;

    private final Boolean automatic;

    private final ExecutionControls executionControls;

    private final Integer maximumAutomaticAttempts;

    private final Long retryAttemptSeconds;

    private final String arn;

    private final String createdByService;

    private RemediationConfiguration(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.targetVersion = builder.targetVersion;
        this.parameters = builder.parameters;
        this.resourceType = builder.resourceType;
        this.automatic = builder.automatic;
        this.executionControls = builder.executionControls;
        this.maximumAutomaticAttempts = builder.maximumAutomaticAttempts;
        this.retryAttemptSeconds = builder.retryAttemptSeconds;
        this.arn = builder.arn;
        this.createdByService = builder.createdByService;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The type of the target. Target executes remediation. For example, SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RemediationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target. Target executes remediation. For example, SSM document.
     * @see RemediationTargetType
     */
    public final RemediationTargetType targetType() {
        return RemediationTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the target. Target executes remediation. For example, SSM document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RemediationTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the target. Target executes remediation. For example, SSM document.
     * @see RemediationTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * Target ID is the name of the public document.
     * </p>
     * 
     * @return Target ID is the name of the public document.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * Version of the target. For example, version of the SSM document.
     * </p>
     * <note>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API
     * again to ensure the remediations can run.
     * </p>
     * </note>
     * 
     * @return Version of the target. For example, version of the SSM document.</p> <note>
     *         <p>
     *         If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration
     *         API again to ensure the remediations can run.
     *         </p>
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object of the RemediationParameterValue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An object of the RemediationParameterValue.
     */
    public final Map<String, RemediationParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @return The type of a resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The remediation is triggered automatically.
     * </p>
     * 
     * @return The remediation is triggered automatically.
     */
    public final Boolean automatic() {
        return automatic;
    }

    /**
     * <p>
     * An ExecutionControls object.
     * </p>
     * 
     * @return An ExecutionControls object.
     */
    public final ExecutionControls executionControls() {
        return executionControls;
    }

    /**
     * <p>
     * The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     * </p>
     * <p>
     * For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put
     * a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.
     * </p>
     * 
     * @return The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is
     *         5.</p>
     *         <p>
     *         For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config
     *         will put a RemediationException on your behalf for the failing resource after the 5th failed attempt
     *         within 50 seconds.
     */
    public final Integer maximumAutomaticAttempts() {
        return maximumAutomaticAttempts;
    }

    /**
     * <p>
     * Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60
     * seconds.
     * </p>
     * <p>
     * For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5, Config will run
     * auto-remediations 5 times within 50 seconds before throwing an exception.
     * </p>
     * 
     * @return Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is
     *         60 seconds. </p>
     *         <p>
     *         For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5, Config
     *         will run auto-remediations 5 times within 50 seconds before throwing an exception.
     */
    public final Long retryAttemptSeconds() {
        return retryAttemptSeconds;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of remediation configuration.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of remediation configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Name of the service that owns the service-linked rule, if applicable.
     * </p>
     * 
     * @return Name of the service that owns the service-linked rule, if applicable.
     */
    public final String createdByService() {
        return createdByService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(automatic());
        hashCode = 31 * hashCode + Objects.hashCode(executionControls());
        hashCode = 31 * hashCode + Objects.hashCode(maximumAutomaticAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(retryAttemptSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdByService());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetId(), other.targetId()) && Objects.equals(targetVersion(), other.targetVersion())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(automatic(), other.automatic())
                && Objects.equals(executionControls(), other.executionControls())
                && Objects.equals(maximumAutomaticAttempts(), other.maximumAutomaticAttempts())
                && Objects.equals(retryAttemptSeconds(), other.retryAttemptSeconds()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdByService(), other.createdByService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationConfiguration").add("ConfigRuleName", configRuleName())
                .add("TargetType", targetTypeAsString()).add("TargetId", targetId()).add("TargetVersion", targetVersion())
                .add("Parameters", hasParameters() ? parameters() : null).add("ResourceType", resourceType())
                .add("Automatic", automatic()).add("ExecutionControls", executionControls())
                .add("MaximumAutomaticAttempts", maximumAutomaticAttempts()).add("RetryAttemptSeconds", retryAttemptSeconds())
                .add("Arn", arn()).add("CreatedByService", createdByService()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Automatic":
            return Optional.ofNullable(clazz.cast(automatic()));
        case "ExecutionControls":
            return Optional.ofNullable(clazz.cast(executionControls()));
        case "MaximumAutomaticAttempts":
            return Optional.ofNullable(clazz.cast(maximumAutomaticAttempts()));
        case "RetryAttemptSeconds":
            return Optional.ofNullable(clazz.cast(retryAttemptSeconds()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedByService":
            return Optional.ofNullable(clazz.cast(createdByService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationConfiguration, T> g) {
        return obj -> g.apply((RemediationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationConfiguration> {
        /**
         * <p>
         * The name of the Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The type of the target. Target executes remediation. For example, SSM document.
         * </p>
         * 
         * @param targetType
         *        The type of the target. Target executes remediation. For example, SSM document.
         * @see RemediationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the target. Target executes remediation. For example, SSM document.
         * </p>
         * 
         * @param targetType
         *        The type of the target. Target executes remediation. For example, SSM document.
         * @see RemediationTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationTargetType
         */
        Builder targetType(RemediationTargetType targetType);

        /**
         * <p>
         * Target ID is the name of the public document.
         * </p>
         * 
         * @param targetId
         *        Target ID is the name of the public document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * Version of the target. For example, version of the SSM document.
         * </p>
         * <note>
         * <p>
         * If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API
         * again to ensure the remediations can run.
         * </p>
         * </note>
         * 
         * @param targetVersion
         *        Version of the target. For example, version of the SSM document.</p> <note>
         *        <p>
         *        If you make backward incompatible changes to the SSM document, you must call
         *        PutRemediationConfiguration API again to ensure the remediations can run.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * An object of the RemediationParameterValue.
         * </p>
         * 
         * @param parameters
         *        An object of the RemediationParameterValue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, RemediationParameterValue> parameters);

        /**
         * <p>
         * The type of a resource.
         * </p>
         * 
         * @param resourceType
         *        The type of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The remediation is triggered automatically.
         * </p>
         * 
         * @param automatic
         *        The remediation is triggered automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatic(Boolean automatic);

        /**
         * <p>
         * An ExecutionControls object.
         * </p>
         * 
         * @param executionControls
         *        An ExecutionControls object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionControls(ExecutionControls executionControls);

        /**
         * <p>
         * An ExecutionControls object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionControls.Builder} avoiding the
         * need to create one manually via {@link ExecutionControls#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionControls.Builder#build()} is called immediately and its
         * result is passed to {@link #executionControls(ExecutionControls)}.
         * 
         * @param executionControls
         *        a consumer that will call methods on {@link ExecutionControls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionControls(ExecutionControls)
         */
        default Builder executionControls(Consumer<ExecutionControls.Builder> executionControls) {
            return executionControls(ExecutionControls.builder().applyMutation(executionControls).build());
        }

        /**
         * <p>
         * The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
         * </p>
         * <p>
         * For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will
         * put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50
         * seconds.
         * </p>
         * 
         * @param maximumAutomaticAttempts
         *        The maximum number of failed attempts for auto-remediation. If you do not select a number, the default
         *        is 5.</p>
         *        <p>
         *        For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds,
         *        Config will put a RemediationException on your behalf for the failing resource after the 5th failed
         *        attempt within 50 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumAutomaticAttempts(Integer maximumAutomaticAttempts);

        /**
         * <p>
         * Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default is 60
         * seconds.
         * </p>
         * <p>
         * For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5, Config will
         * run auto-remediations 5 times within 50 seconds before throwing an exception.
         * </p>
         * 
         * @param retryAttemptSeconds
         *        Maximum time in seconds that Config runs auto-remediation. If you do not select a number, the default
         *        is 60 seconds. </p>
         *        <p>
         *        For example, if you specify RetryAttemptSeconds as 50 seconds and MaximumAutomaticAttempts as 5,
         *        Config will run auto-remediations 5 times within 50 seconds before throwing an exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAttemptSeconds(Long retryAttemptSeconds);

        /**
         * <p>
         * Amazon Resource Name (ARN) of remediation configuration.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) of remediation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Name of the service that owns the service-linked rule, if applicable.
         * </p>
         * 
         * @param createdByService
         *        Name of the service that owns the service-linked rule, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByService(String createdByService);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String targetType;

        private String targetId;

        private String targetVersion;

        private Map<String, RemediationParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String resourceType;

        private Boolean automatic;

        private ExecutionControls executionControls;

        private Integer maximumAutomaticAttempts;

        private Long retryAttemptSeconds;

        private String arn;

        private String createdByService;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationConfiguration model) {
            configRuleName(model.configRuleName);
            targetType(model.targetType);
            targetId(model.targetId);
            targetVersion(model.targetVersion);
            parameters(model.parameters);
            resourceType(model.resourceType);
            automatic(model.automatic);
            executionControls(model.executionControls);
            maximumAutomaticAttempts(model.maximumAutomaticAttempts);
            retryAttemptSeconds(model.retryAttemptSeconds);
            arn(model.arn);
            createdByService(model.createdByService);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RemediationTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Map<String, RemediationParameterValue.Builder> getParameters() {
            Map<String, RemediationParameterValue.Builder> result = RemediationParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, RemediationParameterValue.BuilderImpl> parameters) {
            this.parameters = RemediationParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, RemediationParameterValue> parameters) {
            this.parameters = RemediationParametersCopier.copy(parameters);
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Boolean getAutomatic() {
            return automatic;
        }

        public final void setAutomatic(Boolean automatic) {
            this.automatic = automatic;
        }

        @Override
        public final Builder automatic(Boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        public final ExecutionControls.Builder getExecutionControls() {
            return executionControls != null ? executionControls.toBuilder() : null;
        }

        public final void setExecutionControls(ExecutionControls.BuilderImpl executionControls) {
            this.executionControls = executionControls != null ? executionControls.build() : null;
        }

        @Override
        public final Builder executionControls(ExecutionControls executionControls) {
            this.executionControls = executionControls;
            return this;
        }

        public final Integer getMaximumAutomaticAttempts() {
            return maximumAutomaticAttempts;
        }

        public final void setMaximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
            this.maximumAutomaticAttempts = maximumAutomaticAttempts;
        }

        @Override
        public final Builder maximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
            this.maximumAutomaticAttempts = maximumAutomaticAttempts;
            return this;
        }

        public final Long getRetryAttemptSeconds() {
            return retryAttemptSeconds;
        }

        public final void setRetryAttemptSeconds(Long retryAttemptSeconds) {
            this.retryAttemptSeconds = retryAttemptSeconds;
        }

        @Override
        public final Builder retryAttemptSeconds(Long retryAttemptSeconds) {
            this.retryAttemptSeconds = retryAttemptSeconds;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedByService() {
            return createdByService;
        }

        public final void setCreatedByService(String createdByService) {
            this.createdByService = createdByService;
        }

        @Override
        public final Builder createdByService(String createdByService) {
            this.createdByService = createdByService;
            return this;
        }

        @Override
        public RemediationConfiguration build() {
            return new RemediationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
