/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an Config rule is compliant based on account ID, region, compliance, and rule name.
 * </p>
 * <p>
 * A rule is compliant if all of the resources that the rule evaluated comply with it. It is noncompliant if any of
 * these resources do not comply.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateComplianceByConfigRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateComplianceByConfigRule.Builder, AggregateComplianceByConfigRule> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(AggregateComplianceByConfigRule::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.<Compliance> builder(MarshallingType.SDK_POJO)
            .memberName("Compliance").getter(getter(AggregateComplianceByConfigRule::compliance))
            .setter(setter(Builder::compliance)).constructor(Compliance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AggregateComplianceByConfigRule::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(AggregateComplianceByConfigRule::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final Compliance compliance;

    private final String accountId;

    private final String awsRegion;

    private AggregateComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of
     * contributors that affect the compliance.
     * </p>
     * 
     * @return Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of
     *         contributors that affect the compliance.
     */
    public final Compliance compliance() {
        return compliance;
    }

    /**
     * <p>
     * The 12-digit account ID of the source account.
     * </p>
     * 
     * @return The 12-digit account ID of the source account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source region from where the data is aggregated.
     * </p>
     * 
     * @return The source region from where the data is aggregated.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateComplianceByConfigRule)) {
            return false;
        }
        AggregateComplianceByConfigRule other = (AggregateComplianceByConfigRule) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(compliance(), other.compliance())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(awsRegion(), other.awsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateComplianceByConfigRule").add("ConfigRuleName", configRuleName())
                .add("Compliance", compliance()).add("AccountId", accountId()).add("AwsRegion", awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateComplianceByConfigRule, T> g) {
        return obj -> g.apply((AggregateComplianceByConfigRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateComplianceByConfigRule> {
        /**
         * <p>
         * The name of the Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of
         * contributors that affect the compliance.
         * </p>
         * 
         * @param compliance
         *        Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number
         *        of contributors that affect the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);

        /**
         * <p>
         * Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of
         * contributors that affect the compliance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Compliance.Builder} avoiding the need to
         * create one manually via {@link Compliance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Compliance.Builder#build()} is called immediately and its result
         * is passed to {@link #compliance(Compliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link Compliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(Compliance)
         */
        default Builder compliance(Consumer<Compliance.Builder> compliance) {
            return compliance(Compliance.builder().applyMutation(compliance).build());
        }

        /**
         * <p>
         * The 12-digit account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source region from where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source region from where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private Compliance compliance;

        private String accountId;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateComplianceByConfigRule model) {
            configRuleName(model.configRuleName);
            compliance(model.compliance);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public AggregateComplianceByConfigRule build() {
            return new AggregateComplianceByConfigRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
