/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRemediationExceptionsResponse extends ConfigResponse implements
        ToCopyableBuilder<PutRemediationExceptionsResponse.Builder, PutRemediationExceptionsResponse> {
    private static final SdkField<List<FailedRemediationExceptionBatch>> FAILED_BATCHES_FIELD = SdkField
            .<List<FailedRemediationExceptionBatch>> builder(MarshallingType.LIST)
            .memberName("FailedBatches")
            .getter(getter(PutRemediationExceptionsResponse::failedBatches))
            .setter(setter(Builder::failedBatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedBatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedRemediationExceptionBatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedRemediationExceptionBatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_BATCHES_FIELD));

    private final List<FailedRemediationExceptionBatch> failedBatches;

    private PutRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.failedBatches = builder.failedBatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedBatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedBatches() {
        return failedBatches != null && !(failedBatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
     * failed items and failure messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedBatches} method.
     * </p>
     * 
     * @return Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
     *         list of failed items and failure messages.
     */
    public final List<FailedRemediationExceptionBatch> failedBatches() {
        return failedBatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedBatches() ? failedBatches() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationExceptionsResponse)) {
            return false;
        }
        PutRemediationExceptionsResponse other = (PutRemediationExceptionsResponse) obj;
        return hasFailedBatches() == other.hasFailedBatches() && Objects.equals(failedBatches(), other.failedBatches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRemediationExceptionsResponse")
                .add("FailedBatches", hasFailedBatches() ? failedBatches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedBatches":
            return Optional.ofNullable(clazz.cast(failedBatches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((PutRemediationExceptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRemediationExceptionsResponse> {
        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
         *        list of failed items and failure messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(Collection<FailedRemediationExceptionBatch> failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * 
         * @param failedBatches
         *        Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a
         *        list of failed items and failure messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatches(FailedRemediationExceptionBatch... failedBatches);

        /**
         * <p>
         * Returns a list of failed remediation exceptions batch objects. Each object in the batch consists of a list of
         * failed items and failure messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <FailedRemediationExceptionBatch>.Builder} avoiding the need to create one manually via {@link List
         * <FailedRemediationExceptionBatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedRemediationExceptionBatch>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedBatches(List<FailedRemediationExceptionBatch>)}.
         * 
         * @param failedBatches
         *        a consumer that will call methods on {@link List<FailedRemediationExceptionBatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedBatches(List<FailedRemediationExceptionBatch>)
         */
        Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder>... failedBatches);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<FailedRemediationExceptionBatch> failedBatches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationExceptionsResponse model) {
            super(model);
            failedBatches(model.failedBatches);
        }

        public final List<FailedRemediationExceptionBatch.Builder> getFailedBatches() {
            List<FailedRemediationExceptionBatch.Builder> result = FailedRemediationExceptionBatchesCopier
                    .copyToBuilder(this.failedBatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedBatches(Collection<FailedRemediationExceptionBatch.BuilderImpl> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copyFromBuilder(failedBatches);
        }

        @Override
        public final Builder failedBatches(Collection<FailedRemediationExceptionBatch> failedBatches) {
            this.failedBatches = FailedRemediationExceptionBatchesCopier.copy(failedBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(FailedRemediationExceptionBatch... failedBatches) {
            failedBatches(Arrays.asList(failedBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatches(Consumer<FailedRemediationExceptionBatch.Builder>... failedBatches) {
            failedBatches(Stream.of(failedBatches).map(c -> FailedRemediationExceptionBatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutRemediationExceptionsResponse build() {
            return new PutRemediationExceptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
