/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An organization Config rule that has information about Config rules that Config creates in member accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationConfigRule implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationConfigRule.Builder, OrganizationConfigRule> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConfigRuleName")
            .getter(getter(OrganizationConfigRule::organizationConfigRuleName))
            .setter(setter(Builder::organizationConfigRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build())
            .build();

    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationConfigRuleArn").getter(getter(OrganizationConfigRule::organizationConfigRuleArn))
            .setter(setter(Builder::organizationConfigRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleArn").build())
            .build();

    private static final SdkField<OrganizationManagedRuleMetadata> ORGANIZATION_MANAGED_RULE_METADATA_FIELD = SdkField
            .<OrganizationManagedRuleMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationManagedRuleMetadata")
            .getter(getter(OrganizationConfigRule::organizationManagedRuleMetadata))
            .setter(setter(Builder::organizationManagedRuleMetadata))
            .constructor(OrganizationManagedRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationManagedRuleMetadata")
                    .build()).build();

    private static final SdkField<OrganizationCustomRuleMetadata> ORGANIZATION_CUSTOM_RULE_METADATA_FIELD = SdkField
            .<OrganizationCustomRuleMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationCustomRuleMetadata")
            .getter(getter(OrganizationConfigRule::organizationCustomRuleMetadata))
            .setter(setter(Builder::organizationCustomRuleMetadata))
            .constructor(OrganizationCustomRuleMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationCustomRuleMetadata")
                    .build()).build();

    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedAccounts")
            .getter(getter(OrganizationConfigRule::excludedAccounts))
            .setter(setter(Builder::excludedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(OrganizationConfigRule::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<OrganizationCustomPolicyRuleMetadataNoPolicy> ORGANIZATION_CUSTOM_POLICY_RULE_METADATA_FIELD = SdkField
            .<OrganizationCustomPolicyRuleMetadataNoPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationCustomPolicyRuleMetadata")
            .getter(getter(OrganizationConfigRule::organizationCustomPolicyRuleMetadata))
            .setter(setter(Builder::organizationCustomPolicyRuleMetadata))
            .constructor(OrganizationCustomPolicyRuleMetadataNoPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationCustomPolicyRuleMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_CONFIG_RULE_ARN_FIELD, ORGANIZATION_MANAGED_RULE_METADATA_FIELD,
            ORGANIZATION_CUSTOM_RULE_METADATA_FIELD, EXCLUDED_ACCOUNTS_FIELD, LAST_UPDATE_TIME_FIELD,
            ORGANIZATION_CUSTOM_POLICY_RULE_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationConfigRuleName;

    private final String organizationConfigRuleArn;

    private final OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

    private final OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

    private final List<String> excludedAccounts;

    private final Instant lastUpdateTime;

    private final OrganizationCustomPolicyRuleMetadataNoPolicy organizationCustomPolicyRuleMetadata;

    private OrganizationConfigRule(BuilderImpl builder) {
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationConfigRuleArn = builder.organizationConfigRuleArn;
        this.organizationManagedRuleMetadata = builder.organizationManagedRuleMetadata;
        this.organizationCustomRuleMetadata = builder.organizationCustomRuleMetadata;
        this.excludedAccounts = builder.excludedAccounts;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.organizationCustomPolicyRuleMetadata = builder.organizationCustomPolicyRuleMetadata;
    }

    /**
     * <p>
     * The name that you assign to organization Config rule.
     * </p>
     * 
     * @return The name that you assign to organization Config rule.
     */
    public final String organizationConfigRuleName() {
        return organizationConfigRuleName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of organization Config rule.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of organization Config rule.
     */
    public final String organizationConfigRuleArn() {
        return organizationConfigRuleArn;
    }

    /**
     * <p>
     * An <code>OrganizationManagedRuleMetadata</code> object.
     * </p>
     * 
     * @return An <code>OrganizationManagedRuleMetadata</code> object.
     */
    public final OrganizationManagedRuleMetadata organizationManagedRuleMetadata() {
        return organizationManagedRuleMetadata;
    }

    /**
     * <p>
     * An <code>OrganizationCustomRuleMetadata</code> object.
     * </p>
     * 
     * @return An <code>OrganizationCustomRuleMetadata</code> object.
     */
    public final OrganizationCustomRuleMetadata organizationCustomRuleMetadata() {
        return organizationCustomRuleMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedAccounts() {
        return excludedAccounts != null && !(excludedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A comma-separated list of accounts excluded from organization Config rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedAccounts} method.
     * </p>
     * 
     * @return A comma-separated list of accounts excluded from organization Config rule.
     */
    public final List<String> excludedAccounts() {
        return excludedAccounts;
    }

    /**
     * <p>
     * The timestamp of the last update.
     * </p>
     * 
     * @return The timestamp of the last update.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes the
     * runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as
     * resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate Config
     * to evaluate Amazon Web Services resources against a rule.
     * </p>
     * 
     * @return An object that specifies metadata for your organization's Config Custom Policy rule. The metadata
     *         includes the runtime system in use, which accounts have debug logging enabled, and other custom rule
     *         metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger
     *         types that initiate Config to evaluate Amazon Web Services resources against a rule.
     */
    public final OrganizationCustomPolicyRuleMetadataNoPolicy organizationCustomPolicyRuleMetadata() {
        return organizationCustomPolicyRuleMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationConfigRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationManagedRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(organizationCustomRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedAccounts() ? excludedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(organizationCustomPolicyRuleMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConfigRule)) {
            return false;
        }
        OrganizationConfigRule other = (OrganizationConfigRule) obj;
        return Objects.equals(organizationConfigRuleName(), other.organizationConfigRuleName())
                && Objects.equals(organizationConfigRuleArn(), other.organizationConfigRuleArn())
                && Objects.equals(organizationManagedRuleMetadata(), other.organizationManagedRuleMetadata())
                && Objects.equals(organizationCustomRuleMetadata(), other.organizationCustomRuleMetadata())
                && hasExcludedAccounts() == other.hasExcludedAccounts()
                && Objects.equals(excludedAccounts(), other.excludedAccounts())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(organizationCustomPolicyRuleMetadata(), other.organizationCustomPolicyRuleMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationConfigRule").add("OrganizationConfigRuleName", organizationConfigRuleName())
                .add("OrganizationConfigRuleArn", organizationConfigRuleArn())
                .add("OrganizationManagedRuleMetadata", organizationManagedRuleMetadata())
                .add("OrganizationCustomRuleMetadata", organizationCustomRuleMetadata())
                .add("ExcludedAccounts", hasExcludedAccounts() ? excludedAccounts() : null)
                .add("LastUpdateTime", lastUpdateTime())
                .add("OrganizationCustomPolicyRuleMetadata", organizationCustomPolicyRuleMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRuleName":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleName()));
        case "OrganizationConfigRuleArn":
            return Optional.ofNullable(clazz.cast(organizationConfigRuleArn()));
        case "OrganizationManagedRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationManagedRuleMetadata()));
        case "OrganizationCustomRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationCustomRuleMetadata()));
        case "ExcludedAccounts":
            return Optional.ofNullable(clazz.cast(excludedAccounts()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "OrganizationCustomPolicyRuleMetadata":
            return Optional.ofNullable(clazz.cast(organizationCustomPolicyRuleMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConfigRule, T> g) {
        return obj -> g.apply((OrganizationConfigRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationConfigRule> {
        /**
         * <p>
         * The name that you assign to organization Config rule.
         * </p>
         * 
         * @param organizationConfigRuleName
         *        The name that you assign to organization Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleName(String organizationConfigRuleName);

        /**
         * <p>
         * Amazon Resource Name (ARN) of organization Config rule.
         * </p>
         * 
         * @param organizationConfigRuleArn
         *        Amazon Resource Name (ARN) of organization Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRuleArn(String organizationConfigRuleArn);

        /**
         * <p>
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * </p>
         * 
         * @param organizationManagedRuleMetadata
         *        An <code>OrganizationManagedRuleMetadata</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata);

        /**
         * <p>
         * An <code>OrganizationManagedRuleMetadata</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationManagedRuleMetadata.Builder}
         * avoiding the need to create one manually via {@link OrganizationManagedRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationManagedRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)}.
         * 
         * @param organizationManagedRuleMetadata
         *        a consumer that will call methods on {@link OrganizationManagedRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationManagedRuleMetadata(OrganizationManagedRuleMetadata)
         */
        default Builder organizationManagedRuleMetadata(
                Consumer<OrganizationManagedRuleMetadata.Builder> organizationManagedRuleMetadata) {
            return organizationManagedRuleMetadata(OrganizationManagedRuleMetadata.builder()
                    .applyMutation(organizationManagedRuleMetadata).build());
        }

        /**
         * <p>
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * </p>
         * 
         * @param organizationCustomRuleMetadata
         *        An <code>OrganizationCustomRuleMetadata</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata);

        /**
         * <p>
         * An <code>OrganizationCustomRuleMetadata</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationCustomRuleMetadata.Builder}
         * avoiding the need to create one manually via {@link OrganizationCustomRuleMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationCustomRuleMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)}.
         * 
         * @param organizationCustomRuleMetadata
         *        a consumer that will call methods on {@link OrganizationCustomRuleMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationCustomRuleMetadata(OrganizationCustomRuleMetadata)
         */
        default Builder organizationCustomRuleMetadata(
                Consumer<OrganizationCustomRuleMetadata.Builder> organizationCustomRuleMetadata) {
            return organizationCustomRuleMetadata(OrganizationCustomRuleMetadata.builder()
                    .applyMutation(organizationCustomRuleMetadata).build());
        }

        /**
         * <p>
         * A comma-separated list of accounts excluded from organization Config rule.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts excluded from organization Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(Collection<String> excludedAccounts);

        /**
         * <p>
         * A comma-separated list of accounts excluded from organization Config rule.
         * </p>
         * 
         * @param excludedAccounts
         *        A comma-separated list of accounts excluded from organization Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedAccounts(String... excludedAccounts);

        /**
         * <p>
         * The timestamp of the last update.
         * </p>
         * 
         * @param lastUpdateTime
         *        The timestamp of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes
         * the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as
         * resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate
         * Config to evaluate Amazon Web Services resources against a rule.
         * </p>
         * 
         * @param organizationCustomPolicyRuleMetadata
         *        An object that specifies metadata for your organization's Config Custom Policy rule. The metadata
         *        includes the runtime system in use, which accounts have debug logging enabled, and other custom rule
         *        metadata, such as resource type, resource ID of Amazon Web Services resource, and organization trigger
         *        types that initiate Config to evaluate Amazon Web Services resources against a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationCustomPolicyRuleMetadata(
                OrganizationCustomPolicyRuleMetadataNoPolicy organizationCustomPolicyRuleMetadata);

        /**
         * <p>
         * An object that specifies metadata for your organization's Config Custom Policy rule. The metadata includes
         * the runtime system in use, which accounts have debug logging enabled, and other custom rule metadata, such as
         * resource type, resource ID of Amazon Web Services resource, and organization trigger types that initiate
         * Config to evaluate Amazon Web Services resources against a rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationCustomPolicyRuleMetadataNoPolicy.Builder} avoiding the need to create one manually via
         * {@link OrganizationCustomPolicyRuleMetadataNoPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationCustomPolicyRuleMetadataNoPolicy.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #organizationCustomPolicyRuleMetadata(OrganizationCustomPolicyRuleMetadataNoPolicy)}.
         * 
         * @param organizationCustomPolicyRuleMetadata
         *        a consumer that will call methods on {@link OrganizationCustomPolicyRuleMetadataNoPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationCustomPolicyRuleMetadata(OrganizationCustomPolicyRuleMetadataNoPolicy)
         */
        default Builder organizationCustomPolicyRuleMetadata(
                Consumer<OrganizationCustomPolicyRuleMetadataNoPolicy.Builder> organizationCustomPolicyRuleMetadata) {
            return organizationCustomPolicyRuleMetadata(OrganizationCustomPolicyRuleMetadataNoPolicy.builder()
                    .applyMutation(organizationCustomPolicyRuleMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String organizationConfigRuleName;

        private String organizationConfigRuleArn;

        private OrganizationManagedRuleMetadata organizationManagedRuleMetadata;

        private OrganizationCustomRuleMetadata organizationCustomRuleMetadata;

        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateTime;

        private OrganizationCustomPolicyRuleMetadataNoPolicy organizationCustomPolicyRuleMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConfigRule model) {
            organizationConfigRuleName(model.organizationConfigRuleName);
            organizationConfigRuleArn(model.organizationConfigRuleArn);
            organizationManagedRuleMetadata(model.organizationManagedRuleMetadata);
            organizationCustomRuleMetadata(model.organizationCustomRuleMetadata);
            excludedAccounts(model.excludedAccounts);
            lastUpdateTime(model.lastUpdateTime);
            organizationCustomPolicyRuleMetadata(model.organizationCustomPolicyRuleMetadata);
        }

        public final String getOrganizationConfigRuleName() {
            return organizationConfigRuleName;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final String getOrganizationConfigRuleArn() {
            return organizationConfigRuleArn;
        }

        public final void setOrganizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
        }

        @Override
        public final Builder organizationConfigRuleArn(String organizationConfigRuleArn) {
            this.organizationConfigRuleArn = organizationConfigRuleArn;
            return this;
        }

        public final OrganizationManagedRuleMetadata.Builder getOrganizationManagedRuleMetadata() {
            return organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata.toBuilder() : null;
        }

        public final void setOrganizationManagedRuleMetadata(
                OrganizationManagedRuleMetadata.BuilderImpl organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata
                    .build() : null;
        }

        @Override
        public final Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata;
            return this;
        }

        public final OrganizationCustomRuleMetadata.Builder getOrganizationCustomRuleMetadata() {
            return organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.toBuilder() : null;
        }

        public final void setOrganizationCustomRuleMetadata(
                OrganizationCustomRuleMetadata.BuilderImpl organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.build()
                    : null;
        }

        @Override
        public final Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata;
            return this;
        }

        public final Collection<String> getExcludedAccounts() {
            if (excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedAccounts;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String... excludedAccounts) {
            excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final OrganizationCustomPolicyRuleMetadataNoPolicy.Builder getOrganizationCustomPolicyRuleMetadata() {
            return organizationCustomPolicyRuleMetadata != null ? organizationCustomPolicyRuleMetadata.toBuilder() : null;
        }

        public final void setOrganizationCustomPolicyRuleMetadata(
                OrganizationCustomPolicyRuleMetadataNoPolicy.BuilderImpl organizationCustomPolicyRuleMetadata) {
            this.organizationCustomPolicyRuleMetadata = organizationCustomPolicyRuleMetadata != null ? organizationCustomPolicyRuleMetadata
                    .build() : null;
        }

        @Override
        public final Builder organizationCustomPolicyRuleMetadata(
                OrganizationCustomPolicyRuleMetadataNoPolicy organizationCustomPolicyRuleMetadata) {
            this.organizationCustomPolicyRuleMetadata = organizationCustomPolicyRuleMetadata;
            return this;
        }

        @Override
        public OrganizationConfigRule build() {
            return new OrganizationConfigRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
