/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeDeliveryChannelStatus</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeliveryChannelStatusResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeDeliveryChannelStatusResponse.Builder, DescribeDeliveryChannelStatusResponse> {
    private static final SdkField<List<DeliveryChannelStatus>> DELIVERY_CHANNELS_STATUS_FIELD = SdkField
            .<List<DeliveryChannelStatus>> builder(MarshallingType.LIST)
            .memberName("DeliveryChannelsStatus")
            .getter(getter(DescribeDeliveryChannelStatusResponse::deliveryChannelsStatus))
            .setter(setter(Builder::deliveryChannelsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryChannelsStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeliveryChannelStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeliveryChannelStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELIVERY_CHANNELS_STATUS_FIELD));

    private final List<DeliveryChannelStatus> deliveryChannelsStatus;

    private DescribeDeliveryChannelStatusResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryChannelsStatus = builder.deliveryChannelsStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeliveryChannelsStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeliveryChannelsStatus() {
        return deliveryChannelsStatus != null && !(deliveryChannelsStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the status of a specified delivery channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryChannelsStatus} method.
     * </p>
     * 
     * @return A list that contains the status of a specified delivery channel.
     */
    public final List<DeliveryChannelStatus> deliveryChannelsStatus() {
        return deliveryChannelsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliveryChannelsStatus() ? deliveryChannelsStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelStatusResponse)) {
            return false;
        }
        DescribeDeliveryChannelStatusResponse other = (DescribeDeliveryChannelStatusResponse) obj;
        return hasDeliveryChannelsStatus() == other.hasDeliveryChannelsStatus()
                && Objects.equals(deliveryChannelsStatus(), other.deliveryChannelsStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeliveryChannelStatusResponse")
                .add("DeliveryChannelsStatus", hasDeliveryChannelsStatus() ? deliveryChannelsStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryChannelsStatus":
            return Optional.ofNullable(clazz.cast(deliveryChannelsStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryChannelStatusResponse, T> g) {
        return obj -> g.apply((DescribeDeliveryChannelStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDeliveryChannelStatusResponse> {
        /**
         * <p>
         * A list that contains the status of a specified delivery channel.
         * </p>
         * 
         * @param deliveryChannelsStatus
         *        A list that contains the status of a specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelsStatus(Collection<DeliveryChannelStatus> deliveryChannelsStatus);

        /**
         * <p>
         * A list that contains the status of a specified delivery channel.
         * </p>
         * 
         * @param deliveryChannelsStatus
         *        A list that contains the status of a specified delivery channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelsStatus(DeliveryChannelStatus... deliveryChannelsStatus);

        /**
         * <p>
         * A list that contains the status of a specified delivery channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DeliveryChannelStatus>.Builder}
         * avoiding the need to create one manually via {@link List<DeliveryChannelStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeliveryChannelStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #deliveryChannelsStatus(List<DeliveryChannelStatus>)}.
         * 
         * @param deliveryChannelsStatus
         *        a consumer that will call methods on {@link List<DeliveryChannelStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryChannelsStatus(List<DeliveryChannelStatus>)
         */
        Builder deliveryChannelsStatus(Consumer<DeliveryChannelStatus.Builder>... deliveryChannelsStatus);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<DeliveryChannelStatus> deliveryChannelsStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelStatusResponse model) {
            super(model);
            deliveryChannelsStatus(model.deliveryChannelsStatus);
        }

        public final List<DeliveryChannelStatus.Builder> getDeliveryChannelsStatus() {
            List<DeliveryChannelStatus.Builder> result = DeliveryChannelStatusListCopier
                    .copyToBuilder(this.deliveryChannelsStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeliveryChannelsStatus(Collection<DeliveryChannelStatus.BuilderImpl> deliveryChannelsStatus) {
            this.deliveryChannelsStatus = DeliveryChannelStatusListCopier.copyFromBuilder(deliveryChannelsStatus);
        }

        @Override
        public final Builder deliveryChannelsStatus(Collection<DeliveryChannelStatus> deliveryChannelsStatus) {
            this.deliveryChannelsStatus = DeliveryChannelStatusListCopier.copy(deliveryChannelsStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelsStatus(DeliveryChannelStatus... deliveryChannelsStatus) {
            deliveryChannelsStatus(Arrays.asList(deliveryChannelsStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelsStatus(Consumer<DeliveryChannelStatus.Builder>... deliveryChannelsStatus) {
            deliveryChannelsStatus(Stream.of(deliveryChannelsStatus)
                    .map(c -> DeliveryChannelStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDeliveryChannelStatusResponse build() {
            return new DescribeDeliveryChannelStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
