/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateDiscoveredResourceCountsRequest extends ConfigRequest implements
        ToCopyableBuilder<GetAggregateDiscoveredResourceCountsRequest.Builder, GetAggregateDiscoveredResourceCountsRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorName")
            .getter(getter(GetAggregateDiscoveredResourceCountsRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<ResourceCountFilters> FILTERS_FIELD = SdkField
            .<ResourceCountFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(GetAggregateDiscoveredResourceCountsRequest::filters)).setter(setter(Builder::filters))
            .constructor(ResourceCountFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupByKey").getter(getter(GetAggregateDiscoveredResourceCountsRequest::groupByKeyAsString))
            .setter(setter(Builder::groupByKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(GetAggregateDiscoveredResourceCountsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetAggregateDiscoveredResourceCountsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, FILTERS_FIELD, GROUP_BY_KEY_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String configurationAggregatorName;

    private final ResourceCountFilters filters;

    private final String groupByKey;

    private final Integer limit;

    private final String nextToken;

    private GetAggregateDiscoveredResourceCountsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.filters = builder.filters;
        this.groupByKey = builder.groupByKey;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public final String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * Filters the results based on the <code>ResourceCountFilters</code> object.
     * </p>
     * 
     * @return Filters the results based on the <code>ResourceCountFilters</code> object.
     */
    public final ResourceCountFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The key to group the resource counts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByKey} will
     * return {@link ResourceCountGroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupByKeyAsString}.
     * </p>
     * 
     * @return The key to group the resource counts.
     * @see ResourceCountGroupKey
     */
    public final ResourceCountGroupKey groupByKey() {
        return ResourceCountGroupKey.fromValue(groupByKey);
    }

    /**
     * <p>
     * The key to group the resource counts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupByKey} will
     * return {@link ResourceCountGroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #groupByKeyAsString}.
     * </p>
     * 
     * @return The key to group the resource counts.
     * @see ResourceCountGroupKey
     */
    public final String groupByKeyAsString() {
        return groupByKey;
    }

    /**
     * <p>
     * The maximum number of <a>GroupedResourceCount</a> objects returned on each page. The default is 1000. You cannot
     * specify a number greater than 1000. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of <a>GroupedResourceCount</a> objects returned on each page. The default is 1000. You
     *         cannot specify a number greater than 1000. If you specify 0, AWS Config uses the default.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(groupByKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateDiscoveredResourceCountsRequest)) {
            return false;
        }
        GetAggregateDiscoveredResourceCountsRequest other = (GetAggregateDiscoveredResourceCountsRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(filters(), other.filters()) && Objects.equals(groupByKeyAsString(), other.groupByKeyAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAggregateDiscoveredResourceCountsRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName()).add("Filters", filters())
                .add("GroupByKey", groupByKeyAsString()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "GroupByKey":
            return Optional.ofNullable(clazz.cast(groupByKeyAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateDiscoveredResourceCountsRequest, T> g) {
        return obj -> g.apply((GetAggregateDiscoveredResourceCountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * Filters the results based on the <code>ResourceCountFilters</code> object.
         * </p>
         * 
         * @param filters
         *        Filters the results based on the <code>ResourceCountFilters</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ResourceCountFilters filters);

        /**
         * <p>
         * Filters the results based on the <code>ResourceCountFilters</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceCountFilters.Builder} avoiding the need
         * to create one manually via {@link ResourceCountFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCountFilters.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(ResourceCountFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ResourceCountFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ResourceCountFilters)
         */
        default Builder filters(Consumer<ResourceCountFilters.Builder> filters) {
            return filters(ResourceCountFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The key to group the resource counts.
         * </p>
         * 
         * @param groupByKey
         *        The key to group the resource counts.
         * @see ResourceCountGroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCountGroupKey
         */
        Builder groupByKey(String groupByKey);

        /**
         * <p>
         * The key to group the resource counts.
         * </p>
         * 
         * @param groupByKey
         *        The key to group the resource counts.
         * @see ResourceCountGroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCountGroupKey
         */
        Builder groupByKey(ResourceCountGroupKey groupByKey);

        /**
         * <p>
         * The maximum number of <a>GroupedResourceCount</a> objects returned on each page. The default is 1000. You
         * cannot specify a number greater than 1000. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of <a>GroupedResourceCount</a> objects returned on each page. The default is 1000.
         *        You cannot specify a number greater than 1000. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private ResourceCountFilters filters;

        private String groupByKey;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateDiscoveredResourceCountsRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            filters(model.filters);
            groupByKey(model.groupByKey);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        @Transient
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final ResourceCountFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ResourceCountFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        @Transient
        public final Builder filters(ResourceCountFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getGroupByKey() {
            return groupByKey;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        @Override
        @Transient
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        @Override
        @Transient
        public final Builder groupByKey(ResourceCountGroupKey groupByKey) {
            this.groupByKey(groupByKey == null ? null : groupByKey.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAggregateDiscoveredResourceCountsRequest build() {
            return new GetAggregateDiscoveredResourceCountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
